@extends('onboarding.main')


@section('title', 'Page Title')

@section('content')


<div class="overlay-seller-bg-dashboard">
    <div class="overlay text-center">
        <h1>Vervollständigen Sie Ihr Profil</h1>
        <form class="" id="reduced-overlay-form-seller" role="form" method="POST" enctype="multipart/form-data"
              action="{{route('onboarding-seller-update-accountImg-newsletter')}}">
                    {{csrf_field()}}
            <div class="row">
                <div class="form-group">
                    <img data-lightbox="image-1" class="account-image" id="logoOutput"
                         src="@if(Auth::user()->account->upload_portrait != ''){{ route('account-portrait', Auth::user()->account->upload_portrait) }}@else{{ '/img/logo_company.png' }}@endif">
                </div>
            </div>
            <div class="row">
                <div class="form-group">

                <input name="upload_portrait" type="file" accept="image/*"
                       class="btn btn-primary btn-block" id="logoInp">
                <p class="overlay-smallText" >Laden Sie jetzt Ihr Firmenlogo hoch</p>
                </div>
            </div>
            <div class="row">
                <div class="form-group col-lg-2 col-md-4 col-sm-6 col-xs-8 col-lg-offset-5 col-md-offset-4 col-sm-offset-3 col-xs-offset-2 {{ $errors->has('all_connections') ? ' has-error' : '' }}">

                    <select size="1" name="all_connections" id="all_connections" class="form-control" >
                        <option disabled selected>
                            Wer darf Sie empfehlen*
                        </option>
                        <option value="1">
                            Jeder
                        </option>
                        <option value="0">
                            Nur von mir eingeladene
                        </option>
                    </select>
                    @if ($errors->has('all_connections'))
                        <span class="help-block">
                                    <strong>{{ $errors->first('all_connections') }}</strong>
                                </span>
                    @endif
                </div>
            </div>
            <div class="row">
                <div class="form-group">
                    <label class="checkbox-inline">
                        <input type="checkbox" id="newsletter" name="newsletter" value="newsletter">Newsletter abbonieren
                    </label>
                </div>
            </div>
            <div class="row">
                <div class="form-group col-md-4  col-md-offset-4 ">
                    <br>
                    <button type="submit" class="btn btn-success">Daten speichern</button>
                </div>
                <br>
            </div>
        </form>
    </div>
</div>


@endsection

@section('after-scripts')
    <script type="text/javascript">
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                if (/imgInp/.test(input.id)) {
                    reader.onload = function (e) {
                        $('#imgOutput').attr('src', 'data:image/gif;base64,R0lGODlhAQABAIABAP///wAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==');
                        $('#imgOutput').attr('style', 'background-image: url(' + e.target.result + ')');
                    }
                }

                if (/logoInp/.test(input.id)) {
                    reader.onload = function (e) {
                        $('#logoOutput').attr('src', 'data:image/gif;base64,R0lGODlhAQABAIABAP///wAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==');
                        $('#logoOutput').attr('style', 'background-image: url(' + e.target.result + ')');
                    }
                }

                reader.readAsDataURL(input.files[0]);
            }
        }

        $("#imgInp").change(function () {
            readURL(this);
        });

        $("#logoInp").change(function () {
            readURL(this);
        });
    </script>
@endsection