@extends('onboarding.main')

@section('content')
    <!--Overlay show seller-->
    <div class="overlay-seller-bg-dashboard">
        <div class="overlay text-center">
            <h1>Errichten Sie Ihr persönliches Empfehlernetzwerk</h1>
            <p>Laden Sie begeisterte Kunden, Freunde, Geschäftspartner und Familie zu RECO.MA ein.<br>
                Diese Kontakte bilden das Fundament Ihres Erfolges
            </p>
            <form method="post" class="form-horizontal" action="{{route('onboarding-seller-invite-agents')}}" name="inviteAgentForm" id="inviteAgentForm">
                {{ csrf_field() }}
                <div class="form-group">
                    <div class="col-lg-4 col-lg-offset-4 col-sm-6 col-sm-offset-3 col-text-center">
                        @for($i=0;$i<5;$i++)
                            <div class="form-group email-input">
                                <div class="col-lg-12">
                                    <input type="email" class="form-control" name="invitedAgentEmail[{{$i}}]" aria-describedby="emailHelp" placeholder="E-Mail Adresse des Empfehlers" value="{{ old('invitedAgentEmail.'.$i) }}">
                                    @if ($errors->has('invitedAgentEmail.'.$i))
                                        <span class="help-block">
                                         <strong>{{ $errors->first('invitedAgentEmail.'.$i) }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                       @endfor
                        <div class="form-group">
                            <div class="col-lg-12 ">
                                <a id="add-email-inputs">Mehr Empfehler zu RECO.MA einladen</a>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-lg-12">
                                <button type="submit" class="btn btn-success" >Empfehler einladen</button>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-lg-12">
                                <a href="{{route('onboarding-seller',['increase'=>true])}}" id="proceed-coupon">überspringen</a>
                            </div>
                        </div>
                    </div>
                </div>
                {!! JsValidator::formRequest('App\Http\Requests\OverlaySellerInviteAgentsRequest','#inviteAgentForm') !!}
            </form>
        </div>
    </div>
<script>

    $('#add-email-inputs').click(function () {
        for(var i=0;i<3;i++) {
            $('form div.email-input').last().after(
                "<div class='form-group email-input'>" +
                "<div class='col-lg-12')>" +
                "<input type=\"email\" class=\"form-control\" name=\"invitedAgentEmail[]\" + aria-describedby=\"emailHelp\" placeholder=\"E-Mail Adresse des Empfehlers\">" +
                "</div>" +
                "</div>");
        }
    });
</script>
@endsection