@extends('onboarding.main')

@section('content')


    <!--Overlay show seller-->
    <div class="overlay-seller-bg-dashboard">
        <div class="overlay text-center">
            <h1>Erstellen Sie Ihre erste Kampagne</h1>
            <p>Ihre Empfehler werden diesen RECO.BON an interessierte Kontakte versenden.</p>
                <div class="row coupon-create create-coupon-from-overlay">
                    <div class="col-lg-4 col-lg-offset-2 col-md-12">
                        <form id="couponCreateOrEditOverlay" class="form-horizontal" role="form" method="POST" enctype="multipart/form-data"
                              action="{{route('onboarding-seller-create-coupon',['fromOverlay'=>true])}}">
                            {{ csrf_field() }}

                            @include('coupon.partials.form')

                            <div class="form-group">
                                <div class="col-sm-9 col-sm-offset-3 text-right">
                                    <button class="btn btn-primary" type="submit">RECO.BON Erstellen</button>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="col-sm-4 col-sm-offset-8 text-right">
                                    <a href="{{route('onboarding-seller',['increase'=>true])}}" id="proceed-coupon">überspringen</a>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-lg-4 col-lg-offset-1 col-md-12 coupon-overlay seller">
                        @include('onboarding.seller.coupon', [
                            'template' => Auth::user()->fakeTemplate()
                        ])
                    </div>
                </div>
        </div>

    </div><!--end Overlay Agent Welcome-->
    <script type="text/javascript">
        $(document).ready(function () {
            function readURL(input) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();

                    reader.onload = function(e) {
                        $('#couponImg').attr('src', e.target.result);
                    };

                    reader.readAsDataURL(input.files[0]);
                }
            }

            $("#pictureInput").change(function() {
                readURL(this);
            });

            $('input[name="type_discount"]').on('change', function () {
                var value = $('input[name="type_discount"]:checked').val();
                var icon = $('input[name="type_discount"]:checked').data('icon');
                $('.unit').html(icon);
                if ('{{ App\CouponTemplate::TYPE_GIFT }}' === value) {
                    $('#discountNumericHolder').hide();
                    $('#discountGiftHolder').show();
                } else {
                    $('#discountNumericHolder').show();
                    $('#discountGiftHolder').hide();
                }
            });

            $('input[name="type_provision"]').on('change', function () {
                var value = $('input[name="type_provision"]:checked').val();
                var icon = $('input[name="type_provision"]:checked').data('icon');
                $('.unit_recocash').html(icon);
                if ('{{ App\CouponTemplate::TYPE_NONE }}' === value) {
                    $('#provisionNumericHolder').hide();
                    $('#provisionGiftHolder').hide();
                } else if ('{{ App\CouponTemplate::TYPE_GIFT }}' === value) {
                    $('#provisionNumericHolder').hide();
                    $('#provisionGiftHolder').show();
                } else {
                    $('#provisionNumericHolder').show();
                    $('#provisionGiftHolder').hide();
                }
            });
        });
    </script>
@endsection

