@extends('onboarding.main')


@section('title', 'Page Title')

@section('content')

    <div class="overlay-seller-bg-dashboard">
        <div class="overlay text-center" id="complete-profile-form">

            <h1>Vervollständigen Sie Ihr Profil</h1>
            <p>Es fehlen nur noch Ihre Zahlungsdaten</p>
            <form class="" id="userEditFormPayment" role="form" method="POST" enctype="multipart/form-data"
                  action="{{route('onboarding-seller-update-payment-company')}}">
                {{csrf_field()}}

                <div class="row">
                    <div class="form-group col-md-4 col-md-offset-4 {{ $errors->has('payment') ? ' has-error' : '' }}">
                        <select name="payment" size="1" id="payment" class="form-control">
                            <option disabled selected>
                                Zahlungsart*
                            </option>
                            <option value="year" @if(old('payment')=='year') selected @endif>
                                Jährlich &nbsp; &nbsp; &nbsp; 637,20€ zzgl. MwSt
                            </option>
                            <option value="month" @if(old('payment')=='month') selected @endif>
                                Monatlich &nbsp; &nbsp; 59,00€ zzgl. MwSt
                            </option>
                        </select>
                        @if ($errors->has('payment'))
                            <span class="help-block">
                                <strong>{{ $errors->first('payment') }}</strong>
                            </span>
                        @endif
                    </div>
                </div>

                <div class="row">
                    <div class="form-group col-md-4 col-md-offset-4  {{ $errors->has('iban_owner') ? ' has-error' : '' }}">
                        <input id="iban_owner" type="text" class="form-control" name="iban_owner"
                               placeholder="Kontoinhaber*" value="{{ old('iban_owner') }}">
                        @if ($errors->has('iban_owner'))
                            <span class="help-block">
                                    <strong>{{ $errors->first('iban_owner') }}</strong>
                                </span>
                        @endif
                    </div>
                </div>

                <div class="row">
                    <div class=" form-group col-md-4 col-md-offset-4 {{ $errors->has('iban') ? ' has-error' : '' }}">
                        <input id="iban" type="text" class="form-control" name="iban" placeholder="IBAN*"
                               value="{{ old('iban') }}">
                        @if ($errors->has('iban'))
                            <span class="help-block">
                                    <strong>{{ $errors->first('iban') }}</strong>
                                </span>
                        @endif
                    </div>
                </div>
                <div class="row text-left">
                    <div class="form-group col-md-4 col-md-offset-4 {{ $errors->has('sepa') ? ' has-error' : '' }}">
                        <label class="checkbox-inline">
                            <input type="checkbox" id="sepa" name="sepa" value="sepa">Der Kontoinhaber ermächtigt die
                            RECO.MA
                            GmbH, Zahlungen per Lastschrift von seinem Konto einzuziehen. Zugleich weist der
                            Kontoinhaber sein Kreditinstitut
                            an, die von der RECO.MA GmbH auf sein Konto gezogenen Lastschriften einzulösen.
                            @if ($errors->has('sepa'))
                                <span class="help-block">
                                            <strong>{{ $errors->first('sepa') }}</strong>
                                        </span>
                            @endif
                        </label>
                    </div>
                </div>

                <div class="row text-left">
                    <div class="form-group col-md-4 col-md-offset-4 {{ $errors->has('data-protection-agb') ? ' has-error' : '' }}">
                        <label class="checkbox-inline">
                            <input type="checkbox" id="data-protection-agb" name="data-protection-agb"
                                   value="data-protection-agb">
                            Hiermit bestätigen Sie, dass Sie mit unseren <a href="/pdf/agb/reco.ma_agb_partner.pdf"
                                                                            target="_blank">AGB</a>, den <a
                                    href="/pdf/data-protection/reco.ma_datenschutzerklärung_partner.pdf"
                                    target="_blank">Datenschutzrichtlinien</a> und der Verwendung von Cookies
                            einverstanden sind.
                            @if ($errors->has('data-protection-agb'))
                                <span class="help-block">
                                            <strong>{{ $errors->first('data-protection-agb') }}</strong>
                                        </span>
                            @endif
                        </label>
                    </div>
                </div>

                <div class="row">
                    <div class="form-group col-md-4  col-md-offset-4 ">
                        <br>
                        <button type="submit" class="btn btn-success">Unternehmen anlegen</button>
                    </div>
                    <br>
                </div>
                {!! JsValidator::formRequest('App\Http\Requests\OverlaySellerRequestPayment','#userEditFormPayment') !!}
            </form>
        </div>
    </div>
    </div>
    </div>

@endsection

@section('after-scripts')
    <script type="text/javascript">
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                if (/imgInp/.test(input.id)) {
                    reader.onload = function (e) {
                        $('#imgOutput').attr('src', 'data:image/gif;base64,R0lGODlhAQABAIABAP///wAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==');
                        $('#imgOutput').attr('style', 'background-image: url(' + e.target.result + ')');
                    }
                }

                if (/logoInp/.test(input.id)) {
                    reader.onload = function (e) {
                        $('#logoOutput').attr('src', 'data:image/gif;base64,R0lGODlhAQABAIABAP///wAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==');
                        $('#logoOutput').attr('style', 'background-image: url(' + e.target.result + ')');
                    }
                }

                reader.readAsDataURL(input.files[0]);
            }
        }

        $("#imgInp").change(function () {
            readURL(this);
        });

        $("#logoInp").change(function () {
            readURL(this);
        });
    </script>
@endsection