@extends('onboarding.main')


@section('title', 'Page Title')

@section('content')

    <div class="overlay-seller-bg-dashboard">
        <div class="overlay text-center" id="complete-profile-form">

            <h1>Vervollständigen Sie Ihr Profil</h1>
            <p>Um RECO.MA vollständig nutzen zu können, benötigen wir noch einige Angaben</p>
            <div class="row profile-form-wrapper">
                <form class="" id="userEditForm" role="form" method="POST" enctype="multipart/form-data"
                      action="{{route('onboarding-seller-update-profile-company')}}">
                    {{csrf_field()}}
                    <div class="col-lg-4 col-lg-offset-2 left-col-profile-form">
                        <div class="row clearfix">
                            <div class="form-group col-lg-5">
                                <img data-lightbox="image-1" class="account-image" id="logoOutput"
                                     src="@if(Auth::user()->account->upload_portrait != ''){{ route('account-portrait', Auth::user()->account->upload_portrait) }}@else{{ '/img/logo_company.png' }}@endif">
                            </div>
                            <div class="form-group col-lg-7 logo-upload-wrapper-button">
                                <input name="upload_portrait" type="file" accept="image/*"
                                       class="btn btn-primary btn-block" id="logoInp">
                                <p class="overlay-smallText">Laden Sie jetzt Ihr Firmenlogo hoch</p>
                            </div>
                        </div>
                        &nbsp;<!--fix margin-bug on Ipad-Pro screen-size-->
                        <div class="row">
                            <div class="form-group col-lg-9 {{ $errors->has('street') ? ' has-error' : '' }}">
                                <input id="street" type="text" class="form-control" name="street" placeholder="Straße*"
                                       value="{{ old('street') }}">
                                @if ($errors->has('street'))
                                    <span class="help-block">
                                            <strong>{{ $errors->first('street') }}</strong>
                                        </span>
                                @endif
                            </div>
                            <div class="form-group col-lg-3 {{ $errors->has('housenumber') ? ' has-error' : '' }}">
                                <input id="housenumber" type="text" class="form-control" name="housenumber"
                                       placeholder="Nr.*" value="{{ old('housenumber') }}">
                                @if ($errors->has('housenumber'))
                                    <span class="help-block">
                                            <strong>{{ $errors->first('housenumber') }}</strong>
                                        </span>
                                @endif
                            </div>
                        </div>

                        <div class="row">
                            <div class="form-group col-lg-4 {{ $errors->has('zip') ? ' has-error' : '' }}">
                                <input id="zip" type="text" class="form-control" name="zip" placeholder="PLZ*"
                                       value="{{ old('zip') }}">
                                @if ($errors->has('zip'))
                                    <span class="help-block">
                                            <strong>{{ $errors->first('zip') }}</strong>
                                        </span>
                                @endif
                            </div>
                            <div class="form-group col-lg-8 {{ $errors->has('city') ? ' has-error' : '' }}">
                                <input id="city" type="text" class="form-control" name="city" placeholder="Ort*"
                                       value="{{ old('city') }}">
                                @if ($errors->has('city'))
                                    <span class="help-block">
                                    <strong>{{ $errors->first('city') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-lg-12 {{ $errors->has('phone') ? ' has-error' : '' }}">

                                <input id="phone" type="text" class="form-control" name="phone"
                                       placeholder="Telefonnummer*" value="{{ old('phone') }}">

                                @if ($errors->has('phone'))
                                    <span class="help-block">
                                            <strong>{{ $errors->first('phone') }}</strong>
                                        </span>
                                @endif
                            </div>
                        </div>
                    </div><!--end left column-->


                    <!--start right column-->1
                    <div class="col-lg-4  right-col-profile-form">
                        <div class="row">
                            <div class="form-group col-lg-12 {{ $errors->has('all_connections') ? ' has-error' : '' }}">
                                <select size="1" name="all_connections" id="all_connections" class="form-control">
                                    <option disabled selected>
                                        Wer darf Sie empfehlen*
                                    </option>
                                    <option value="1">
                                        Jeder
                                    </option>
                                    <option value="0">
                                        Nur von mir eingeladene
                                    </option>
                                </select>
                                @if ($errors->has('all_connections'))
                                    <span class="help-block">
                                    <strong>{{ $errors->first('all_connections') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>

                        <div class="row text-left">
                            <div class="form-group col-lg-12">
                                <label class="checkbox-inline">
                                    <input type="checkbox" id="newsletter" name="newsletter" value="newsletter">Newsletter
                                    abbonieren
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-lg-6  col-lg-offset-3 ">
                            <br>
                            <button type="submit" class="btn btn-success">Unternehmen anlegen</button>

                        </div>
                        <br>
                    </div>
                    {!! JsValidator::formRequest('App\Http\Requests\OverlaySellerRequestCompany','#userEditForm') !!}
                </form>
            </div>
        </div>
    </div>
    </div>

    <?php ?>
@endsection

@section('after-scripts')
    <script type="text/javascript">
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                if (/imgInp/.test(input.id)) {
                    reader.onload = function (e) {
                        $('#imgOutput').attr('src', 'data:image/gif;base64,R0lGODlhAQABAIABAP///wAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==');
                        $('#imgOutput').attr('style', 'background-image: url(' + e.target.result + ')');
                    }
                }

                if (/logoInp/.test(input.id)) {
                    reader.onload = function (e) {
                        $('#logoOutput').attr('src', 'data:image/gif;base64,R0lGODlhAQABAIABAP///wAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==');
                        $('#logoOutput').attr('style', 'background-image: url(' + e.target.result + ')');
                    }
                }

                reader.readAsDataURL(input.files[0]);
            }
        }

        $("#imgInp").change(function () {
            readURL(this);
        });

        $("#logoInp").change(function () {
            readURL(this);
        });
    </script>
@endsection