<!DOCTYPE html>
<html lang="de" xml:lang="de" xmlns= "http://www.w3.org/1999/xhtml">

<head>

    <meta http-equiv="Content-Language" content="de">

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>reco.ma</title>

    <link href="{{ URL::asset('css/bootstrap.min.css') }}" rel="stylesheet">
    <link rel="stylesheet"
          href="{{ url::asset('bower_components/bootstrap-big-grid/dist/css/bootstrap-big-grid.min.css') }}"/>
    <link href="{{ URL::asset('font-awesome/css/font-awesome.css') }}" rel="stylesheet">

    <!-- Toastr style -->
    <link href="{{ URL::asset('css/plugins/toastr/toastr.min.css') }}" rel="stylesheet">

    <!-- Gritter -->
    <link href="{{ URL::asset('js/plugins/gritter/jquery.gritter.css') }}" rel="stylesheet">

    <link href="{{ URL::asset('css/plugins/jQueryUI/jquery-ui.css') }}" rel="stylesheet">
    <link href="{{ URL::asset('css/animate.css') }}" rel="stylesheet">
    <link href="{{ URL::asset('css/plugins/toastr/toastr.min.css') }}" rel="stylesheet">
    <link href="{{ URL::asset('css/plugins/datapicker/datepicker3.css') }}" rel="stylesheet">
    <link href="{{ URL::asset('css/plugins/starrating/star-rating.min.css') }}" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.3/css/select2.min.css" rel="stylesheet"/>

    <!-- c3 Charts -->
    <link href="/css/animate.css" rel="stylesheet">
    <link href="/css/plugins/c3/c3.min.css" rel="stylesheet">
    <link href="{{ URL::asset('css/style.css') }}" rel="stylesheet">
    <link href="{{ URL::asset('css/app.css') }}" rel="stylesheet">

    <script src="{{ URL::asset('js/jquery-2.1.1.js') }}"></script>



</head>

<body>

@include('partials.scripts')


@yield('content')

<script type="text/javascript">
    $(".select2-groups").select2();
    //Toastr Notification
    toastr.options = {
        "closeButton": true,
        "debug": false,
        "newestOnTop": true,
        "progressBar": true,
        "positionClass": "toast-top-center",
        "preventDuplicates": false,
        "onclick": null,
        "showDuration": "300",
        "hideDuration": "300",
        "timeOut": "5000",
        "extendedTimeOut": "5000",
        "showEasing": "swing",
        "hideEasing": "linear",
        "showMethod": "fadeIn",
        "hideMethod": "fadeOut"
    }

    $(document).ready(function () {
        $('#filterButton').click(function () {
            $('#filterDiv').toggle(400);
        });
        $(window).scroll(function () {
            if ($(window).scrollTop() > 50) {
                $('#backToPageTop').fadeIn('fast');
            } else {
                $('#backToPageTop').fadeOut();
            }
        });
        $('#backToPageTop').click(function () {
            $('body, html').animate({scrollTop: 0}, 500);
        });
    });


    function readURL(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();

            if (/imgInp/.test(input.id)) {
                reader.onload = function (e) {
                    $('#imgOutput').attr('src', 'data:image/gif;base64,R0lGODlhAQABAIABAP///wAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==');
                    $('#imgOutput').attr('style', 'background-image: url(' + e.target.result + ')');
                }
            }

            if (/logoInp/.test(input.id)) {
                reader.onload = function (e) {
                    $('#logoOutput').attr('src', 'data:image/gif;base64,R0lGODlhAQABAIABAP///wAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==');
                    $('#logoOutput').attr('style', 'background-image: url(' + e.target.result + ')');
                }
            }

            reader.readAsDataURL(input.files[0]);
        }
    }

    $("#imgInp").change(function () {
        readURL(this);
    });

    $("#logoInp").change(function () {
        readURL(this);
    });

    $(".topfive, .output-rating").rating({
        readonly: true,
        language: 'de',
        showClear: false,
        size: 'xs',
        showCaption: false
    });

    @if(Session::has('notification'))
        toastr['{{Session::get('notification')['type']}}']('{{Session::get('notification')['description']}}', '{{Session::get('notification')['title']}}');

    @endif
</script>

<script src="{{ URL::asset('js/app.js') }}"></script>
</body>
</html>