@extends('onboarding.main')

@section('content')
    <!--Overlay list seller-->
    <div class="overlay-agent-bg-dashboard">
        <div class="overlay agent">
            <h1 class="text-center with-margin-bottom">Kennst Du diese Unternehmen aus Deiner Region?</h1>
            <form method="post" id="form-agent-knows-seller" action="{{route('onboarding-agent-notice-seller')}}">
                {{csrf_field()}}
                @foreach($allSellers as $indexkey => $sellerModal)
                    @if($indexkey % 4 == 0) <div class="row"> @endif
                        <div class="col-md-3 text-center show-seller-wrapper">
                            <img class="img-rounded avatar-overlay" src="/account/portraits/{{$sellerModal->upload_portrait}}"
                                 alt="Card image cap" width="120">
                            <h2>{{$sellerModal->company}}</h2>
                            <div class="star-rating">
                                {!!Format::rating($sellerModal->averageRating)!!}
                            </div>
                            <div data-toggle="buttons" class="btn-notice-seller clearfix">
                                <label class="btn btn-warning agent-knows-seller">
                                    <input type="checkbox"
                                           name="checkbox-agent-knows-seller[]" autocomplete="off"
                                           value="{{$sellerModal->id}}">
                                    <span class="active">Kenne ich</span>
                                    <img src='/img/icons/checkmark_g.svg'>
                                </label>
                            </div>
                        </div>
                        @if($indexkey % 4 == 3 || (count($allSellers)==1) ||(count($allSellers)  == $indexkey+1)) </div> @endif
                @endforeach
                <div class="row">

                    <div class="proceed-button-agent">
                        <div class="form-group col-md-2 col-md-offset-5 text-center">
                            <button type="submit" class="btn btn-success">weiter</button>
                        </div>
                    </div>
                    <div class="form-group col-md-4 col-md-offset-4 text-center">
                        <a href="{{route('onboarding-agent',['showMaxSeller'=> 1])}}" class="show-all-seller-link">alle
                            Unternehmen anzeigen</a>
                    </div>
                </div>

            </form>
        </div><!--end Overlay show-seller-->
    </div>

    <script>
        $('label.agent-knows-seller input').change(function () {
            var label = $(this).parent(); //span and img are inside label
            if (label.find('span').hasClass('active')) {
                label.find('span').removeClass('active');
                label.find('img').addClass('active');
                label.removeClass('btn-warning');
            } else {
                label.addClass('btn-warning')
                label.find('span').addClass('active');
                label.find('img').removeClass('active');
            }
        });
    </script>
@endsection