@extends('onboarding.main')

@section('content')
    <div class="overlay-agent-bg-dashboard recommend-seller">
        <div class="overlay agent">
            <h1 class="text-center with-margin-bottom">Empfehle jetzt an Deine Freunde</h1>
            <div class="row">
                @if(isset($availableSellersToRecommend))
                    @foreach($availableSellersToRecommend as $connection)
                        <div class="col-md-3 col-sm-4 col-xs-6 text-center recommend-seller-wrapper">
                            <img class="img-rounded avatar-overlay" src="/account/portraits/{{$connection->upload_portrait}}" alt="Card image cap" width="120">
                            <h2>{{$connection->company}}</h2>
                            <div class="star-rating">
                                {!!Format::rating($connection->averageRating)!!}
                            </div>
                            <br>
                            <div id="button-wrapper" class="row recommend-button-wrapper clearfix">
                                <a class="btn btn-success" href="{{route('linkinvitation', ['reason' => 'share-seller', 'id' =>$connection->id, 'type' => 'whatsapp'])}}" data-href="" target="_blank">Whatsapp</a>
                                <a class="btn btn-primary" href="{{route('linkinvitation', ['reason' => 'share-seller', 'id' =>$connection->id, 'type' => 'email'])}}" data-href="">Email</a>
                                <a class="btn btn-warning" href="{{route('linkinvitation', ['reason' => 'share-seller', 'id' =>$connection->id, 'type' => 'sms'])}}" data-href="">SMS</a>
                            </div>
                        </div>
                    @endforeach
                @endif
            </div>
            <div class="row proceed-button-agent">
                <div class="form-group col-md-2 col-md-offset-5 text-center">
                    <a href="{{route('onboarding-agent',['increase'=>true])}}" class="btn btn-success">weiter</a>
                </div>
            </div>
            @if($allSellersShown == false)
                <div class="row">
                    <div class="form-group col-md-4 col-md-offset-4 text-center">
                        <a href="{{route('onboarding-agent',['showMaxSeller'=> 1])}}" class="show-all-seller-link" >alle Unternehmen anzeigen</a>
                    </div>
                </div>
            @endif
        </div><!--end Overlay show-seller-->
    </div>


@endsection