<?php
/**
 * Shows a coupon or a multi coupon or a preview of a template with a specfic agent
 *
 * @param $coupon The Coupon (can be empty if a coupon-template is provided)
 * @param $template Coupon Template (can be empty if an actual coupon is provided)
 * @param $agent The agent (can be empty if coupon is provided)
 * @param bool $selectionDummy Show as Multi-Coupon Dummy (Card Stack)
 */

use App\Coupon;

// mode: multicoupon, not yet specified coupon (preview mode)
if (isset($seller) & !isset($template)) {
    $template = $seller->couponTemplates()->first();
    $selectionDummy = true;
}

// mode: specific coupon specified, fetching the template for display reasons
if (!isset($template)) {
    $template = $coupon->template;
}

// mode: specific coupon specified, fetching the seller for display reasons
if (!isset($seller)) {
    $seller = $template->seller->account;
}

// mode: specific coupon specified, fetching the agent --- or the fakeAgent if there is not specific coupon
if (!isset($agent)) { //FIXME: ohne agent zulassen für seller-vorschau
    $agent = isset($coupon) ? $coupon->agent : null;
}

// show as dummy
$selectionDummy = isset($selectionDummy) ? $selectionDummy : false;

if (isset($coupon) && $coupon->status == Coupon::STATUS_PENDING) {
    if ($coupon->selection) {
        $hideCode = true;
    }
}

if (isset($coupon)) {
    $maxCashBack = $coupon->getMaxCashback();
} else {
    $maxCashBack = $seller->getSellerMaxCashback();
}

?>
<div class="coupon-wrapper">
    <div class="display-coupon @if($selectionDummy) cards-pile @endif pull-right">
        <div class="panel-heading" id="head">
            <div class="" id="title">
                @if($seller->upload_portrait != '')
                    <img src="{{ route('user-portrait', $seller->upload_portrait) }}">
                @else
                    <img src="/img/logo_200x56.png">
                @endif
                <div class="pull-right"><span class="pull-left"><h3>
                        RECO.BON</h3></span>
                </div>
            </div>
        </div>
        <div class="panel-body coupon-body">
            <div class="col-md-12">
                <div class="coupon-title">
                    <h2>{{ $selectionDummy ? 'Wahl Gutschein' : $template->title }}</h2>
                </div>
                <div class="coupon-description">
                    <p>{{ $selectionDummy ? 'Öffnen Sie den Gutschein durch Klick' : $template->description }}</p>
                </div>
                <strong>Einzulösen bei</strong><br>
                <a class=""
                   href="{{ route('show-seller-account', $seller->id) }}">{{ $seller->company }}</a><br>
                {{ $seller->street }} {{ $seller->housenumber }}
                <br>
                {{ $seller->zip }} {{ $seller->city }}
                <br>
                Tel. {{ $template->seller->phone }} <br>
                </span>
            </div>

        </div>
        <div class="panel-footer">
            <div class="coupon-code">
                <strong>RECO.CODE:
                    @if (isset($coupon) && !isset($hideCode))
                        {{ $coupon->getCodeFormatted() }}
                    @else
                        VOR SCH AU!
                    @endif
                </strong><br>
                Empfehler:
                @if($agent)
                    <a class="" href="{{ $agent->getProfileUrl(App\User::AGENT) }}"> {{ $agent->getDisplayName() }}</a>
                @else
                    ?
                @endif
            </div>
            <div class="exp coupon-expiration-date">
                <p>Gültigkeit:
                    <span>
                    @if (isset($coupon))
                            {{ Format::date($coupon->validity_date) }}
                        @else
                            ?
                        @endif
                </span>
                </p>
            </div>

            <div>
                <a class="barcode">
                    @if (isset($coupon) && !isset($hideCode))
                        <img src="data:image/png;base64,{{ DNS1D::getBarcodePNG($coupon->code, 'C128') }}"
                             alt="barcode"/>
                    @else
                        <img src="data:image/png;base64,{{ DNS1D::getBarcodePNG('VORSCHAU!', 'C128') }}"
                             alt="barcode"/>
                    @endif
                </a>
            </div>
            <div class="offer pull-right">
                <span class="coupon-discount">@if($selectionDummy)
                        <span class="upto">bis zu</span> {{ Format::percent($maxCashBack) }}
                    @else {{ Format::percent($template->discount_consumer) }} @endif </span>
            </div>
        </div>

    </div>
</div>