@extends('layouts.root')

@section('head.links')
    <link href="{{ URL::asset('css/bootstrap.min.css') }}" rel="stylesheet">
    <link rel="stylesheet"
          href="{{ url::asset('bower_components/bootstrap-big-grid/dist/css/bootstrap-big-grid.min.css') }}"/>
    <link href="{{ URL::asset('font-awesome/css/font-awesome.css') }}" rel="stylesheet">

    <!-- Toastr style -->
    <link href="{{ URL::asset('css/plugins/toastr/toastr.min.css') }}" rel="stylesheet">

    <!-- Gritter -->
    <link href="{{ URL::asset('js/plugins/gritter/jquery.gritter.css') }}" rel="stylesheet">

    <link href="{{ URL::asset('css/plugins/jQueryUI/jquery-ui.css') }}" rel="stylesheet">
    <link href="{{ URL::asset('css/animate.css') }}" rel="stylesheet">
    <link href="{{ URL::asset('css/plugins/toastr/toastr.min.css') }}" rel="stylesheet">
    <link href="{{ URL::asset('css/plugins/datapicker/datepicker3.css') }}" rel="stylesheet">
    <link href="{{ URL::asset('css/plugins/starrating/star-rating.min.css') }}" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.3/css/select2.min.css" rel="stylesheet"/>

    <!-- c3 Charts -->
    <link href="/css/animate.css" rel="stylesheet">
    <link href="/css/plugins/c3/c3.min.css" rel="stylesheet">
    <link href="{{ URL::asset('css/style.css') }}" rel="stylesheet">
    <link href="{{ URL::asset('css/app.css') }}" rel="stylesheet">
    <link href="{{ URL::asset('css/introjs.css') }}" rel="stylesheet">
    <script src="{{ URL::asset('js/jquery-2.1.1.js') }}"></script>
    <link href="{{ URL::asset('css/guide.css') }}" rel="stylesheet">
    <script src="{{ URL::asset('js/guide.js') }}"></script>
@endsection

@section('body.class', 'md-skin canvas-menu mini-navbar')
@section('body')
    <div id="wrapper">
        @if(isset($navigationElements))
            @include('layouts.sidebar')
        @endif
        <div id="page-wrapper" class="gray-bg dashbard-1">
            <div class="row border-bottom">
                @include('layouts.top')
            </div>

            <div class="wrapper wrapper-content">
                @if($incompleteProfile)
                    <div class="row">
                        <div class="col-md-12">
                            <div class="ibox info float-e-margins">
                                <div class="ibox-content">
                                    @if(Auth::user()->hasRole('seller'))
                                        <p>Um RECO.BON Vorlagen erstellen zu können, müssen Sie Ihr Profil und ihr
                                            Firmenprofil zunächst vervollständigen. <a href="/user/profile">Profil</a>
                                        </p>
                                    @else
                                        @if ($user->checkHasToFillTheProfile())
                                            <p>Um fortzufahren, müssen Sie Ihr Profil zunächst vervollständigen.</p>
                                        @else
                                            <p>Bitte vervollständige Deine <a href="/user/profile">Profildaten</a>.</p>
                                        @endif
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                @endif

                @if(Auth::user()->getRateableTransactionsCount() > 0)
                    <div class="row">
                        <div class="col-md-12">
                            <div class="ibox info float-e-margins">
                                <div class="ibox-title">
                                    <h4>Wichtig</h4>
                                </div>
                                <div class="ibox-content">
                                    @if(Auth::user()->hasRole('consumer'))
                                        <p>Um sich das Geld auszahlen zu lassen müssen Sie zunächst eine Bewertung der
                                            Dienstleistung abgeben. Bitte klicken Sie <a href="/transaction">hier</a>.
                                        </p>
                                    @else
                                        <p>Um sich das Geld auszahlen zu lassen müssen Sie zunächst die Transaktion
                                            bestätigen. Bitte klicken Sie <a href="/transaction">hier</a>.</p>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                @endif

                @if($bookedBack)
                    <div class="row">
                        <div class="col-md-12">
                            <div class="ibox info float-e-margins">
                                <div class="ibox-content">
                                    <p>
                                        Eine SEPA Lastschrift wurde zurück gebucht.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif

                @yield('content')
            </div>
        </div>
        <div id="backToPageTop"><span class="glyphicon glyphicon-chevron-up"></span></div>
    </div>
    @include('partials.footer-auth')
@endsection

@section('after-scripts-global')

    <script type="text/javascript">
        $(".select2-groups").select2();
        //Toastr Notification
        toastr.options = {
            "closeButton": true,
            "debug": false,
            "newestOnTop": true,
            "progressBar": true,
            "positionClass": "toast-top-center",
            "preventDuplicates": false,
            "onclick": null,
            "showDuration": "300",
            "hideDuration": "300",
            "timeOut": "5000",
            "extendedTimeOut": "5000",
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        }

        $(document).ready(function () {
            $('#filterButton').click(function () {
                $('#filterDiv').toggle(400);
            });
            $(window).scroll(function () {
                if ($(window).scrollTop() > 50) {
                    $('#backToPageTop').fadeIn('fast');
                } else {
                    $('#backToPageTop').fadeOut();
                }
            });
            $('#backToPageTop').click(function () {
                $('body, html').animate({scrollTop: 0}, 500);
            });
        });

        // with plugin options
        $(".topfive, .output-rating").rating({
            readonly: true,
            language: 'de',
            showClear: false,
            size: 'xs',
            showCaption: false
        });


        @if(Session::has('notification'))
                toastr['{{Session::get('notification')['type']}}']('{{Session::get('notification')['description']}}', '{{Session::get('notification')['title']}}');

        @endif


    </script>

    <script src="{{ URL::asset('js/app.js') }}"></script>
@endsection

