<!-- seller registration form modal-->
<div id="seller_reg" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <!-- Modal content-->
        <div class="modal-content narrow">
            <div class="modal-header">
                <h4 class="modal-title">Lassen Sie sich<br/>noch heute empfehlen</h4>
            </div>
            <div class="modal-body">
                <div id="registration-login-mask" class="carousel slide">
                    <!-- Wrapper for slides -->
                    <div class="carousel-inner">
                        <div class="item active"> <!-- Registration -->
                            <div class="row">
                                <form id="register-form" role="form" method="POST" action="{{ url('/register') }}">
                                    {{ csrf_field() }}
                                    <input id="token" name="token" type="hidden" value="{{ $token ?? -1 }}">
                                    <div class="col-md-6">
                                        <div class="form-group{{ $errors->has('firstname') ? ' has-error' : '' }}">
                                            <input id="firstname" type="text" class="form-control" name="firstname"
                                                   value="{{ old('firstname') }}"
                                                   required>
                                            <label alt="Vorname*" placeholder="Vorname*"></label>

                                            @if ($errors->has('firstname'))
                                                <span class="help-block">
                            <strong>{{ $errors->first('firstname') }}</strong>
                        </span>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group{{ $errors->has('surname') ? ' has-error' : '' }}">
                                            <input id="surname" type="text" class="form-control" name="surname"
                                                   value="{{ old('surname') }}"
                                                   required>
                                            <label alt="Nachname*" placeholder="Nachname*"></label>
                                            @if ($errors->has('surname'))
                                                <span class="help-block">
                            <strong>{{ $errors->first('surname') }}</strong>
                                    </span>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="clearfix"></div>

                                    <div class="col-md-12">
                                        <div class="form-group{{ $errors->has('company') ? ' has-error' : '' }}">
                                            <input id="company" type="text" class="form-control" name="company"
                                                   value="{{ old('company') }}"
                                                   required>
                                            <label alt="Unternehmensname*" placeholder="Unternehmensname*"></label>
                                            @if ($errors->has('company'))
                                                <span class="help-block">
                            <strong>{{ $errors->first('company') }}</strong>
                        </span>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="clearfix"></div>

                                    <div class="col-md-12">
                                        <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                                            <input id="email" type="email" class="form-control" name="email"
                                                   value="{{ old('email') }}"
                                                   required>
                                            <label alt="Firmen E-Mail Adresse*"
                                                   placeholder="Firmen E-Mail Adresse"></label>
                                            @if ($errors->has('email'))
                                                <span class="help-block">
                            <strong>{{ $errors->first('email') }}</strong>
                        </span>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="clearfix"></div>

                                    <div class="col-md-12">
                                        <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }}">
                                            <input id="password" type="password" class="form-control" name="password"
                                                   required pattern=".{6,}" title="6 Zeichen minimum">
                                            <label alt="Passwort*" placeholder="Passwort*"></label>

                                            @if ($errors->has('password'))
                                                <span class="help-block">
                            <strong>{{ $errors->first('password') }}</strong>
                        </span>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group{{ $errors->has('password_confirmation') ? ' has-error' : '' }}">
                                            <input id="password_confirmation" type="password" class="form-control"
                                                   name="password_confirmation"
                                                   required pattern=".{6,}" title="6 Zeichen minimum">
                                            <label alt="Passwort bestätigen*"
                                                   placeholder="Passwort bestätigen*"></label>
                                            @if ($errors->has('password_confirmation'))
                                                <span class="help-block">
                            <strong>{{ $errors->first('password_confirmation') }}</strong>
                        </span>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group{{ $errors->has('zip') ? ' has-error' : '' }}">
                                            <input id="zip" type="text" class="form-control" name="zip"
                                                   value="{{ old('zip') }}"
                                                   required>
                                            <label alt="PLZ*" placeholder="PLZ*"></label>
                                            @if ($errors->has('zip'))
                                                <span class="help-block">
                                            <strong>{{ $errors->first('zip') }}</strong>
                                            </span>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <small>Durch das Klicken von „Jetzt registrieren“
                                            bestätigen Sie, dass Sie mit unseren AGBs
                                            den Datenschutzrichtlinien und der
                                            Verwendung von Cookies
                                            einverstanden sind.
                                        </small>
                                    </div>
                                    <div class="col-md-6">
                                        <button type="submit" class="btn btn-danger btn-md btn-block">Jetzt Registrieren
                                        </button>
                                    </div>

                                    <!--Switch to Login-->
                                    <div class="col-md-6 switch-login-registration-button right">
                                        <a href="#registration-login-mask" data-slide="next">
                                            <span>Schon registriert?</span>
                                        </a>
                                    </div>
                                </form>
                            </div>
                        </div><!-- /Registration -->
                        <div class="item"> <!-- Login -->
                            <form id="login-form" role="form" method="POST"
                                  action="{{ url('/login') }}">
                                {{ csrf_field() }}
                                <input id="token" name="token" type="hidden" value="{{ $token ?? -1 }}">
                                <div class="col-md-12">
                                    <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                                        <input id="email" type="email" class="form-control" name="email"
                                               value="{{ old('email') }}"
                                               required>
                                        <label alt="E-Mail Adresse"
                                               placeholder="E-Mail Adresse"></label>
                                        @if ($errors->has('email'))
                                            <span class="help-block">
                                    <strong>{{ $errors->first('email') }}</strong>
                                </span>
                                        @endif
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                                <div class="col-md-12">
                                    <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }}">
                                        <input id="password" type="password" class="form-control" name="password"
                                               required pattern=".{6,}" title="6 Zeichen minimum">
                                        <label alt="Passwort" placeholder="Passwort"></label>

                                        @if ($errors->has('password'))
                                            <span class="help-block">
                                    <strong>{{ $errors->first('password') }}</strong>
                                </span>
                                        @endif
                                    </div>
                                </div>
                                <div class="clearfix"></div>

                                <div class="col-md-6">
                                    <button type="submit" class="btn btn-danger btn-md btn-block">Anmelden</button>
                                </div>
                                <div class="col-md-6">
                                    <a href="{{ url('/password/reset') }}">
                                        <small>Passwort vergessen?</small>
                                    </a>
                                </div>
                                <div class="clearfix"></div>
                                <div class="col-md-12 switch-login-registration-button">
                                    <a class="right" href="#registration-login-mask" data-slide="prev">
                                        <span>Registrieren Sie sich jetzt!</span>
                                    </a>
                                </div>
                            </form>
                        </div> <!-- /Login -->
                    </div>
                </div>
                <!-- ./row -->
            </div>
            <!-- ./modal-body -->

            <!-- Left and right controls -->
            <div class="modal-footer">
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function () {
        $('#registration-login-mask').carousel({
            interval: false
        });
    });
</script>
<!-- seller registration form -->