@extends('layouts.root')

@section('title','Passwort setzen')

@section('additionalHeader')
    @if($linkInvitation->user->hasRole('seller'))
        <meta property="og:title" content=" Ich lade Dich zu RECO.MA ein" />
        <meta property="og:description" content="RECO.MA macht Empfehlungsmarketing kinderleicht und Dein Unternehmen profitabler. " />
        <meta property="og:image" content="{{url('account/portraits/'.$linkInvitation->user->account->upload_portrait)}}" />
    @else
        <meta property="og:title" content="Ich lade Sie zu RECO.MA ein" />
        <meta property="og:description" content="RECO.MA macht Empfehlungsmarketing kinderleicht und Ihr Unternehmen profitabler. " />
        <meta property="og:image" content="{{url('account/portraits/'.$linkInvitation->user->upload_portrait)}}" />
    @endif
@endsection

@section('head.links')
    <link href="/css/bootstrap.min.css" rel="stylesheet">
    <link href="/font-awesome/css/font-awesome.css" rel="stylesheet">

    <link href="/css/animate.css" rel="stylesheet">
    <link href="/css/style.css" rel="stylesheet">
    <link href="{{ URL::asset('css/app.css') }}" rel="stylesheet">
@endsection

@section('body.class', 'gray-bg')

@section('body')


    <div class="middle-box text-center animated fadeInDown">
        <div class="row">
            <div class="ibox-content">
                <div class="row">

                    <div class="col-md-8 col-md-offset-2 text-center" style="padding-top: 20px">
                        @if($linkInvitation->user->hasRole('seller'))
                            <img style="  margin: 0 auto;" class="img-responsive"
                                 src="/account/portraits/{{$linkInvitation->user->account->upload_portrait}}"
                                 alt="{{$linkInvitation->user->account->company}} Logo">
                            <p><h3>{!! $linkInvitation->user->account->company !!}</h3></p>
                            <p>Wir werden bei</p>
                            <img style="  margin: 0 auto;" class="img-responsive"
                                 src="/img/logo_400x112.png"
                                 alt="Recoma Logo">
                            <p><strong>von unseren Kunden empfohlen</strong></p>
                        @else
                            <img width="30%" style="margin: 0 auto;" class="img-responsive img-circle"
                                 src="/account/portraits/{{$linkInvitation->user->upload_portrait}}"
                                 alt="{{$linkInvitation->user->firstname}} Logo">
                            <br>
                            <h3>
                                <strong>{!! $linkInvitation->user->firstname !!} {!! $linkInvitation->user->surname !!}</strong>
                            </h3>
                            <p>möchte Ihr Unternehmen bei</p>

                            <img style="  margin: 0 auto;" class="img-responsive"
                                 src="/img/logo_400x112.png"
                                 alt="Recoma Logo">
                            <p><strong>empfehlen</strong></p>
                        @endif
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-10 col-md-offset-1">
                        <div class="well">
                            <p>Steigern auch Sie mit Empfehlungen Ihren Umsatz!</p>
                            <p>Melden Sie sich jetzt an und lassen Sie Ihr Unternehmen von Ihren Kunden,Freunden und
                                Geschäftspartnern an Interessenten empfehlen.</p>
                        </div>
                        <p>Empfehlungen verkaufen viel einfacher.</p>
                        <p><strong>Wir schenken Ihnen einen Mitgliedsmonat</strong></p>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-10 col-md-offset-1" style="padding-bottom: 20px">
                        <form action="{{ url('/registration/' . $linkInvitation->token . '/landing') }}">
                            <input type="submit" value="Jetzt empfehlen lassen" class="btn btn-primary">
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection