@extends('layouts.root')

@section('title','Passwort setzen')

@section('additionalHeader')
    @if(!is_null($linkInvitation->account))
        <meta property="og:title" content=" Ich empfehle Dir {!! $linkInvitation->account->getDisplayName() !!}" />
        <meta property="og:description" content="RECO.MA ist für Dich 100% kostenlos und Deine Daten werden sicher auf SSL-verschlüsselten Servern in Deutschland gespeichert." />
        <meta property="og:image" content="{{url('account/portraits/'.$linkInvitation->account->upload_portrait)}}" />
    @else
        <meta property="og:title" content=" Ich empfehle Dir {!! $linkInvitation->couponTemplate->user->account->getDisplayName() !!}" />
        <meta property="og:description" content="RECO.MA ist für Dich 100% kostenlos und Deine Daten werden sicher auf SSL-verschlüsselten Servern in Deutschland gespeichert." />
        <meta property="og:image" content="{{url('account/portraits/'.$linkInvitation->couponTemplate->user->account->upload_portrait)}}" />
    @endif
@endsection

@section('head.links')
    <link href="/css/bootstrap.min.css" rel="stylesheet">
    <link href="/font-awesome/css/font-awesome.css" rel="stylesheet">

    <link href="/css/animate.css" rel="stylesheet">
    <link href="/css/style.css" rel="stylesheet">
    <link href="{{ URL::asset('css/app.css') }}" rel="stylesheet">
@endsection

@section('body.class', 'gray-bg')
@section('body')
    <div class="middle-box text-center animated fadeInDown">
        <div class="row">
            <div class="ibox-content">
                <div class="row">
                    <div class="col-md-8 col-md-offset-2 text-center" style="padding-top: 20px">
                        @if(!empty($linkInvitation->user->upload_portrait))
                        <img width="30%" style="margin: 0 auto;" class="img-responsive img-circle"
                             src="/account/portraits/{{$linkInvitation->user->upload_portrait}}"
                             alt="{{$linkInvitation->user->firstname}} Logo">
                        <br>
                        @endif
                        <h3>
                            <strong>{!! $linkInvitation->user->firstname !!} empfiehlt dir</strong>
                        </h3>
                        @if(!is_null($linkInvitation->account))
                            <p>{{-- Fixme: kein Inline CSS verwenden --}}
                                <img width="30%" style="margin: 0 auto;" class="img-responsive"
                                     src="/account/portraits/{{$linkInvitation->account->upload_portrait}}"
                                     alt="{{ $linkInvitation->account->getDisplayName() }} Logo">
                            </p>
                            <hr>
                            <p class="text-danger"><strong>Spare und erhalte Prozente nach Deinem Einkauf</strong></p>

                            <p><strong>bei {!! $linkInvitation->account->getDisplayName() !!}</strong></p>
                            @else
                                <p>
                                    @if(!empty($linkInvitation->couponTemplate->img))
                                        <img id="couponImg" src="{{ route('coupon.get-image', $linkInvitation->couponTemplate->img) }}">
                                    @else
                                        <img width="30%" style="margin: 0 auto;" class="img-responsive"
                                             src="/account/portraits/{{$linkInvitation->couponTemplate->user->account->upload_portrait}}"
                                             alt="{{$linkInvitation->couponTemplate->user->account->getDisplayName() }} Logo">
                                    @endif
                                </p>
                                <p class="text-danger">
                                    <strong>
                                        Spare und erhalte
                                        {{ $linkInvitation->couponTemplate->present()->discount_consumer }}
                                        nach Deinem Einkauf
                                    </strong>
                                </p>

                                <p><strong>bei {!! $linkInvitation->couponTemplate->user->account->getDisplayName() !!}</strong></p>
                            @endif
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-10 col-md-offset-1">
                        <div class="well">
                            <p><strong>So erhältst du das Cashback</strong></p>
                            <p>Melde Dich an und hole Deinen Gutschein ab. Löse den BON ein und erhalte nach
                                Kaufabschluss
                                Dein Cashback. Du kannst es jederzeit auszahlen</p>
                        </div>
                    </div>
                </div>
                <div class="row" style="margin-bottom: 20px">
                    <div class="col-md-10 col-md-offset-1">
                        <p><strong>
                                In 2 Schritten bares Geld sparen
                            </strong></p>
                    </div>
                    <div class="col-xs-offset-3 col-xs-3">
                        1. Einkaufen
                    </div>
                    <div class="col-xs-3">
                        2. Auszahlen
                    </div>
                </div>

                <form method="post" class="form-horizontal" action="{{route('handle-easy-registration',['token'=>$linkInvitation->token])}}" name="registerWithEmail" id="registerWithEmail">
                    {{ csrf_field() }}

                    <div class="col-md-8 col-md-offset-2">
                        <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                            <input id="email" type="email" class="form-control" name="email"
                                   value="" required>
                            <label alt="Deine E-Mail Adresse*"
                                   placeholder="Deine E-Mail Adresse*"></label>
                            @if ($errors->has('email'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('email') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>

                    <div class="col-md-8 col-md-offset-2">
                        <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }}">
                            <input id="password" type="password" class="form-control" name="password"
                                   required pattern=".{6,}" title="6 Zeichen minimum">
                            <label alt="Passwort*" placeholder="Passwort*"></label>

                            @if ($errors->has('password'))
                                <span class="help-block">
                            <strong>{{ $errors->first('password') }}</strong>
                        </span>
                            @endif
                        </div>
                    </div>
                    <div class="col-md-8 col-md-offset-2">
                        <div class="form-group{{ $errors->has('password_confirmation') ? ' has-error' : '' }}">
                            <input id="password_confirmation" type="password" class="form-control"
                                   name="password_confirmation"
                                   required pattern=".{6,}" title="6 Zeichen minimum">
                            <label alt="Passwort bestätigen*"
                                   placeholder="Passwort bestätigen*"></label>
                            @if ($errors->has('password_confirmation'))
                                <span class="help-block">
                            <strong>{{ $errors->first('password_confirmation') }}</strong>
                        </span>
                            @endif
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-10 col-md-offset-1" style="padding-bottom: 20px">
                            <button type="submit" class="btn btn-primary" name="registration" value="register-by-email">Jetzt
                                registrieren</button>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-5"><hr></div>
                        <div class="col-md-2">
                            <p style="position:relative;top:10px;">oder</p>
                        </div>
                        <div class="col-md-5"><hr></div>
                    </div>
                    <div class="row">
                        <button type="submit" class="btn btn-primary" name="registration" value="register-by-facebook">Mit facebook
                            registrieren</button>
                    </div>
                </form>
                <hr>
                <div class="row">
                    <div class="col-lg-12">
                        <p>Bereits registriert? <a href="{{url('/')}}">Anmelden -&gt;</a></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
