@extends('layouts.root')

@section('title','Passwort setzen')

@section('additionalHeader')
    <meta property="og:title" content="{!! $linkInvitation->user->account->company !!} lädt Sie zu RECO.MA ein" />
    <meta property="og:description" content="RECO.MA ist für Sie 100% kostenlos und Ihre Daten werden sicher auf SSL-verschlüsselten Servern in Deutschland gespeichert." />
    <meta property="og:image" content="{{url('account/portraits/'.$linkInvitation->user->account->upload_portrait)}}" />
@endsection

@section('head.links')
    <link href="/css/bootstrap.min.css" rel="stylesheet">
    <link href="/font-awesome/css/font-awesome.css" rel="stylesheet">

    <link href="/css/animate.css" rel="stylesheet">
    <link href="/css/style.css" rel="stylesheet">
    <link href="{{ URL::asset('css/app.css') }}" rel="stylesheet">
@endsection

@section('body.class', 'gray-bg')

@section('body')
    <div class="middle-box text-center animated fadeInDown">
        <div class="row">
            <div class="ibox-content">
                <div class="row">
                    <div class="col-md-8 col-md-offset-2 text-center" style="padding-top: 20px">
                        <img width="30%" style="margin: 0 auto;" class="img-responsive img-circle"
                             src="/account/portraits/{{$linkInvitation->user->account->upload_portrait}}"
                             alt="{{$linkInvitation->user->account->company}} Logo">
                        <br>
                        <h3>
                            <strong>{!! $linkInvitation->user->account->company !!}</strong>
                        </h3>
                        <p>
                            Möchte Dich exklusiv als Empfehler gewinnen
                        </p>
                        <hr>
                        <p class="text-danger"><strong>Erhalte
                                @if($recoCash = $linkInvitation->user->account->getSellerMaxRecoCash())
                                     bis zu {{ Format::Percent($recoCash) }}
                                @else
                                    eine
                                @endif
                                Geldprämie</strong></p>
                        <p><strong>für jede erfolgreiche Empfehlung</strong></p>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-8 col-md-offset-2 form-group">
                        <div class="embed-responsive embed-responsive-16by9">
                            <iframe class="embed-responsive-item" src="https://player.vimeo.com/video/233624797"
                                    frameborder="0" allowfullscreen></iframe>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-10 col-md-offset-1">
                        <div class="well">
                            <p><strong>So erhälst du die Geldprämie</strong></p>
                            <p>Melde dich an und empfehle {{$linkInvitation->user->account->company}} sowie
                                viele weitere Unternehmen aus über 100 Branchen bequem über dein Smartphone. Nach jeder
                                erfolgreichen Empfehlung schreiben wir Dir RECO.CASH gut, Du kannst es jederzeit auf
                                dein
                                Konto auszahlen.</p>
                        </div>
                    </div>
                </div>
                <div class="row" style="margin-bottom: 20px">
                    <div class="col-md-10 col-md-offset-1">
                        <p><strong>
                                In 2 Schritten Geld verdienen
                            </strong></p>
                    </div>
                    <div class="col-md-4 col-md-offset-2">
                        1. Freunde empfehlen
                    </div>
                    <div class="col-md-4">
                        2. Auszahlen
                    </div>
                </div>
                <form method="post" class="form-horizontal" action="{{route('handle-easy-registration',['token'=>$linkInvitation->token])}}" name="registerWithEmail" id="registerWithEmail">
                    {{ csrf_field() }}

                    <div class="col-md-8 col-md-offset-2">
                        <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                            <input id="email" type="email" class="form-control" name="email"
                                   value="" required>
                            <label alt="Deine E-Mail Adresse*"
                                   placeholder="Deine E-Mail Adresse*"></label>
                            @if ($errors->has('email'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('email') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>

                    <div class="col-md-8 col-md-offset-2">
                        <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }}">
                            <input id="password" type="password" class="form-control" name="password"
                                   required pattern=".{6,}" title="6 Zeichen minimum">
                            <label alt="Passwort*" placeholder="Passwort*"></label>

                            @if ($errors->has('password'))
                                <span class="help-block">
                            <strong>{{ $errors->first('password') }}</strong>
                        </span>
                            @endif
                        </div>
                    </div>
                    <div class="col-md-8 col-md-offset-2">
                        <div class="form-group{{ $errors->has('password_confirmation') ? ' has-error' : '' }}">
                            <input id="password_confirmation" type="password" class="form-control"
                                   name="password_confirmation"
                                   required pattern=".{6,}" title="6 Zeichen minimum">
                            <label alt="Passwort bestätigen*"
                                   placeholder="Passwort bestätigen*"></label>
                            @if ($errors->has('password_confirmation'))
                                <span class="help-block">
                            <strong>{{ $errors->first('password_confirmation') }}</strong>
                        </span>
                            @endif
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-10 col-md-offset-1" style="padding-bottom: 20px">
                            <button type="submit" class="btn btn-primary" name="registration" value="{{\App\User::REGISTER_BY_EMAIL}}">Jetzt
                                registrieren</button>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-5"><hr></div>
                        <div class="col-md-2">
                            <p style="position:relative;top:10px;">oder</p>
                        </div>
                        <div class="col-md-5"><hr></div>
                    </div>
                    <div class="row">
                        <button type="submit" class="btn btn-primary" name="registration" value="{{\App\User::REGISTER_BY_FACEBOOK}}">Mit facebook
                            registrieren</button>
                    </div>
                </form>
                <hr>
                <div class="row">
                    <div class="col-lg-12">
                        <p>Bereits registriert? <a href="{{url('/')}}">Anmelden -&gt;</a></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
