@extends('layouts.home')

@section('title', 'Anfragen und Einladungen')

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>Laden Sie Ihre Empfehler ein</h5>
                </div>
                <div class="ibox-content col-md-12">
                    <div class="mass-invite col-md-4">
                        <p>Laden Sie eine Liste von E-Mails hoch. Oder kopieren Sie die Kontaktdaten
                            in folgendes Feld.
                            Wir laden Ihre Kunden sofort zu Ihrem Empfehlernetzwerk ein.
                        </p>
                        <p>Sobald Ihr Kunde die Einladung bestätigt werden wir Sie in Echtzeit Informieren.
                        </p>


                        <form class="form-horizontal" id="massInvitationForm" role="form" method="POST"
                              action="{{ route('massinvitation-post') }}">
                            {{ csrf_field() }}

                            <div class="form-group email-input">
                                <div class="col-lg-12">
                                    <textarea type="text" class="form-control" name="contacts"
                                              aria-describedby="emailHelp">{{ $contacts ?? old('contacts') }}</textarea>
                                    @if ($errors->has('contacts'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('contacts') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="col-lg-12">
                                    <button type="submit" class="btn btn-success">Kontakte als Empfehler einladen
                                    </button>
                                </div>
                            </div>

                            {!! JsValidator::formRequest('App\Http\Requests\MassInvitationRequest','#massInvitationForm') !!}
                        </form>
                    </div>

                    <div class="col-md-1"></div>

                    <div class="mass-invite col-md-6">

                        {!! Form::open([
                            'route' => 'massinvitation-upload',
                            'class' => 'form-horizontal',
                            'files' => true]) !!}
                            {{ csrf_field() }}

                            <div class="form-group">
                                <div class="col-lg-12">
                                    <p>Bitte verwenden Sie eine CSV- oder Textdatei, die nur eine E-Mail-Adresse je Zeile enthält.</p>
                                    <input type="file" name="file">
                                </div>
                            </div>

                            <div class="form-group">
                                <div class="col-lg-12">
                                    <button type="submit" class="btn btn-success">Hochladen</button>
                                </div>
                            </div>
                            <p>Oder per WhatsApp & SMS einladen</p>
                            <div class="form-group">
                                <div class="col-lg-2">
                                    <a class="btn btn-success" href="{{url('/create-link/invite-new-agent/whatsapp')}}" target="_blank">WHATSAPP</a>
                                </div>
                                <div class="col-lg-2 ">
                                    <a class="btn btn-warning" href="{{url('/create-link/invite-new-agent/sms')}}">SMS</a>
                                </div>
                            </div>
                            @if(!isset($shortlink))
                            <div class="form-group" id="generate-shortlink-button">
                                <div class="col-lg-12">
                                    <a class="btn btn-success" href="{{url('generatePermanentLinkInvitation')}}">Einladungslink erstellen</a>
                                </div>
                            </div>
                            @else
                            <div class="form-group">
                                <div class="col-lg-12" id="label-shortlink" >
                                    <p>Einladungslink:</p>
                                </div>

                                <div class="col-lg-12">
                                    <p id="generated-short-link">{{$shortlink}}</p>
                                </div>
                            </div>
                            @endif
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>

        $('#add-email-inputs').click(function () {
            for (var i = 0; i < 1; i++) {
                $('form div.email-input').last().after(
                    "<div class='form-group email-input'>" +
                    "<div class='col-lg-12')>" +
                    "<input type=\"email\" class=\"form-control\" name=\"invitedAgent[]\" + aria-describedby=\"emailHelp\" placeholder=\"Via E-Mail einladen\">" +
                    "</div>" +
                    "</div>");
            }
        });
    </script>
@endsection

