@extends('layouts.home')

@section('title', 'Anfragen und Einladungen')

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>Anfragen und Einladungen</h5>
                </div>
                <div class="ibox-content">

                    @foreach($newsletters as $newsletter)
                        Kennst du das Unternehmen
                        @include('partials.account', ['account' => $newsletter->getSellerAccount(), 'long' => true])
                        ?
                        <a class="btn btn-circle btn-success" href="/newsletter/accept/{{ $newsletter->id }}"
                           data-toggle="tooltip" data-placement="top" title="Anfrage oder Einladung bestätigen"><i
                                    class="fa fa-check"></i></a>
                        <a class="btn btn-circle btn-danger" href="/newsletter/reject/{{ $newsletter->id }}"
                           data-toggle="tooltip" data-placement="top" title="Anfrage oder Einladung ablehnen"><i
                                    class="fa fa-times"></i></a>
                        <br>
                    @endforeach
                    @foreach($intermediaries as $intermediarie)
                        @include('partials.account', ['account' => $intermediarie->account, 'long' => true])
                        möchte Sie als Empfehler für seine RECO.BONs engagieren.
                        <a class="btn btn-circle btn-success" href="/invitation/accept/{{ $intermediarie->id }}"
                           data-toggle="tooltip" data-placement="top" title="Anfrage oder Einladung bestätigen"><i
                                    class="fa fa-check"></i></a>
                        <a class="btn btn-circle btn-danger" href="/invitation/reject/{{ $intermediarie->id }}"
                           data-toggle="tooltip" data-placement="top" title="Anfrage oder Einladung ablehnen"><i
                                    class="fa fa-times"></i></a>
                        <br>
                    @endforeach
                    @foreach($invitations as $invitation)
                        @include('partials.account', ['account' => $invitation->account, 'long' => true])
                        möchte für Sie als Empfehler tätig werden.
                        <a class="btn btn-circle btn-success" href="/invitation/accept/{{ $invitation->id }}"
                           data-toggle="tooltip" data-placement="top" title="Anfrage oder Einladung bestätigen"><i
                                    class="fa fa-check"></i></a>
                        <a class="btn btn-circle btn-danger" href="/invitation/reject/{{ $invitation->id }}"
                           data-toggle="tooltip" data-placement="top" title="Anfrage oder Einladung ablehnen"><i
                                    class="fa fa-times"></i></a>
                        <br>
                    @endforeach

                    @foreach($coupons as $coupon)
                        @include('partials.account', ['account' => $coupon->template->user->account, 'long' => true])
                        bietet Ihnen einen RECO.BON an.
                        <a class="btn btn-circle btn-success" href="/coupon-invitation/accept/{{ $coupon->id }}"><i
                                    class="fa fa-check"></i></a>
                        <a class="btn btn-circle btn-danger" href="/coupon-invitation/reject/{{ $coupon->id }}"><i
                                    class="fa fa-times"></i></a>
                    @endforeach
                    @if(count($invitations) == 0 && count($coupons) == 0 && count($intermediaries) == 0 && count($newsletters) == 0)
                        Aktuell liegen keine unbeantwortete Anfragen oder Einladungen vor.
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection

