<tr>
    <td>{{ $gift->id }}</td>
    <td>{{ $gift->name }}</td>
    <td>{{ $gift->price }} &euro;</td>
    <td><img class="giftImage" src="{{ asset($gift->image) }}"></td>
    <td>
        @if ($canEdit)
            @if ($gift->active)
                <a href="{{ route('gift-deactivate', ['gift' => $gift]) }}" class="btn btn-default giftDeactivate">
                    <i class="fa fa-toggle-on"></i>
                </a>
            @else
                <a href="{{ route('gift-activate', ['gift' => $gift]) }}" class="btn btn-default giftActivate">
                    <i class="fa fa-toggle-off"></i>
                </a>
            @endif
        @endif
        <span>{{ $gift->active ? 'Ja' : 'Nein' }}</span>
    </td>
    <td>
        <a target="_blank" href="{{ route('gift-show', ['gift' => $gift]) }}" class="btn btn-primary-green giftShow">
            <i class="fa fa-eye"></i>
        </a>
        @if ($canEdit)
            <a href="{{ route('gift-edit', ['gift' => $gift]) }}" class="btn btn-primary giftEdit">
                <i class="fa fa-edit"></i>
            </a>
        @endif
        @if ($canDelete)
            <a href="{{ route('gift-delete', ['gift' => $gift]) }}" class="btn btn-primary-orange giftDelete">
                <i class="fa fa-remove"></i>
            </a>
        @endif
    </td>
</tr>