<form class="form-horizontal" method="post" action="{{ $action }}" enctype="multipart/form-data">
    {{ csrf_field() }}
    @if ( isset($gift) && $gift->id )
        {{ method_field('PUT') }}
    @endif

    <div class="form-group{{ $errors->has('name') ? ' has-error' : '' }}">
        <label class="col-sm-2 control-label" for="name">Titel</label>
        <div class="col-sm-10">
            <input id="name" type="text" class="form-control" name="name" value="{{ old('name', isset($gift) ? $gift->name : '') }}" placeholder="Titel">

            @include('partials.form.error', ['property' => 'name'])
        </div>
    </div>

    <div class="form-group{{ $errors->has('price') ? ' has-error' : '' }}">
        <label class="col-sm-2 control-label" for="price">Preis, &euro;</label>
        <div class="col-sm-10">
            <input type="text" id="priceInput" class="form-control input-eur" value="{{ old('price', isset($gift) ? $gift->price : '') }}" placeholder="Preis" data-an-input="#price">
            <input type="hidden" id="price" name="price" value="{{ old('price', isset($gift) ? $gift->price : '') }}">

            @include('partials.form.error', ['property' => 'price'])
        </div>
    </div>

    <div class="form-group{{ $errors->has('image') ? ' has-error' : '' }}">
        <label class="col-sm-2 control-label" for="image">Bild</label>
        <div class="col-sm-10">
            <input name="image" type="file" accept="image/*" class="btn btn-primary btn-block" id="giftImageInput">

            @include('partials.form.error', ['property' => 'image'])

            @if ( isset($gift) && $gift->image )
                <img id="giftImage" src="{{ asset($gift->image) }}">
            @else
                <img id="giftImage" src="" style="display: none;">
            @endif
        </div>
    </div>

    <div class="form-group{{ $errors->has('active') ? ' has-error' : '' }}">
        <label class="col-sm-2 control-label">Aktiv</label>
        <div class="col-sm-10">
            <label class="control-label">
                <input type="radio" name="active" value="1" @if( 1 == old('active', isset($gift) ? $gift->active : 1) ) checked @endif> Ja
            </label>
            <label class="control-label">
                <input type="radio" name="active" value="0" @if( 0 == old('active', isset($gift) ? $gift->active : 1) ) checked @endif> Nein
            </label>

            @include('partials.form.error', ['property' => 'active'])
        </div>
    </div>

    <div class="form-group{{ $errors->has('description') ? ' has-error' : '' }}">
        <label class="col-sm-2 control-label" for="price">Beschreibung</label>
        <div class="col-sm-10">
            <textarea id="description" name="description" rows="10" class="form-control">{{ old('description', isset($gift) ? $gift->description : '') }}</textarea>

            @include('partials.form.error', ['property' => 'description'])
        </div>
    </div>

    <div class="form-group">
        <label class="col-sm-2 control-label"></label>
        <div class="col-sm-10">
            <button type="submit" class="btn btn-primary">
                <i class="fa fa-save"></i> Speichern
            </button>
            <a href="{{ route('gift-list') }}" class="btn btn-default">
                <i class="fa fa-close"></i> Abbrechen
            </a>
        </div>
    </div>
</form>