@extends('layouts.home')

@section('title', 'Geschenke')

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>Geschenke</h5>
                </div>
                <div class="ibox-content">
                    @if ($canCreate)
                        <div>
                            <a href="{{ route('gift-create') }}" class="btn btn-primary">
                                <i class="fa fa-plus-circle"></i> Neue Geschenk
                            </a>
                        </div>
                    @endif

                    @if($gifts->count())
                    <div id="giftList">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Titel</th>
                                    <th>Preis</th>
                                    <th>Bild</th>
                                    <th>Aktiv</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($gifts as $gift)
                                    @include('gifts.partials.gift', $gift)
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @else
                    <p>Keine Geschenke</p>
                    @endif
                </div>

                <form action="" method="post" style="display: none" id="giftDeleteForm">
                    {{ csrf_field() }}
                    {{ method_field('DELETE') }}
                </form>
            </div>
        </div>
    </div>
@endsection

@section('after-scripts')
    <script>
        $(document).ready(function () {
            $('.giftDelete').on('click', function (e) {
                e.preventDefault();
                e.stopPropagation();

                if ( confirm('Bist du sicher? Aktion ist nicht kündbar') ) {
                    $('#giftDeleteForm')
                        .attr('action', $(this).attr('href'))
                        .submit();
                }
            });
        });
    </script>
@endsection