<?php
/**
 * @var $couponTemplateFilter \App\Library\Dashboard\Filter;
 */

?>
@extends('layouts.home')

@section('title', 'Dashboard')

@section('content')
    {{-- Temporär ausblenden, #20587

        @include('dashboard.partials.filter', array_merge(['url' => url('/dashboard/seller')],
            compact('agentAccountFilter', 'consumerAccountFilter', 'couponTemplateFilter'))
        )
    --}}

    <div class="ibox">
        <div class="ibox-title">
            <h3 id="welcome">Willkommen {{ Auth::user()->getDisplayName() }}</h3>
        </div>
        <div class="ibox-content dashboards-large-buttons-wrapper">
            <div class="row">
                <div class="col-md-4 col-sm-12">
                    <div class="ibox dashboard-button float-e-margins" id="invite_agent">
                        <a href="/seller-invite-new-agent" class="ibox-content invite">
                            Empfehler einladen
                        </a>
                    </div>
                </div>
                <div class="col-md-4 col-sm-12">
                    <div class="ibox dashboard-button float-e-margins" id="redeem_bon">
                        <a href="/coupon/redeem" class="ibox-content redeem">
                            RECO.BON einlösen
                        </a>
                    </div>
                </div>
                <div class="col-md-4 col-sm-12">
                    <div class="ibox dashboard-button float-e-margins" id="create_bon">
                        <a href="/coupon/edit" class="ibox-content create">
                            RECO.BON erstellen
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row" id="seller_widgets">
        @foreach($numbers as $number)
            <div class="col-lg-4 col-md-6">
                @include('dashboard.partials.number', $number)
            </div>
        @endforeach
    </div>
    <div class="row equal-height-cols-lg">
        <div class="col-lg-3">
            <div class="ibox dashboard-element float-e-margins">
                <div class="ibox-title">
                    <h3>RECO.BON Verteilung</h3>
                </div>
                <div class="ibox-content">
                    <div>
                        <div id="coupon-pie"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="ibox dashboard-element float-e-margins dashboard-last-ratings">
                <div class="ibox-title">
                    <h3>Letzte Bewertungen</h3>
                </div>
                <div class="ibox-content">
                    @if (count($ownRatings) == 0)
                        Es liegen bisher keine Bewertungen vor.
                    @else
                        <div>
                            <ul class="stat-list">
                                @foreach($ownRatings as $rating)
                                    <li class="space-filler-wrap">
                                        <div class="filler-left">
                                            @include('partials.user', ['user' => $rating->user, 'role' => \App\User::CONSUMER ])
                                        </div>

                                        <div class="filler-right">
                                            <input id="input-{{ $rating->rating }}" name="input-{{ $rating->rating }}"
                                                   value="{{ $rating->rating }}" class="topfive rating-loading">
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                        </div>

                        <div class="row">
                            <div class="col-xs-12 text-right">
                                <a href="/user/rating" class="btn btn-primary full-width">Bewertungen</a>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-lg-5">
            <div class="ibox dashboard-element dashboard-top-agents float-e-margins">
                <div class="ibox-title">
                    <h3>Top Empfehler</h3>
                </div>
                <div class="ibox-content">
                    <ul class="stat-list">
                        @foreach($topFiveAgents as $account)
                            <li class="space-filler-wrap">
                                <div class="filler-left">
                                    @include('partials.user', ['user' => $account->users()->first(), 'role' => \App\User::AGENT])
                                </div>
                                <div class="filler-right">
                                    <span class="number pull-right">{{ Format::percent($account->getConversionRate())  }}</span>
                                </div>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('after-scripts')
    <script>
        $(document).ready(function () {
            c3.generate({
                bindto: '#coupon-pie',
                data: {
                    columns: [
                        ['RECO.BONS im Umlauf', @if($couponsCount != 0 && $pendingCouponCount != 0 || $couponsCount != 0 && $activeCouponCount != 0)
                                {{ 100/$couponsCount*($pendingCouponCount+$activeCouponCount) }}
                                @else
                                0
                            @endif
                        ],
                            {{--['Angenommen', @if($couponsCount != 0 && $activeCouponCount != 0)--}}
                            {{--{{ 100/$couponsCount*$activeCouponCount }}--}}
                            {{--@else--}}
                            {{--0--}}
                            {{--@endif--}}
                            {{--],--}}
                        ['Bezahlt', @if($couponsCount != 0 && $doneCouponsCount != 0 || $couponsCount != 0 && $paidCouponCount != 0)
                                {{ 100/$couponsCount*($doneCouponsCount+$paidCouponCount) }}
                                @else
                                0
                            @endif
                        ],
                        ['Eingelöst', @if($couponsCount != 0 && $redeemedCouponCount != 0)
                                {{ 100/$couponsCount*$redeemedCouponCount }}
                                @else
                                0
                            @endif
                        ]
                    ],
                    colors: {
                        'RECO.BONS im Umlauf': '#898989',
                        'Eingelöst': '#f15c20',
                        'Bezahlt': '#007fbc'
                    },
                    type: 'pie'
                }
            });
        });

        function getRandomColor() {
            var letters = '0123456789ABCDEF';
            var color = '#';
            for (var i = 0; i < 6; i++) {
                color += letters[Math.floor(Math.random() * 16)];
            }
            return color;
        }
    </script>

    <script>
        $(".selectSeller").select2({
            placeholder: "Alle"
        });

        $(".selectAgent").select2({
            placeholder: "Alle"
        });

        $(".selectConsumer").select2({
            placeholder: "Alle"
        });
        $(".selectCoupon").select2({
            placeholder: "Alle"
        });
    </script>


    <script>
        jQuery(function ($) {
            var startGuide = function () {

                var guide = $("body").guide();
                guide.addStep('#welcome', 'Willkommen bei RECO.MA, Deiner persönlichen Empfehlungsplattform. Im folgenden Tutorial zeigen wir Dir die Funktionen von RECO.MA.');
                guide.addStep('#create_bon', 'Klicke hier um einen RECO.BON zu erstellen. Der RECO.BON ist ein Gutschein, der von Empfehlern an Interessenten per SMS und E-Mail verteilt wird. Du kannst mehrere RECO.BONS erstellen und so Deine Empfehlungen steigern. Nähere Informationen zu den RECO.BONS findest Du in unserer FAQ.');
                guide.addStep('#invite_agent', 'Klicke hier um Deine persönlichen Empfehler einzuladen. Wir empfehlen im Vorfeld mit Deinen Empfehlern über RECO.MA und die Vorteile für den Empfehler zu sprechen.');
                guide.addStep('#redeem_bon', 'Klicke hier um einen RECO.BON einzulösen, gebe anschließend den neunstelligen RECO.CODE sowie den Netto Rechnungsbetrag ein.');
                guide.addStep('#seller_widgets', 'Hier werden die Erfolgskennzahlen dargestellt. Du siehst auf einen Blick wie sich Dein Unternehmen mit RECO.MA entwickelt. Bei einer Empfehlung oder Einlösung, werden die Kennzahlen adhoc aktualisiert und Du bist immer auf dem Laufenden.');
                guide.addStep('#show_agents', 'Hier hast Du einen Überblick über Deine persönlichen sowie alle bei RECO.MA registrierten Empfehler.');
                guide.addStep('#show_coupon_management', 'Hier kannst Du neue RECO.BONS erstellen und Deine bestehenden RECO.BONS bearbeiten.');
                guide.addStep('#redeem_coupon', 'Hier werden Deine empfohlenen RECO.BONS im Detail dargestellt. Nachdem der Kunde seinen Rechnungsbetrag beglichen hat, musst Du in diesem Bereich die Zahlung als erhalten markieren.');
                guide.addStep('#profil', 'Hier kann das Benutzerprofil eingesehen und bearbeitet werden. Im Anschluss an das Tutorial empfehlen wir Dir Dein Unternehmenslogo hochladen und fehlende Angaben ergänzen.');
                guide.start();
            };

            if ("{{ $guidance }}" == false) {
                startGuide();
            }

            $('#help a').click(startGuide);
        });
    </script>

@endsection
