@extends('layouts.home')

@section('title', 'Dashboard')

@section('content')
    @include('dashboard.partials.filter', array_merge(['url' => url('/dashboard/operator'), 'bigLayout' => true ],
        compact('sellerAccountFilter', 'agentAccountFilter', 'consumerAccountFilter', 'couponTemplateFilter'))
    )

    <div class="row">
        @foreach($numbers as $number)
            <div class="col-lg-3">
                @include('dashboard.partials.number', $number)
            </div>
        @endforeach
    </div>

    <div class="row">
        <div class="col-lg-6">
            <div class="row">
                <div class="col-md-12">
                    <div class="ibox dashboard-element dashboard-toplist float-e-margins">
                        <div class="ibox-title">
                            <h3>Top Empfehler</h3>
                        </div>
                        <div class="ibox-content">
                            <ul class="stat-list">
                                @foreach($topAgents as $agent)
                                    <li class="space-filler-wrap">
                                        <div class="filler-left">
                                            @include('partials.account', ['account' => $agent, 'role' => 'agent'])
                                        </div>
                                        <div class="filler-right">
                                            <span class="number pull-right">{{ Format::percent($agent->conversionrate)  }}</span>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="row">
                <div class="col-md-12">
                    <div class="ibox dashboard-element dashboard-toplist float-e-margins">
                        <div class="ibox-title">
                            <h3>Top Unternehmen nach Erfolgsrate</h3>
                        </div>

                        <div class="ibox-content">
                            <ul class="stat-list">
                                @foreach($topSellers as $seller)
                                    <li class="space-filler-wrap">
                                        <div class="filler-left">
                                            @include('partials.account', ['account' => $seller])
                                        </div>
                                        <div class="filler-right">
                                            <span class="number pull-right">{{ Format::percent( $seller->conversionrate)  }}</span>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('after-scripts')
    <script>
        $(".selectSeller").select2({
            placeholder: "Alle"
        });

        $(".selectAgent").select2({
            placeholder: "Alle"
        });

        $(".selectConsumer").select2({
            placeholder: "Alle"
        });

        $(".selectCoupon").select2({
            placeholder: "Alle"
        });
    </script>
@endsection
