@extends('layouts.home')

@section('title', 'Dashboard')

@section('content')
    @if(Auth::user()->hasAnyRole(['consumer','agent']) )
        @include('partials.transaction-status')
    @endif
    <div class="ibox">
        <div class="ibox-title">
            <h3>Empfehlen</h3>
        </div>
        <div class="ibox-content dashboards-large-buttons-wrapper">
            <div class="row">
                @can('show seller')
                    <div class="col-md-6 col-sm-12" id="recommend-company">
                        <div class="ibox dashboard-button float-e-margins">
                            <a href="{{ url('sellers') }}" class="ibox-content-green btn btn-primary-cta">Unternehmen empfehlen</a>
                        </div>
                    </div>
                @endcan
                @can('show agent coupons')

                    <div class="col-md-6 col-sm-12" id="share-coupon">
                        <div class="ibox dashboard-button float-e-margins">
                            <a href="{{ url('coupon') }}" class="ibox-content-orange btn btn-primary-orange">RECO.BON empfehlen</a>

                        </div>
                    </div>
                @endcan
            </div>
        </div>
    </div>

    {{-- Temporär ausblenden, #20587
        @include('dashboard.partials.filter', array_merge(['url' => url('/dashboard/agent')],
            compact('sellerAccountFilter', 'consumerAccountFilter', 'couponTemplateFilter'))
        )
    --}}

    <div class="row">
        <div class="col-lg-12">
            <div class="row" id="agent-widgets">
                @foreach($numbers as $number)
                    <div class="col-lg-3">
                        @include('dashboard.partials.number', $number)
                    </div>
                @endforeach
            </div>
            <div class="row">
                <div class="col-md-6">
                    <div class="ibox dashboard-element dashboard-toplist float-e-margins">
                        <div class="ibox-title">
                            <h3>TOP 5 Unternehmen</h3>
                        </div>
                        <div class="ibox-content top-list">
                            <ul class="stat-list">
                                @foreach($topFiveSellers as $seller)
                                    <li class="space-filler-wrap">
                                        <div class="filler-left">
                                            @include('partials.account', ['account' => $seller, 'long' => true])
                                        </div>
                                        <div class="number filler-right">{{ Format::currency($seller->provision) }} <?php // FIXME calculate ?></div>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="ibox dashboard-element dashboard-toplist float-e-margins">
                        <div class="ibox-title">
                            <h3>TOP 5 RECO.BONS</h3>
                        </div>
                        <div class="ibox-content top-list">
                            <ul class="stat-list">
                                @foreach($templatesWithConversionRate as $template)
                                <li class="space-filler-wrap">
                                    <div class="filler-left">
                                        @include('partials.account', ['account' => $template->seller->account])
                                        <span class="template"> | {{ $template->title }}</span>
                                    </div>
                                    <div class="filler-right">
                                        <span class="number pull-right">{{ Format::percent($template->conversionRate)  }}</span>
                                    </div>
                                </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endsection

    @section('after-scripts')
    <script>
        //$(".selectedSellerAccounts[]").select2({});
        $(".selectAgent").select2({});
        $(".selectConsumer").select2({});
        $(".selectCoupon").select2({});
    </script>

    <script>
        jQuery(function ($) {
            var startGuide = function () {

                var guide = $("body").guide();

                guide.addStep('#welcome','Willkommen bei RECO.MA, Deiner persönlichen Empfehlungsplattform. Im folgenden Tutorial zeigen wir Dir die Funktionen von RECO.MA.');
                guide.addStep('#cashbar', 'Das ist Deine Cashbar, hier kannst Du deinen aktuellen Kontostand einsehen. Für die Empfehlung eines RECO.BONS (Gutschein) erhältst Du RECO.CASH (Empfehlerprovision). Sobald Dein RECO.CASH verfügbar ist, wird der Betrag im Kontostand angezeigt und Du kannst es dir auszahlen lassen. ');
                guide.addStep('#share-coupon', 'Klicke hier um einen RECO.BON an Deine Freunde zu empfehlen. Der RECO.BON ist ein Empfehlungsgutschein, den Du an Deine Freunde per SMS und E-Mail versenden kannst. Jeder RECO.BON ist personalisiert und mit einem bestimmten Cashback (Rabatt) für deinen Freund sowie einer Empfehlungsprovision für Dich hinterlegt. ');
                guide.addStep('#recommend-company', 'Klicke hier um ein Unternehmen an Deine Freunde zu empfehlen. Solltest Du nicht wissen welcher RECO.BON der richtige für Deine Freunde ist, kann sich Dein Freund den passenden RECO.BON des empfohlenen Unternehmens auswählen. ');
                guide.addStep('#agent-widgets', 'Hier werden die Erfolgskennzahlen dargestellt. Du siehst auf einen Blick wie erfolgreich Deine Empfehlungen bei RECO.MA sind. Bei einer Empfehlung oder Einlösung werden die Kennzahlen adhoc aktualisiert und Du bist immer auf dem Laufenden.');
                guide.addStep('#show_consumer', 'Hier werden Deine empfohlenen RECO.BONS im Detail dargestellt.');
                guide.addStep('#profil', 'Hier kann das Benutzerprofil eingesehen und bearbeitet werden. Im Anschluss an das Tutorial empfehlen wir Dein Profilbild hochzuladen, die fehlenden Angaben zu ergänzen sowie Deine Handynummer zu verifizieren - nur so können wir Deine Empfehlung per SMS versenden. Keine Sorge, die Kosten dafür übernehmen wir! ');
                guide.start();
            };

            if ("{{ $guidance }}" == 0) {
                startGuide();
            }

            $('#help a').click(startGuide);
        });
    </script>
    @endsection