@extends('layouts.home')

@section('title', 'RECO.BON Versenden')

@section('content')
    <div class="row">
            <div class="col-md-12">
                <div class="ibox float-e-margins">
                    <div class="ibox-title">
                    <h5>RECO.BONS Versenden</h5>
                    </div>
                    <div class="ibox-content">

                        <form class="form-horizontal" role="form" method="POST" action="{{ url('/coupon/store') }}">
                            {{ csrf_field() }}

                            <input type="hidden" name="template_id" value="{{ $couponTemplate->id }}">

                            <div class="form-group{{ $errors->has('salutation') ? ' has-error' : '' }}">
                                <label for="salutation" class="col-sm-2 control-label">Anrede</label>

                                <div class="col-sm-10">
                                    {!! Form::select('salutation', array('Herr' => 'Herr', 'Frau' => 'Frau'), old('salutation'), array('class' => 'form-control')) !!}
                                </div>
                            </div>

                            <div class="form-group{{ $errors->has('firstname') ? ' has-error' : '' }}">
                                <label class="col-sm-2 control-label" for="firstname">Vorname</label>

                                <div class="col-sm-10">
                                    <input id="firstname" type="text" class="form-control" name="firstname"
                                           value="{{ old('firstname') }}"
                                           placeholder="">

                                    @if ($errors->has('firstname'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('firstname') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>

                            <div class="form-group{{ $errors->has('surname') ? ' has-error' : '' }}">
                                <label class="col-sm-2 control-label" for="surname">Nachname</label>

                                <div class="col-sm-10">
                                    <input id="surname" type="text" class="form-control" name="surname"
                                           value="{{ old('surname') }}"
                                           placeholder="">

                                    @if ($errors->has('surname'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('surname') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                            @if(!Auth::user()->mobile_verified)
                                <div class="col-sm-10 col-sm-offset-3 alert alert-warning">
                                    <h3>Ihre Handynummer {{ Auth::user()->mobile }} ist noch nicht verifiziert.</h3>

                                    <a href="/user/profile#mobile" class="btn btn-warning">
                                        Zur Verifizierung
                                    </a>
                                </div>
                            @endif
                            <div class="form-group{{ $errors->has('mobile') ? ' has-error' : '' }}">
                                <label class="col-sm-2 control-label" for="mobile">Handynummer</label>

                                <div class="col-sm-10">
                                    <input id="mobile" type="text" class="form-control" name="mobile"
                                           value="{{ old('mobile') }}"
                                           placeholder="">

                                    @if ($errors->has('mobile'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('mobile') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>


                            <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                                <label class="col-sm-2 control-label" for="email">E-Mail</label>

                                <div class="col-sm-10">
                                    <input id="email" type="email" class="form-control" name="email"
                                           value="{{ old('email') }}"
                                           placeholder="">

                                    @if ($errors->has('email'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('email') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>

                            <div class="form-group{{ $errors->has('emailtext') ? ' has-error' : '' }}">
                                <label class="col-sm-2 control-label" for="emailtext">Nachricht</label>

                                <div class="col-sm-10">
                                    <textarea id="emailtext" class="form-control" name="emailtext" placeholder=""></textarea>

                                    @if ($errors->has('emailtext'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('emailtext') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>

                            <div class="form-group">
                                <div class="col-sm-10 col-sm-offset-2">
                                    <button class="btn btn-primary" type="submit"> Senden</button>
                                </div>
                            </div>

                        </form>

                    </div>
                </div>
            </div>
        </div>
@endsection

