@extends('layouts.home')

@section('title', 'RECO.BON einlösen')

@section('content')
    @hasrole('agent')
    <div class="row">
        @foreach($numbers as $number)
            <div class="col-lg-3">
                @include('dashboard.partials.number', $number)
            </div>
        @endforeach
    </div>
    @endhasrole

    @hasrole('seller')
    <div class="ibox float-e-margins">
        <div class="ibox-title">
            <h5>RECO.BON einlösen</h5>
        </div>
        <div class="ibox-content">
            <a class="btn btn-primary" href="{{ route('seller.coupon.redeeming.index') }}">RECO.BON einlösen</a>
        </div>
    </div>
    @endhasrole

    @include('partials/global-filters')

    <div class="ibox float-e-margins">
        <div class="ibox-title">
            <h5>Empfohlene BONS</h5>
        </div>
        <div class="ibox-content">
            {!! $grid->__toString() !!}
        </div>
    </div>

    <div class="ibox float-e-margins">
        <div class="ibox-title">
            @if(Auth::user()->hasRole('agent'))
                <h5>Meine Empfehlungen</h5>
            @else
                <h5>Meine Unternehmensempfehlungen</h5>
            @endif
        </div>

        <div class="ibox-content">
            {!! $multiGrid->__toString() !!}
        </div>
    </div>


    {{--Modals--}}
    <div id="confirmRedeemModal" class="modal fade" tabindex="-1" role="dialog"
         aria-labelledby="myModalLabel"
         aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"
                            aria-hidden="true">&times;  </button>
                    <h4 class="modal-title" id="myModalLabel">Einlösen bestätigen</h4>
                </div>
                <div class="modal-body">
                    <p>
                        Bitte bestätigen Sie die Einlösung.
                    </p>
                </div>
                <div class="modal-footer">
                    <a type="button" class="btn btn-primary">Coupon einlösen</a>
                    <p class="wait" hidden>
                        Der Vorgang kann bis zu einer Minute dauern!
                        <img src="/img/gears.gif">
                    </p>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Schließen</button>
                </div>
            </div>
        </div>
    </div>

    <div id="confirmPaymentModal" class="modal fade" tabindex="-1" role="dialog"
         aria-labelledby="myModalLabel"
         aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"
                            aria-hidden="true">&times;  </button>
                    <h4 class="modal-title" id="myModalLabel">Zahlung bestätigen</h4>
                </div>
                <div class="modal-body">
                    <p>
                        Wenn der RECO.BONs als bezahlt markiert wird, werden die entsprechenden Rechnungen
                        und
                        Gutschriften generiert.
                        Dieser Vorgang ist verbindlich und nicht umkehrbar.
                    </p>
                    <p>
                        Bitte Kontrollieren Sie folgende Daten:
                    </p>

                    <p>
                        Betrag: <strong class="amount"></strong>
                    </p>
                    <p>
                        Kunde: <strong class="consumer"></strong>
                    </p>
                </div>
                <div class="modal-footer">
                    <p class="wait" hidden>
                        Der Vorgang kann bis zu einer Minute dauern!
                        <img src="/img/gears.gif">
                    </p>
                    <a type="button" class="btn btn-primary">Zahlung bestätigen</a>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Schließen</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('after-scripts')
    <script>
        $('.confirm-payment-via-modal').click(function () {


            var $modal = $('#confirmPaymentModal');
            $modal.modal('show');
            var that = this;
            $modal.find('.btn-primary').click(function () {
                $modal.find('.wait').show();
                $modal.find('.btn').hide();
                $.ajax({
                    url: $(that).attr('data-confirm-href'),
                    success: function (data) {
                        window.location.reload();
                    },
                    error: function () {
                        window.alert('Es ist ein Fehler aufgetreten. Bitte versuchen Sie es erneut.');
                        window.location.reload();
                    }
                });
            });
            $modal.find('.amount').html($(this).parent().parent().find('.column-netto').html());
            $modal.find('.consumer').html($(this).parent().parent().find('.column-consumer_user_id').html());
        });

        var overrideSubmitCheck = false;

        $('#redeemCoupon').submit(function () {

            var valueClickedSubmitButtonPayType = $(document.activeElement).val();
            $('#hiddenInputSelectedSubmitButton').val(valueClickedSubmitButtonPayType);

            var $form = this;

            var $modal = $('#confirmRedeemModal');
            $modal.modal('show');
            $modal.find('.btn-primary').attr('href', $(this).attr('data-confirm-href'));
            $modal.find('.btn-primary').click(function () {
                if(valueClickedSubmitButtonPayType=='pay-cash') {
                    $modal.find('.wait').show();
                    $modal.find('.btn').hide();
                }
                $form.submit();
            });
            $modal.find('.amount').html($(this).parent().parent().find('.column-netto').html());
            $modal.find('.consumer').html($(this).parent().parent().find('.column-consumer_user_id').html());
            return false;
        });

        $('.coupon-code').mask("*** *** ***");
    </script>
@endsection
