<?php
    $agent = Auth::user();
?>
@extends('layouts.home')

@section('title', 'Coupons')

@section('content')
    <div class="row">
        @foreach($templates as $template)
            <div class="col-lg-4">
                <div class="ibox float-e-margins">
                    <div class="ibox-title">
                        <h5>RECO.BON zum Versenden</h5>
                    </div>
                    <div class="ibox-content">
                        @include('partials/coupon', compact('template', 'agent'))

                        <div>
                            <p>
                                RECO.CASH: {{ $template->provision_agent }}
                            </p>
                            <p>
                                Kontingent: {{ $template->quota }}
                            </p>
                        </div>

                        <div class="coupon-button">
                            <a class="btn btn-primary-cta" href="{{ route('coupon-send', $template->id) }}"

                               data-toggle="tooltip"
                               data-placement="top" title="Unternehmen mit Hilfe eines RECO.BON empfehlen"><i class="fa fa-send"></i> RECO.BON versenden</a>
                        </div>
                    </div>
                </div>

            </div>
        @endforeach
    </div>
@endsection

