<div class="form-group{{ $errors->has('type_discount') ? ' has-error' : '' }}">
    <label class="col-sm-3 control-label" for="discount_consumer">Cashback Typ</label>
    <div class="col-sm-9">
        @foreach (App\CouponTemplate::DISCOUNT_TYPES as $type)
        @if ( App\CouponTemplate::TYPE_GIFT === $type && !$gifts->count() ) @continue @endif
        <label class="radio-inline">
            <input type="radio"
                   name="type_discount"
                   data-icon="{{ $typeIcons[$type] }}"
                   value="{{ $type }}"
                   @if( $type === old('type_discount', $couponTemplate->type_discount ? $couponTemplate->type_discount : App\CouponTemplate::TYPE_DEFAULT) )
                        checked='checked'
                   @endIf
            >
            {{ $typeNames[$type] }} {{ $typeIcons[$type] }}
        </label>
        @endforeach
        @include('partials.form.error', ['property' => 'type_discount'])
    </div>
</div>

<div class="form-group{{ $errors->has('discount_consumer') ? ' has-error' : '' }}"
     id="discountNumericHolder"
     @if( old('type_discount', $couponTemplate->type_discount) === App\CouponTemplate::TYPE_GIFT ) style="display: none;" @endif
>
    <label class="col-sm-3 control-label" for="discount_consumerInput">
        Cashback in
        <span class="unit">
            {{ $typeIcons[old('type_discount', $couponTemplate->type_discount ? $couponTemplate->type_discount : App\CouponTemplate::TYPE_DEFAULT)] }}
        </span>
    </label>
    <div class="col-sm-9">
        <input id="discount_consumer"
               type="text"
               class="form-control"
               name="discount_consumer"
               value="{{ old('discount_consumer', $couponTemplate->discount_consumer) }}"
               placeholder="Kundenrabatt"
               data-an-input="#discount_consumer"
        >
        @include('partials.form.error', ['property' => 'discount_consumer'])
    </div>
</div>

<div class="form-group{{ $errors->has('discount_gift_id') ? ' has-error' : '' }}"
     id="discountGiftHolder"
     @if( old('type_discount', $couponTemplate->type_discount) !== App\CouponTemplate::TYPE_GIFT ) style="display: none;" @endif
>
    <div class="couponGiftsHolder">
        @include('coupon.partials.gifts', ['property' => 'discount_gift_id'])
    </div>
    @include('partials.form.error', ['property' => 'discount_gift_id'])
</div>

<div class="form-group{{ $errors->has('title') ? ' has-error' : '' }}">
    <label class="col-sm-3 control-label" for="title">RECO.BON Titel</label>
    <div class="col-sm-9">
        <input id="title"
               type="text"
               class="form-control"
               name="title"
               value="{{ old('title', $couponTemplate->title) }}"
               placeholder="Titel deines Gutscheins"
        >
        @include('partials.form.error', ['property' => 'title'])
    </div>
</div>

<div class="form-group{{ $errors->has('category_id') ? ' has-error' : '' }}">
    <label class="col-sm-3 control-label" for="title">Kategorie</label>
    <div class="col-sm-9">
        <select name="category_id" id="category_id" class="form-control select2-groups">
            <option value="0" selected disabled>Kategorie wählen</option>
            @foreach ($categories as $node)
                <option value="{{ $node->id }}"
                    @if( (int)old('category_id', isset($couponTemplate) ? $couponTemplate->category_id : 0) === $node->id ) selected @endif
                    @if( !$node->isLeaf() ) disabled @endif
                >
                {{ str_repeat('&nbsp;&nbsp;&nbsp;', $node->depth) }}
                {{ $node->name }}
            </option>
            @endforeach
        </select>
        @include('partials.form.error', ['property' => 'category_id'])
    </div>
</div>

<div class="form-group{{ $errors->has('images') ? ' has-error' : '' }}">
    <label class="col-sm-3 control-label" for="picture">Bilder</label>
    <div class="col-sm-9">
        @if ( $images->count() )
            <div style="margin-bottom: 10px;">
                @foreach ($images as $image)
                    <div style="display: inline-block">
                        <div>
                            <img src="{{ $image->getUrl('thumb') }}" />
                        </div>
                        <input type="checkbox" value="{{ $image->id }}" name="images_delete[]" /> Löschen
                    </div>
                @endforeach
            </div>
        @endif

        <div id="imagesInputHolder">
            <div class="imagesInputGroup">
                <div class="col-sm-10">
                    <input name="images[]" type="file" accept="image/*" class="btn btn-primary btn-block">
                </div>
                <div class="col-sm-2">
                    <div class="btn btn-danger imagesInputRemove" title="Löschen"><i class="fa fa-trash"></i></div>
                </div>
            </div>
        </div>

        <div class="btn btn-primary" id="imagesInputAdd">Einer noch</div>

        @include('partials.form.error', ['property' => 'images'])
    </div>
</div>

<div class="form-group{{ $errors->has('videos') ? ' has-error' : '' }}">
    <label class="col-sm-3 control-label" for="expiration_date">Video</label>
    <div class="col-sm-9">
        @if ( $videos->count() )
            <video height="250" controls style="object-fit: initial;">
                <source src="{{ $videos[0]->getUrl() }}" type="video/mp4">
                Your browser does not support HTML5 video.
            </video>
        @endif

        <input name="video" type="file" accept="video/mp4" class="btn btn-primary btn-block">

        @if ( $videos->count() )
            <input type="checkbox" value="1" name="video_delete" /> Löschen
        @endif

        @include('partials.form.error', ['property' => 'videos'])
    </div>
</div>

<div class="form-group{{ $errors->has('expiration_date') ? ' has-error' : '' }}">
    <label class="col-sm-3 control-label" for="expiration_date">Aktiv bis...</label>
    <div class="col-sm-9">
        <div class="input-group date" data-provide="datepicker" data-date-format="dd.mm.yyyy">
            <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
            <input name="expiration_date"
                   placeholder="{{ Format::date(Carbon\Carbon::today()) }}"
                   value="{{ old('expiration_date', Format::date($couponTemplate->expiration_date)) }}"
                   class="form-control"
                   type="text"
            >
        </div>
        @include('partials.form.error', ['property' => 'expiration_date'])
    </div>
</div>

<div class="form-group{{ $errors->has('validity') ? ' has-error' : '' }}">
    <label class="col-sm-3 control-label" for="expiration_date">Gültigkeit</label>
    <div class="col-sm-9">
        <select name="validity" size="1" id="validity" class="form-control">
            <option value="">Gültigkeit nach Ausstellung*</option>
            @for($i=1; $i<=24; $i++ )
                <option value="{{ $i }}"{{ ($couponTemplate->validity == $i ? " selected":"") }}>
                    {{ $i }} {{ $i == 1 ? 'Monat' : 'Monate' }}
                </option>
            @endfor
        </select>
        @include('partials.form.error', ['property' => 'validity'])
    </div>
</div>

<div class="form-group{{ $errors->has('description') ? ' has-error' : '' }}">
    <label class="col-sm-3 control-label" for="description">Beschreibung</label>
    <div class="col-sm-9">
        <textarea id="description"
                  type="text"
                  class="form-control"
                  name="description"
                  placeholder="Trage hier bitte deine Beschreibung ein."
        >{{ old('description', $couponTemplate->description) }}</textarea>
        @include('partials.form.error', ['property' => 'description'])
    </div>
</div>

<div class="form-group{{ $errors->has('type_provision') ? ' has-error' : '' }}">
    <label class="col-sm-3 control-label" for="discount_consumer">RECO.CASH Typ</label>
    <div class="col-sm-9">
        @foreach (App\CouponTemplate::PROVISION_TYPES as $type)
        @if ( App\CouponTemplate::TYPE_GIFT === $type && !$gifts->count() ) @continue @endif
        <label class="radio-inline">
            <input type="radio"
                   name="type_provision"
                   data-icon="{{ $typeIcons[$type] }}"
                   value="{{ $type }}"
                   @if( $type === old('type_provision', $couponTemplate->type_provision ? $couponTemplate->type_provision : App\CouponTemplate::TYPE_DEFAULT ) )
                        checked='checked'
                   @endif
            >
            {{ $typeNames[$type] }} {{ $typeIcons[$type] }}
        </label>
        @endforeach
        @include('partials.form.error', ['property' => 'type_provision'])
    </div>
</div>

<div class="form-group{{ $errors->has('provision_agent') ? ' has-error' : '' }}"
     id="provisionNumericHolder"
     @if( in_array(old('type_provision', $couponTemplate->type_provision), [App\CouponTemplate::TYPE_GIFT, App\CouponTemplate::TYPE_NONE]) ) style="display: none;" @endif
>
    <label class="col-sm-3 control-label" for="provision_agent">
        RECO.CASH in
        <span class="unit_recocash">
            {{ $typeIcons[old('type_provision', $couponTemplate->type_provision ? $couponTemplate->type_provision : App\CouponTemplate::TYPE_DEFAULT)] }}
        </span>
    </label>
    <div class="col-sm-9">
        <input id="provision_agent"
               type="text"
               class="form-control"
               name="provision_agent"
               value="{{ old('provision_agent', $couponTemplate->provision_agent) }}"
               placeholder="Empfehlerprovision"
        >
        @include('partials.form.error', ['property' => 'provision_agent'])
    </div>
</div>

<div class="form-group{{ $errors->has('provision_gift_id') ? ' has-error' : '' }}"
     id="provisionGiftHolder"
     @if( old('type_provision', $couponTemplate->type_provision) !== App\CouponTemplate::TYPE_GIFT ) style="display: none;" @endif
>
    <div class="couponGiftsHolder">
        @include('coupon.partials.gifts', ['property' => 'provision_gift_id'])
    </div>
    @include('partials.form.error', ['property' => 'provision_gift_id'])
</div>

<div class="form-group{{ $errors->has('quota') ? ' has-error' : '' }}">
    <label class="col-sm-3 control-label" for="quota">Anzahl RECO.BONS</label>
    <div class="col-sm-9">
        <input id="quota"
               type="text"
               class="form-control"
               name="quota"
               value="{{ old('quota', $couponTemplate->quota) }}"
               placeholder="Wieviele RECO.BONS möchtest du verteilen?"
        >
        @include('partials.form.error', ['property' => 'quota'])
    </div>
</div>

<div class="form-group{{ $errors->has('terms') ? ' has-error' : '' }}">
    <label class="col-sm-3 control-label" for="description">Bedingungen</label>
    <div class="col-sm-9">
        <textarea id="terms"
                  type="text"
                  class="form-control"
                  name="terms"
                  placeholder="Trage hier bitte deine Bedingungen ein."
        >{{ old('terms', $couponTemplate->terms) }}</textarea>
        @include('partials.form.error', ['property' => 'terms'])
    </div>
</div>