@extends('layouts.home')

@section('title', 'RECO.BON erstellen')

@section('content')
    <div class="row coupon-create">
        <div class="col-md-6">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>RECO.BON erstellen</h5>

                </div>
                <div class="ibox-content">

                    <form class="form-horizontal" id="couponCreateOrEdit" role="form" method="POST" enctype="multipart/form-data"
                          action="{{ url('/coupon/edit' . ($couponTemplate->id > 0 ? '/'.$couponTemplate->id : '')) }}">
                        {{ csrf_field() }}

                        @include('coupon.partials.form')

                        <div class="form-group">
                            <div class="col-sm-9 col-sm-offset-3">
                                <button class="btn btn-primary" type="submit">Erstellen</button>
                                <a class="btn btn-primary" href="/coupon" type="submit">Abbrechen</a>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>Vorschau</h5>

                </div>
                <div class="ibox-content">
                    @include('partials/coupon', [
                        'template' => $couponTemplate->type ? $couponTemplate : Auth::user()->fakeTemplate()
                    ])
                </div>
            </div>
        </div>
    </div>
@endsection

@section('after-scripts')
    <script type="text/javascript">
        $(document).ready(function () {

            function readURL(input) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();

                    reader.onload = function(e) {
                        $('#couponImg').attr('src', e.target.result);
                    };

                    reader.readAsDataURL(input.files[0]);
                }
            }

            $("#pictureInput").change(function() {
                readURL(this);
            });

            $('input[name="type_discount"]').on('change', function () {
                var value = $('input[name="type_discount"]:checked').val();
                var icon = $('input[name="type_discount"]:checked').data('icon');
                $('.unit').html(icon);
                if ('{{ App\CouponTemplate::TYPE_GIFT }}' === value) {
                    $('#discountNumericHolder').hide();
                    $('#discountGiftHolder').show();
                } else {
                    $('#discountNumericHolder').show();
                    $('#discountGiftHolder').hide();
                }
            });

            $('input[name="type_provision"]').on('change', function () {
                var value = $('input[name="type_provision"]:checked').val();
                var icon = $('input[name="type_provision"]:checked').data('icon');
                $('.unit_recocash').html(icon);
                if ('{{ App\CouponTemplate::TYPE_NONE }}' === value) {
                    $('#provisionNumericHolder').hide();
                    $('#provisionGiftHolder').hide();
                } else if ('{{ App\CouponTemplate::TYPE_GIFT }}' === value) {
                    $('#provisionNumericHolder').hide();
                    $('#provisionGiftHolder').show();
                } else {
                    $('#provisionNumericHolder').show();
                    $('#provisionGiftHolder').hide();
                }
            });

            $('#imagesInputAdd').on('click', function () {
                $('#imagesInputHolder').append(
                    '<div class="imagesInputGroup">' +
                        '<div class="col-sm-10">' +
                            '<input name="images[]" type="file" accept="image/*" class="btn btn-primary btn-block">' +
                        '</div>' +
                        '<div class="col-sm-2">' +
                            '<div class="btn btn-danger imagesInputRemove" title="Löschen"><i class="fa fa-trash"></i></div>' +
                        '</div>' +
                    '</div>'
                );
            });

            $(document).on('click', '.imagesInputRemove', function () {
                if ( $('.imagesInputGroup').length > 1 ) {
                    $(this).closest('.imagesInputGroup').remove();
                }
            });
        });
    </script>
@endsection