@extends('layouts.home')

@section('title', 'RECO.BON')

@section('content')
    @include('partials.transaction-status')

    <div class="coupon-lists">
        <div class="row">
            <div class="col-md-12">

                @if(count($selectionCouponGroups) > 0)
                    <div class="ibox float-e-margins">
                        <div class="ibox-title">
                            <h5>RECO.BON(s) zum Auswählen</h5>
                        </div>
                        <div class="ibox-content">

                            @foreach($selectionCouponGroups as $group)
                                <div class="@if($group->selection) selection-coupon selection-group-{{ $group->selection_group }} @endif">
                                    <div class="coupon-with-button">
                                        <div class="dummy-coupon">
                                            @include('partials/coupon', ['coupon' => $group, 'selectionDummy' => true])
                                            <div class="coupon-button">
                                                <a class="btn btn-primary-cta">Zur Auswahl</a>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row selectable-coupons">
                                        <div class="col-xs-12">
                                            <div class="alert alert-info">
                                                <h3>Bitte wähle jetzt <strong>einen</strong> Gutschein aus. Die übrigen
                                                    Gutscheine
                                                    aus dieser Auswahl verfallen.</h3>
                                            </div>
                                            @foreach($group->fullSelectionGroup as $coupon)
                                                <div class="coupon-with-button">
                                                    @include('partials/coupon', compact('coupon'))
                                                    <div class="coupon-button">
                                                        <a class="btn btn-circle btn-primary-cta"
                                                           href="/coupon-invitation/accept/{{ $coupon->id }}"><i
                                                                    class="fa fa-check"></i><span
                                                                    class="sr-only">Wählen</span></a>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif
                @if(count($coupons) > 0)
                    <div class="ibox float-e-margins">
                        <div class="ibox-title">
                            <h5>RECO.BON(s) zum Einlösen</h5>
                        </div>
                        <div class="ibox-content">

                            @foreach($coupons as $coupon)
                                <div class="coupon-with-button ">
                                    @include('partials/coupon', compact('coupon'))
                                    <div class="coupon-button visible-lg">
                                        <a class="btn btn-info visible-lg" href="/coupon/view/{{ $coupon->id }}"
                                           data-toggle="tooltip"
                                           data-placement="top" title="Drucken">Drucken</a>
                                    </div>
                                </div>

                            @endforeach
                        </div>
                    </div>
                @endif

                @if(count($couponsFinished) > 0)
                    <div class="ibox float-e-margins">
                        <div class="ibox-title">
                            <h5>RECO.BON(s) eingelöst</h5>
                        </div>
                        <div class="ibox-content">
                            @foreach($couponsFinished as $coupon)
                                <div class="coupon-without-button ">
                                    @include('partials/coupon', compact('coupon'))
                                </div>
                            @endforeach
                        </div>
                        <div class="coupon-button"></div>
                    </div>
                @endif
            </div>
        </div>
        @endsection

        @section('after-scripts')
            <script>
                $(function () {
                    $('.selection-coupon .dummy-coupon').click(function () {
                        $(this).fadeOut('slow', function () {
                            $(this).closest('.selection-coupon').removeClass('col-lg-4').css('display', 'block')
                            $(this).closest('.selection-coupon').find('.selectable-coupons').fadeIn('slow');
                        });
                    });
                });
            </script>

            <script>
                jQuery(function ($) {
                    var startGuide = function () {

                        var guide = $("body").guide();

                        guide.addStep('#welcome','Willkommen bei RECO.MA, Deiner persönlichen Empfehlungsplattform. Im folgenden Tutorial zeigen wir Dir die Funktionen von RECO.MA.');
                        guide.addStep('#cashbar', 'Das ist Deine Cashbar, hier kannst Du Deinen aktuellen Kontostand einsehen. Sobald Dein Cashback (Rabatt nach Einkauf) verfügbar ist, wird der Betrag im Kontostand angezeigt und Du kannst es Dir nach einer abgegebenen Bewertung auszahlen lassen. ');
                        guide.addStep('#show_consumer_transactions', 'Hier kannst Du Deine eingelösten RECO.BONS (Gutscheine) mit dem jeweiligen Status einsehen. Markiere bitte den Kauf als bezahlt, sobald der Kauf tatsächlich abgeschlossen ist und Du die Rechnung bei dem Unternehmen vollständig beglichen hast. ');
                        guide.addStep('#profil', 'Hier kann das Benutzerprofil eingesehen und bearbeitet werden. Im Anschluss an das Tutorial empfehlen wir Dir Dein Profilbild hochzuladen und die fehlenden Angaben zu ergänzen. Bitte vergiss Deine Bankverbindung nicht, sonst können wir Dir Dein Cashback nicht auszahlen. ');
                        guide.start();
                    };

                    if ("{{ $guidance }}" == 0) {
                        startGuide();
                    }

                    $('#help a').click(startGuide);
                });
            </script>
@endsection

