<li class="categoryNode" data-depth="{{ $node->depth }}" data-name="{{ $node->name }}" data-search="{{ mb_strtolower($node->name) }}">
     <div>
        @if ( $node->children->count() )
            <a href="#" class="categoryToggler" data-state="collapsed">
                <i class="fa fa-plus"></i>
            </a>
        @endif

        <span class="categoryChain"></span>
        <span class="categoryName">
            {{ $node->name }}
            <span class="badge">{{ (int)$node->couponTemplatesCount }}</span>
        </span>

        @if ($canEdit)
            <a href="{{ route('category-edit', ['category' => $node]) }}" class="btn btn-primary categoryEdit">
                <i class="fa fa-edit"></i>
            </a>
            <a href="{{ route('category-up', ['category' => $node]) }}" class="btn btn-primary-green categoryMoveUp">
                <i class="fa fa-chevron-up"></i>
            </a>
            <a href="{{ route('category-down', ['category' => $node]) }}" class="btn btn-primary-green categoryMoveDown">
                <i class="fa fa-chevron-down"></i>
            </a>
        @endif

        @if ($canDelete)
            <a href="{{ route('category-delete', ['category' => $node]) }}" class="btn btn-primary-orange categoryDelete">
                <i class="fa fa-remove"></i>
            </a>
        @endif
    </div>
    @if ( $node->children->count() )
        <ul>
            @foreach($node->children as $node)
                @include('categories.partials.node', $node)
            @endforeach
        </ul>
    @endif
</li>