<form class="form-horizontal" method="post" action="{{ $action }}" enctype="multipart/form-data">
    {{ csrf_field() }}
    @if ( isset($category) && $category->id )
    {{ method_field('PUT') }}
    @endif

    <div class="form-group{{ $errors->has('name') ? ' has-error' : '' }}">
        <label class="col-sm-2 control-label" for="name">Titel</label>
        <div class="col-sm-10">
            <input id="name" type="text" class="form-control" name="name" value="{{ old('name', isset($category) ? $category->name : '') }}" placeholder="Titel">

            @include('partials.form.error', ['property' => 'name'])
        </div>
    </div>

    <div class="form-group{{ $errors->has('slug') ? ' has-error' : '' }}">
        <label class="col-sm-2 control-label" for="name">Slug</label>
        <div class="col-sm-10">
            <input id="name" type="text" class="form-control" name="slug" value="{{ old('slug', isset($category) ? $category->slug : '') }}" placeholder="Slug">

            @include('partials.form.error', ['property' => 'slug'])
        </div>
    </div>

    <div class="form-group{{ $errors->has('parent') ? ' has-error' : '' }}">
        <label class="col-sm-2 control-label" for="parent_id">Elternteil</label>
        <div class="col-sm-10">
            <select name="parent_id" id="parent_id" class="form-control select2-groups">
                <option value="" selected>Root-Kategorie</option>
                @foreach ($categories as $node)
                    <option value="{{ $node->id }}"
                        @if( (int)old('parent_id', isset($category) ? $category->parent_id : 0) === $node->id ) selected @endif
                    >
                        {{ str_repeat('&nbsp;&nbsp;&nbsp;', $node->depth) }}
                        {{ $node->name }}
                    </option>
                @endforeach
            </select>

            @include('partials.form.error', ['property' => 'parent_id'])
        </div>
    </div>

    <div class="form-group{{ $errors->has('icon') ? ' has-error' : '' }}">
        <label class="col-sm-2 control-label" for="name">Bild</label>
        <div class="col-sm-10">
            <input name="icon" type="file" accept="image/*" class="btn btn-primary btn-block" id="categoryIconInput">

            @include('partials.form.error', ['property' => 'icon'])

            <div id="categoryIconRemoveHolder" @if ( !(isset($category) && $category->icon) ) style="display: none;" @endif>
                <a href="#" class="btn btn-danger" id="categoryIconRemove">
                    <i class="fa fa-remove"></i> Löschen
                </a>
                <input type="hidden" id="categoryIconRemoveFlag" name="icon_remove" value="0">
            </div>

            @if ( isset($category) && $category->icon )
                <img id="categoryIcon" src="{{ asset($category->icon) }}">
            @else
                <img id="categoryIcon" src="" style="display: none;">
            @endif
        </div>
    </div>

    <div class="form-group">
        <label class="col-sm-2 control-label"></label>
        <div class="col-sm-10">
            <button type="submit" class="btn btn-primary">
                <i class="fa fa-save"></i> Speichern
            </button>
            <a href="{{ route('category-list') }}" class="btn btn-default">
                <i class="fa fa-close"></i> Abbrechen
            </a>
        </div>
    </div>
</form>