@extends('layouts.home')

@section('title', 'Kategorien')

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>Kategorien</h5>
                </div>
                <div class="ibox-content">
                    @if ($canCreate)
                    <div>
                        <a href="{{ route('category-create') }}" class="btn btn-primary">
                            <i class="fa fa-plus-circle"></i> Neue Kategorie
                        </a>
                    </div>
                    @endif

                    <div style="margin: 10px 0;">
                        <form class="form-inline">
                            <div class="form-group">
                                <label for="categorySearchInput">Ketegorie suche</label>
                                <input type="text" class="form-control" id="categorySearchInput">
                            </div>
                            <a href="#" class="btn btn-primary" id="categorySearchReset">
                                <i class="fa fa-recycle"></i> Reset
                            </a>
                        </form>
                    </div>

                    <div id="categoryTree" class="categoryTree">
                        <ul>
                            @foreach($tree as $node)
                                @include('categories.partials.node', $node)
                            @endforeach
                        </ul>
                    </div>

                    <div id="categorySearchResults">
                        <span id="categorySearchResultNothing">Nichts gefunden</span>
                        <div id="categorySearchResultsHolder" class="categoryTree"></div>
                    </div>
                </div>

                <form action="" method="post" style="display: none" id="categoryDeleteForm">
                    {{ csrf_field() }}
                    {{ method_field('DELETE') }}
                </form>
            </div>
        </div>
    </div>
@endsection

@section('after-scripts')
    <script>
        $(document).ready(function () {
            var categoryBuildChain = function (node) {
                var chain = [];
                var depth = parseInt(node.data('depth')) - 1, i = 0;
                var next = node.parent().closest('.categoryNode');
                chain.unshift(next.data('name'));
                for (i; i < depth; i++) {
                    next = next.parent().closest('li');
                    chain.unshift(next.data('name'));
                }
                node.find('.categoryChain').first().text(chain.join(' / ') + ' / ');
            };

            var categoriesBuildChains = function () {
                var nodes = $('#categoryTree li[data-depth!="0"]');
                var len = nodes.length, i = 0;
                for (i; i < len; i++) {
                    categoryBuildChain($(nodes[i]));
                }
            };

            var categorySearch = function (s) {
                s = s.toLowerCase();
                if ('' === s) {
                    $('#categoryTree').show();
                    $('#categorySearchResults').hide();
                    $('#categorySearchResultsHolder').html('');
                } else {
                    $('#categoryTree').hide();
                    $('#categorySearchResults').show();
                    var nodes = $('#categoryTree li[data-search*="' + s + '"]');
                    if (0 === nodes.length) {
                        $('#categorySearchResultNothing').show();
                        $('#categorySearchResultsHolder').html('');
                    } else {
                        nodes = nodes.clone(true, true);
                        nodes.find('ul, .categoryToggler, .categoryMoveUp, .categoryMoveDown').remove();
                        nodes.find('.categoryChain').show();
                        $('#categorySearchResultNothing').hide();
                        $('#categorySearchResultsHolder').html(nodes);
                    }
                }
            };

            $('.categoryToggler').on('click', function (e) {
                e.preventDefault();
                e.stopPropagation();

                var state = $(this).data('state');
                if ('collapsed' === state) {
                    $(this).closest('li').find('ul').first().show();
                    $(this).data('state', 'expanded');
                    $(this).html('<i class="fa fa-minus"></i>');
                } else {
                    $(this).closest('li').find('ul').first().hide();
                    $(this).data('state', 'collapsed');
                    $(this).html('<i class="fa fa-plus"></i>');
                }
            });

            $('#categorySearchInput').on('change keyup', function () {
                categorySearch($(this).val());
            });

            $('#categorySearchReset').on('click', function (e) {
                e.preventDefault();
                e.stopPropagation();

                $('#categorySearchInput').val('');
                categorySearch('');
            });

            $('.categoryDelete').on('click', function (e) {
                e.preventDefault();
                e.stopPropagation();

                if ( confirm('Bist du sicher? Aktion ist nicht kündbar') ) {
                    $('#categoryDeleteForm')
                        .attr('action', $(this).attr('href'))
                        .submit();
                }
            });

            categoriesBuildChains();
        });
    </script>
@endsection