@extends('layouts.home')

@section('title', 'Bankkonto Transaktionen')

@section('content')
    @include('partials/global-filters')

    <div class="row">
        <div class="col-md-12">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>Manuelle Zuordnung</h5>
                </div>
                <div class="ibox-content">

                    <div class="row">
                        <div class="col-sm-10 col-sm-offset-2">
                            <p>Datum: {{ Format::date($bankTransaction->date) }}</p>
                            <p>Valuta: {{ Format::date($bankTransaction->valuta_date) }}</p>
                            <p>Gegenkonto - Bank: {{ $bankTransaction->remote_bank_code }}</p>
                            <p>
                                Kontoinhaber: {{ str_replace('|', '', e($bankTransaction->remote_account_holder_name)) }}</p>
                            <p>Betrag: {{ Format::currency($bankTransaction->amount) }}</p>
                            <p>Verwendungszweck: {{ str_replace('|', ' ', e($bankTransaction->purpose)) }}</p>
                        </div>
                    </div>

                    <form class="form-horizontal" id="userEditForm" role="form" method="POST"
                          enctype="multipart/form-data"
                          action="{{ url('/bank_transaction') }}">
                        {{ csrf_field() }}

                        <input type="hidden" name="bank_transaction_id" value="{{ $bankTransaction->id }}">

                        <div class="form-group">
                            <label for="multi-prepend" class="col-sm-2 control-label">Rechnung</label>

                            <div class="col-sm-10">
                                <div class="input-group">
                                    <select name="invoice_id" id="multi-prepend"
                                            class="form-control">
                                        <option value="">-/-</option>
                                        @foreach($invoices as $invoice)
                                            <option value="{{ $invoice->id }}">
                                                {{ $invoice->number }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="creditnote-select" class="col-sm-2 control-label">Gutschrift</label>

                            <div class="col-sm-10">
                                <div class="input-group">
                                    <select name="creditnote_id" class="form-control" id="creditnote-select">
                                        <option value="">-/-</option>
                                        @foreach($creditnotes as $creditnote)
                                            <option value="{{ $creditnote->id }}">
                                                {{ $creditnote->number }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>



                        <div class="form-group">
                            <div class="col-sm-10 col-sm-offset-2">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fa fa-btn fa-user"></i> Speichern
                                </button>
                            </div>
                        </div>

                    </form>

                </div>
            </div>
        </div>
    </div>
@endsection

