<!DOCTYPE html>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>RECO.MA | Registrierung</title>
    <link href="{{ URL::asset('css/plugins/steps/jquery.steps.css') }}" rel="stylesheet">

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">

    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <link href="{{ URL::asset('css/app.css') }}" rel="stylesheet">

    <!-- Steps style -->

    <script src="{{ URL::asset('js/jquery-2.1.1.js') }}"></script>
    <script src="{{ URL::asset('js/bootstrap.min.js') }}"></script>
    <script src="{{ URL::asset('js/plugins/staps/jquery.steps.min.js') }}"></script>

    <!-- Laravel Javascript Validation -->
    <script type="text/javascript" src="{{ URL::asset('vendor/jsvalidation/js/jsvalidation.js')}}"></script>


</head>

<body class="gray-bg">

<div class="register row text-center">
    <div class="col-md-push-1 col-md-6 col-xs-12">
        <h1 class="logo-name"><a href="/"><img src="/img/reco.ma logo.svg"></a></h1>

        <!-- ratio 640x360 -->
        <iframe src="https://player.vimeo.com/video/200662115" frameborder="0"
                webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>
    </div>
    <div class="col-md-push-1 col-md-4 col-xs-12">
        <div class="middle-box register-box animated fadeInDown">
            <h3>Alles, was Sie für Ihre Empfehlungen brauchen.</h3>

            <p>Mit RECO.MA <strong>mehr positive Empfehlungen</strong> für Ihr <strong>Unternehmen bekommen</strong>,
                <strong>mehr Aufträge</strong> erhalten und <strong>Umsatz maximieren</strong>.</p>
            </p>

            <h4>Als Unternehmen registrieren</h4>

            <div id="register-wrapper">
                <form id="register-form" class="m-t" role="form" method="POST" action="{{ url('/register') }}">
                    {{ csrf_field() }}
                    <div>
                        <h3>Anmeldung</h3>
                        <section>
                            <div class="form-group{{ $errors->has('salutation') ? ' has-error' : '' }}">
                                <select name="salutation" size="1" id="salutation" class="form-control">
                                    <option value="">Bitte Anrede auswählen*</option>
                                    <option value="Herr"{{ (Input::old("salutation") == 'Herr' ? " selected":"") }}>Herr
                                    </option>
                                    <option value="Frau"{{ (Input::old("salutation") == 'Frau' ? " selected":"") }}>Frau
                                    </option>
                                </select>
                            </div>

                            <div class="form-group{{ $errors->has('firstname') ? ' has-error' : '' }}">
                                <input id="firstname" type="text" class="form-control" name="firstname"
                                       value="{{ old('firstname') }}"
                                       required>
                                <label alt="Vorname*" placeholder="Vorname*"></label>

                                @if ($errors->has('firstname'))
                                    <span class="help-block">
                            <strong>{{ $errors->first('firstname') }}</strong>
                        </span>
                                @endif
                            </div>

                            <div class="form-group{{ $errors->has('surname') ? ' has-error' : '' }}">
                                <input id="surname" type="text" class="form-control" name="surname"
                                       value="{{ old('surname') }}"
                                       required>
                                <label alt="Nachname*" placeholder="Nachname*"></label>
                                @if ($errors->has('surname'))
                                    <span class="help-block">
                            <strong>{{ $errors->first('surname') }}</strong>
                        </span>
                                @endif
                            </div>

                            <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                                <input id="email" type="email" class="form-control" name="email"
                                       value="{{ old('email') }}"
                                       required>
                                <label alt="E-Mail Adresse*" placeholder="E-Mail Adresse*"></label>
                                @if ($errors->has('email'))
                                    <span class="help-block">
                            <strong>{{ $errors->first('email') }}</strong>
                        </span>
                                @endif
                            </div>

                            <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }}">
                                <input id="password" type="password" class="form-control" name="password"
                                       required pattern=".{6,}" title="6 Zeichen minimum">
                                <label alt="Passwort*" placeholder="Passwort*"></label>

                                @if ($errors->has('password'))
                                    <span class="help-block">
                            <strong>{{ $errors->first('password') }}</strong>
                        </span>
                                @endif
                            </div>

                            <div class="form-group{{ $errors->has('password_confirmation') ? ' has-error' : '' }}">
                                <input id="password_confirmation" type="password" class="form-control"
                                       name="password_confirmation"
                                       required pattern=".{6,}" title="6 Zeichen minimum">
                                <label alt="Passwort bestätigen*" placeholder="Passwort bestätigen*"></label>
                                @if ($errors->has('password_confirmation'))
                                    <span class="help-block">
                            <strong>{{ $errors->first('password_confirmation') }}</strong>
                        </span>
                                @endif
                            </div>
                        </section>
                        <h3>Adressdaten</h3>
                        <section>

                            <div class="form-group{{ $errors->has('company') ? ' has-error' : '' }}">
                                <input id="company" type="text" class="form-control" name="company"
                                       value="{{ old('company') }}"
                                       required>
                                <label alt="Firma*" placeholder="Firma*"></label>
                                @if ($errors->has('company'))
                                    <span class="help-block">
                            <strong>{{ $errors->first('company') }}</strong>
                        </span>
                                @endif
                            </div>

                            <div class="form-group{{ $errors->has('tax_id') ? ' has-error' : '' }}">
                                <input id="tax_id" type="text" class="form-control" name="tax_id"
                                       value="{{ old('tax_id') }}"
                                       required>
                                <label alt="Umsatzsteuer oder Umsatzsteuer ID Nr."
                                       placeholder="USt-IDNr. oder Steuernummer"></label>
                                @if ($errors->has('tax_id'))
                                    <span class="help-block">
                            <strong>{{ $errors->first('tax_id') }}</strong>
                                    </span>
                                @endif
                            </div>

                            <div class="row">
                                <div class="col-xs-8">
                                    <div class="form-group{{ $errors->has('street') ? ' has-error' : '' }}">
                                        <input id="street" type="text" class="form-control" name="street"
                                               value="{{ old('street') }}"
                                               required>
                                        <label alt="Straße*" placeholder="Straße*"></label>
                                        @if ($errors->has('street'))
                                            <span class="help-block">
                            <strong>{{ $errors->first('street') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>

                                <div class="col-xs-4">
                                    <div class="form-group{{ $errors->has('housenumber') ? ' has-error' : '' }}">
                                        <input id="housenumber" type="text" class="form-control" name="housenumber"
                                               value="{{ old('housenumber') }}"
                                               required>
                                        <label alt="Nr*" placeholder="Nr*"></label>
                                        @if ($errors->has('housenumber'))
                                            <span class="help-block">
                            <strong>{{ $errors->first('housenumber') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="row">

                                <div class="col-xs-4">

                                    <div class="form-group{{ $errors->has('zip') ? ' has-error' : '' }}">
                                        <input id="zip" type="text" class="form-control" name="zip"
                                               value="{{ old('zip') }}"
                                               required>
                                        <label alt="PLZ*" placeholder="PLZ*"></label>
                                        @if ($errors->has('zip'))
                                            <span class="help-block">
                            <strong>{{ $errors->first('zip') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-xs-8">


                                    <div class="form-group{{ $errors->has('city') ? ' has-error' : '' }}">
                                        <input id="city" type="text" class="form-control" name="city"
                                               value="{{ old('city') }}"
                                               required>
                                        <label alt="Ort*" placeholder="Ort*"></label>
                                        @if ($errors->has('city'))
                                            <span class="help-block">
                            <strong>{{ $errors->first('city') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>


                            <div class="form-group{{ $errors->has('phone') ? ' has-error' : '' }}">
                                <input id="phone" type="text" class="form-control" name="phone"
                                       value="{{ old('phone') }}"
                                       required>
                                <label alt="Telefonnr. nur für Rückfragen*"
                                       placeholder="Telefonnr. nur für Rückfragen*"></label>
                                @if ($errors->has('phone'))
                                    <span class="help-block">
                            <strong>{{ $errors->first('phone') }}</strong>
                                    </span>
                                @endif
                            </div>

                            <div class="form-group{{ $errors->has('all_connections') ? ' has-error' : '' }}">
                                <select name="all_connections" size="1" id="all_connections" class="form-control">
                                    <option value="">Wer darf Sie empfehlen?*</option>
                                    <option value="1"{{ (Input::old("all_connections") == '1' ? " selected":"") }}>Alle
                                        Empfehler
                                    </option>
                                    <option value="0"{{ (Input::old("all_connections") == '0' ? " selected":"") }}>Nur
                                        von
                                        mir eingeladene Empfehler
                                    </option>
                                </select>
                            </div>

                        </section>
                        <h3>Zahlungsart</h3>
                        <section>
                            <div class="form-group{{ $errors->has('payment') ? ' has-error' : '' }}">
                                <select name="payment" size="1" id="payment" class="form-control">
                                    <option value="">Bitte Zahlungsmethode auswählen*</option>
                                    <option value="year" selected>Jährliche Zahlung - {{ Format::currency(config('recoma.yearlySubscriptionFee')) }} netto**</option>
                                    <option value="month">Monatliche Zahlung - {{ Format::currency(config('recoma.monthlySubscriptionFee')) }} netto**</option>
                                </select>
                                **In der Beta kostenfrei.
                            </div>

                            <div class="form-group{{ $errors->has('iban_owner') ? ' has-error' : '' }}">
                                <input id="iban_owner" type="text" class="form-control" name="iban_owner"
                                       value="{{ old('iban_owner') }}"
                                       required>
                                <label alt="Kontoinhaber*" placeholder="Kontoinhaber*"></label>
                                @if ($errors->has('iban_owner'))
                                    <span class="help-block">
                            <strong>{{ $errors->first('iban_owner') }}</strong>
                                    </span>
                                @endif
                            </div>

                            <div class="form-group{{ $errors->has('iban') ? ' has-error' : '' }}">
                                <input id="iban" type="text" class="form-control" name="iban" value="{{ old('iban') }}"
                                       required>
                                <label alt="IBAN*" placeholder="IBAN*"></label>
                                @if ($errors->has('iban'))
                                    <span class="help-block">
                            <strong>{{ $errors->first('iban') }}</strong>
                                    </span>
                                @endif
                            </div>


                            <div class="col-md-12 text-left agreements">
                                <label>
                                    <input type="checkbox" id="agb" name="agb" value="agb" class="form-group" required>
                                    <a target="_blank" href="{{ url('/pa') }}">AGB</a> und <a target="_blank"
                                                                                              href="{{ url('/pd') }}">Datenschutzerklärung</a>
                                    akzeptieren
                                </label>
                                <p>
                                Die Zahlung erfolgt per Lastschrift.
                                </p>
                                <label>
                                    <input type="checkbox" id="sepa" name="sepa" value="sepa" class="form-group" required>
                                    <strong>SEPA-Lastschriftmandat erteilen</strong>
                                </label>
                                <p>
                                    Hiermit erteile ich die zur SEPA-Basislastschrift erfoderliche Ermächtigung und Anweisung
                                    und erkläre, die weiteren Hinweis zur Kenntnis genommen zu haben.
                                </p>
                                <label>
                                    <input type="checkbox" id="newsletter" name="newsletter" value="true" class="form-group">
                                    <strong>Newsletter anmeldung</strong>
                                </label>

                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-primary block full-width m-b">
                                    Registrieren
                                </button>
                            </div>


                            <h4>0% Risiko mit unserer Geld-zurück-Garantie</h4>

                            <p class="guarantee">
                                Erfolg ohne Risiko. Manchmal müssen wir Dinge erst einmal ausprobieren, um zu wissen,
                                welche Vorteile sie uns bringen. Bei uns ist es möglich! Sie können von Beginn den
                                vollen Funktionsumfang mit allen Features nutzen und völlig unverbindlich testen. Wenn
                                Sie unzufrieden sind und in den ersten 30 Tagen kündigen, erstatten wir den ersten
                                Monatsbeitrag zurück.
                            </p>
                        </section>
                    </div>
                </form>
                {!! JsValidator::formRequest('App\Http\Requests\SellerRegistrationRequest', '#register-form') !!}
            </div>
            <script>
                $(function () {
                    $('#surname').blur(function () {
                        if ($('#iban_owner').val() == '') {
                            $('#iban_owner').val($('#firstname').val() + ' ' + $('#surname').val());
                        }
                    })
                });

                $("#register-wrapper div").steps({
                        headerTag: "h3",
                        bodyTag: "section",
                        transitionEffect: "slideLeft",
                        autoFocus: true,
                        titleTemplate: '#title#',
                        enableCancelButton: false,
                        enableFinishButton: false,
                        enableKeyNavigation: false,
                        onStepChanging: function (event, currentIndex, newIndex) {
                            if (currentIndex > newIndex) {
                                return true;
                            }
                            var form = $('#register-form');
                            form.validate().settings.ignore = ":disabled,:hidden";
                            return form.valid();
                        },
                        labels: {
                            next: "Weiter",
                            previous: "Zurück",
                        }

                    }
                )
                ;
            </script>
        </div>
    </div>
</div>

</body>
</html>
