@extends('layouts.root')

@section('title','Passwort')

@section('head.links')
    <link href="{{ URL::asset('css/bootstrap.min.css')}}" rel="stylesheet">
    <link href="{{ URL::asset('font-awesome/css/font-awesome.css')}}" rel="stylesheet">
    <link href="{{ URL::asset('css/animate.css')}}" rel="stylesheet">
    <link href="{{ URL::asset('css/style.css')}}" rel="stylesheet">
    <link href="{{ URL::asset('css/app.css') }}" rel="stylesheet">
@endsection

@section('body.class', 'gray-bg')

@section('body')

    <div class="middle-box text-center animated fadeInDown">
        <div>
            <h1 class="logo-name"><a href="/"><img width="100%" src="/img/reco.ma logo.svg"></a></h1>
        </div>
        <h3 class="font-bold">Passwort vergessen</h3>
        <p>
            Bitte tragen Sie Ihre <span class="text-nowrap">E-Mail</span> Adresse und Ihr neues Passwort ein.
        </p>
        <br>
        <div class="col-lg-12">
            <form class="form-horizontal" role="form" method="POST" action="{{ url('/password/reset') }}">
                {{ csrf_field() }}
                <input type="hidden" name="token" value="{{ $token }}">
                <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                    <label for="email" class="col-md-4 text-left">Email Adresse</label>

                    <input id="email" type="email" class="form-control" name="email"
                           value="{{ $email or old('email') }}" placeholder="Email Adresse">

                    @if ($errors->has('email'))
                        <span class="help-block">
                            <strong>{{ $errors->first('email') }}</strong>
                        </span>
                    @endif
                </div>
                <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }}">
                    <label for="password" class="col-md-4 text-left">Passwort</label>

                    <input id="password" type="password" class="form-control" name="password" placeholder="Passwort">

                    @if ($errors->has('password'))
                        <span class="help-block">
                            <strong>{{ $errors->first('password') }}</strong>
                        </span>
                    @endif
                </div>
                <div class="form-group{{ $errors->has('password_confirmation') ? ' has-error' : '' }}">
                    <label for="password-confirm" class="col-md-4 text-left">Passwort bestätigen</label>
                    <input id="password-confirm" type="password" class="form-control" name="password_confirmation"
                           placeholder="Passwort bestätigen">
                    @if ($errors->has('password_confirmation'))
                        <span class="help-block">
                            <strong>{{ $errors->first('password_confirmation') }}</strong>
                        </span>
                    @endif
                </div>
                <div class="form-group">
                    <button type="submit" class="btn btn-primary block full-width m-b">Passwort speichern</button>
                </div>
            </form>
        </div>
        <p class="m-t text-center">
            <small>RECO.MA &copy; 2017</small>
        </p>
    </div>

@endsection

@include('partials.footer-guest')