@extends('layouts.root')

@section('title','login')

@section('head.links')
    <link href="{{ URL::asset('css/bootstrap.min.css')}}" rel="stylesheet">
    <link href="{{ URL::asset('font-awesome/css/font-awesome.css')}}" rel="stylesheet">
    <link href="{{ URL::asset('css/animate.css')}}" rel="stylesheet">
    <link href="{{ URL::asset('css/style.css')}}" rel="stylesheet">
    <link href="{{ URL::asset('css/app.css') }}" rel="stylesheet">
@endsection

@section('body.class', 'gray-bg')

@section('body')
    <div class="middle-box text-center animated fadeInDown">
        <div>
            <h1 class="logo-name"><a href="/"><img width="100%" src="/img/reco.ma logo.svg"></a></h1>
        </div>
        <h3 class="font-bold">Passwort vergessen</h3>
        <p>
            Bitte tragen Sie Ihre <span class="text-nowrap">E-Mail</span> Adresse hier ein. Wir schicken Ihnen im Anschluss eine <span class="text-nowrap">E-Mail</span> mit Ihrem neuen Passwort.
        </p>
        <div class="col-lg-12">
            <form class="m-t" role="form" method="POST" action="{{ url('/password/email') }}">
                {{ csrf_field() }}
                <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                    <input id="email" name="email" type="email" class="form-control" placeholder="E-Mail Adresse" value="{{ old('email') }}">
                    @if ($errors->has('email'))
                        <span class="help-block">
                            <strong>{{ $errors->first('email') }}</strong>
                        </span>
                    @endif
                </div>
                <button type="submit" class="btn btn-primary block full-width m-b">Passwort anfordern</button>
            </form>
        </div>
        <p class="m-t text-center"> <small>RECO.MA &copy; 2017</small> </p>
    </div>
@endsection

@include('partials.footer-guest')