@extends('layouts.root')

@section('title','login')

@section('head.links')
    <link href="{{ URL::asset('css/bootstrap.min.css')}}" rel="stylesheet">
    <link href="{{ URL::asset('font-awesome/css/font-awesome.css')}}" rel="stylesheet">

    <link href="{{ URL::asset('css/animate.css')}}" rel="stylesheet">
    <link href="{{ URL::asset('css/style.css')}}" rel="stylesheet">
    <link href="{{ URL::asset('css/app.css') }}" rel="stylesheet">
@endsection

@section('body.class', 'gray-bg')

@section('body')
<div class="middle-box text-center animated fadeInDown">
    <div>
        <h1 class="logo-name"><img width="100%" src="/img/reco.ma logo.svg"></h1>
    </div>
    <h3>Willkommen zu reco.ma</h3>
    <form class="m-t" role="form" method="POST" action="{{ url('/login') }}">
        {{ csrf_field() }}
        <input id="token" name="token" type="hidden" value="{{ $token ?? -1 }}">
        <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
            <input id="email" name="email" value="{{ old('email') }}" type="text" class="form-control"
                   placeholder="E-Mail">
 @if (config('app.env') == 'local')
            <select name="email_quicklogin" id="email_quicklogin" class="form-control">
                <option value="">Quicklogin for Testing</option>
                <option value="operator@reco.ma">operator@reco.ma</option>
                <option value="consumer@reco.ma">consumer@reco.ma</option>
                <option value="agent@reco.ma">agent@reco.ma</option>
                <option value="agent-consumer@reco.ma">agent-consumer@reco.ma</option>
                <option value="fieldservice_employee@reco.ma">fieldservice_employee@reco.ma</option>
                <option value="seller@reco.ma">seller@reco.ma</option>
                <option value="seller_for_all@reco.ma">seller_for_all@reco.ma</option>
            </select>
@endif
            @if ($errors->has('email'))
                <span class="help-block">
                                    <strong>{{ $errors->first('email') }}</strong>
                                </span>
            @endif
        </div>
        <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }}">
            <input id="password" name="password" type="password" class="form-control" placeholder="Passwort">

            @if ($errors->has('password'))
                <span class="help-block">
                                    <strong>{{ $errors->first('password') }}</strong>
                                </span>
            @endif
        </div>

        <button type="submit" class="btn btn-primary block full-width m-b">Anmelden</button>

        <a href="{{ url('/password/reset') }}">
            <small>Passwort vergessen?</small>
        </a>

        <!-- <p class="text-muted text-center"><small>Sei dabei?</small></p> -->

    </form>
    <p class="m-t">
        <small>RECO.MA &copy; 2017</small>
    </p>

</div>
@include('partials.footer-guest')
<!-- Mainly scripts -->
<script src="{{ URL::asset('js/jquery-2.1.1.js')}}"></script>
<script src="{{ URL::asset('js/bootstrap.min.js')}}"></script>

@if (config('app.env') == 'local')

    <script>
        $('#email_quicklogin').change(function() {
            $('#email').val($(this).val());
            $('#password').val('dev');
            $('form .btn-primary').click(); // workaround https://github.com/barryvdh/laravel-debugbar/issues/176
        });
    </script>
@endif
@endsection

