@extends('layouts.home')

@section('title', 'Vermittl Verwaltung')

@section('content')
    <div class="row">
        @can('invite agents')
            <div class="col-lg-6">
                <div class="dashboard-button-like-widget">
                    <div class="dashboard-button float-e-margins">
                        <a class="ibox-content invite" href="{{ url('/seller-invite-new-agent') }}"><i class="fa fa-plus"></i>&nbsp;Neuen
                            Empfehler einladen</a>
                    </div>
                </div>
            </div>
        @endcan
        @foreach($numbers as $number)
            <div class="col-lg-3">
                @include('dashboard.partials.number', $number)
            </div>
        @endforeach
    </div>

    @include('partials/global-filters')

    <div class="row">
        <div class="col-md-12">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>Meine Empfehler</h5>
                </div>
                <div class="ibox-content">

                    {!! $my_agents->__toString() !!}

                </div>
            </div>
        </div>
    </div>

    {{--Modal--}}
    <div id="deleteModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
         aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;  </button>
                    <h4 class="modal-title" id="myModalLabel">Zusammenarbeit beenden</h4>
                </div>
                <div class="modal-body">
                    <p>
                        Die Zusammenarbeit mit <strong class="agent"></strong> wirklich beenden?
                    </p>
                </div>
                <div class="modal-footer">
                    <a type="button" class="btn btn-primary">Bestätigen</a>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Abbrechen</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('after-scripts')
    <script>
        $('.delete-via-modal').click(function () {
            $('#deleteModal').modal('show');
            $('#deleteModal .btn-primary').attr('href', $(this).attr('data-delete-href'));
            $('#deleteModal .agent').html($(this).parent().parent().find('.column-company').html());
        });
    </script>
@endsection