@extends('layouts.home')

@section('title', 'Empfehler einladen')

@section('content')
    <div class="row">
            <div class="col-md-12">
                <div class="ibox float-e-margins">
                    <div class="ibox-title">
                        <h5>Empfehler einladen</h5>
                        <div class="ibox-tools dropdown" dropdown="">
                            <a href="/user"><i class="fa fa-times"></i></a>
                        </div>
                    </div>
                    <div class="ibox-content">
                        <form class="form-horizontal" role="form" method="POST" action="{{ url('/agent/create') }}">
                            {{ csrf_field() }}

                            <div class="form-group{{ $errors->has('salutation') ? ' has-error' : '' }}">
                                <label for="salutation" class="col-sm-2 control-label">Anrede</label>

                                <div class="col-sm-10">
                                    {!! Form::select('salutation', array('Herr' => 'Herr', 'Frau' => 'Frau'), old('salutation'), array('class' => 'form-control')) !!}
                                </div>
                            </div>

                            <div class="form-group{{ $errors->has('firstname') ? ' has-error' : '' }}">
                                <label for="firstname" class="col-sm-2 control-label">Vorname</label>

                                <div class="col-sm-10">
                                    <input id="firstname" type="text" class="form-control" name="firstname"
                                           value="{{ old('firstname') }}">

                                    @if ($errors->has('firstname'))
                                        <span class="help-block">
                                        <strong>{{ $errors->first('firstname') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>

                            <div class="form-group{{ $errors->has('surname') ? ' has-error' : '' }}">
                                <label for="surname" class="col-sm-2 control-label">Nachname</label>

                                <div class="col-sm-10">
                                    <input id="surname" type="text" class="form-control" name="surname"
                                           value="{{ old('surname') }}">

                                    @if ($errors->has('surname'))
                                        <span class="help-block">
                                        <strong>{{ $errors->first('surname') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>

                            <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                                <label for="email" class="col-sm-2 control-label">E-Mail Adresse</label>

                                <div class="col-sm-10">
                                    <input id="email" type="email" class="form-control" name="email"
                                           value="{{ old('email') }}">

                                    @if ($errors->has('email'))
                                        <span class="help-block">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>

                            <div class="form-group">
                                <div class="col-sm-10 col-sm-offset-2">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fa fa-btn fa-user"></i> Einladen
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
@endsection
