@extends('layouts.home')

@section('title', 'Mirgliederverwaltung')



@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>Mitarbeiter anlegen</h5>
                </div>
                <div id="invite-member" class="ibox-content">
                    <form class="form-horizontal" role="form" method="POST" enctype="multipart/form-data" action="{{ url('/member/invite') }}">
                    {{ csrf_field() }}

                        <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                            <label for="email" class="col-sm-2 control-label">E-Mail Adresse</label>

                            <div class="col-sm-10">
                                <input id="email" type="email" class="form-control" name="email">

                                @if ($errors->has('email'))
                                    <span class="help-block">
                                    <strong>{{ $errors->first('email') }}</strong>
                                </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-sm-10 col-sm-offset-2">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fa fa-btn fa-user"></i> Einladen
                                </button>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>

    @include('partials/global-filters')

    <div class="row">
        <div class="col-md-12">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>Mitarbeiterverwaltung</h5>
                </div>
                <div class="ibox-content">
                    {!! $grid->__toString() !!}
                </div>
            </div>
        </div>
    </div>
@endsection

@section('after-scripts')

@endsection