@extends('layouts.home')

@section('title', 'Page Title')



@section('content')
    <form class="form-horizontal" role="form" method="POST" enctype="multipart/form-data"
          action="{{ url('/account') }}">
        {{ csrf_field() }}

        <div class="row">
            <div class="col-md-12">
                <div class="ibox float-e-margins">
                    <div class="ibox-title">
                        <h5>Firmenprofil</h5>
                    </div>
                    <div class="ibox-content">


                        <input type="hidden" name="id" value="{{ Auth::user()->account->id }}">

                        @if(Auth::user()->hasRole('seller') || Auth::user()->hasRole('agent'))
                        <div class="form-group{{ $errors->has('company') ? ' has-error' : '' }}">
                            <label for="company" class="col-sm-2 control-label">Firma</label>

                            <div class="col-sm-10">
                                <input id="company" type="text" class="form-control" name="company"
                                       value="{{ old('company', Auth::user()->account->company) }}">
                                @if ($errors->has('company'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('company') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        @endif

                        @hasrole('seller')

                        <div class="form-group{{ $errors->has('tax_id') ? ' has-error' : '' }}">
                            <label for="tax_id" class="col-sm-2 control-label">Umsatzsteuer ID</label>

                            <div class="col-sm-10">
                                <input id="tax_id" type="text" class="form-control" name="tax_id"
                                       value="{{ Auth::user()->account->tax_id }}">
                                @if ($errors->has('tax_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('tax_id') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        @endhasrole

                        <div class="form-group{{ $errors->has('description') ? ' has-error' : '' }}">
                            <label for="description" class="col-sm-2 control-label">Beschreibung</label>

                            <div class="col-sm-10">
                                <textarea id="description" type="text" class="form-control" name="description"
                                          style="resize: vertical">{!! old('description', Auth::user()->account->description) !!}
                                </textarea>
                            </div>
                        </div>

                        <div class="hr-line-dashed"></div>

                        @if( Auth::user()->hasRole('agent') || Auth::user()->hasRole('seller'))
                        <div class="form-group{{ $errors->has('street') ? ' has-error' : '' }}">
                            <label for="street" class="col-sm-2 control-label">Straße</label>

                            <div class="col-sm-10">
                                <input id="street" type="text" class="form-control" name="street"
                                       value="{{ old('street', Auth::user()->account->street) }}">
                                @if ($errors->has('street'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('street') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>



                            <div class="form-group{{ $errors->has('housenumber') ? ' has-error' : '' }}">
                                <label for="housenumber" class="col-sm-2 control-label">Hausnummer</label>

                                <div class="col-sm-10">
                                    <input id="housenumber" type="text" class="form-control" name="housenumber"
                                           value="{{ old('housenumber', Auth::user()->account->housenumber) }}">
                                    @if ($errors->has('housenumber'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('housenumber') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>

                            <div class="form-group{{ $errors->has('zip') ? ' has-error' : '' }}">
                                <label for="zip" class="col-sm-2 control-label">PLZ</label>

                                <div class="col-sm-10">
                                    <input id="zip" type="text" class="form-control" name="zip"
                                           value="{{ old('zip', Auth::user()->account->zip) }}">
                                    @if ($errors->has('zip'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('zip') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>

                            <div class="form-group{{ $errors->has('city') ? ' has-error' : '' }}">
                                <label for="city" class="col-sm-2 control-label">Ort</label>

                                <div class="col-sm-10">
                                    <input id="city" type="text" class="form-control" name="city"
                                           value="{{ old('city', Auth::user()->account->city) }}">
                                    @if ($errors->has('city'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('city') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>

                            <div class="hr-line-dashed"></div>
                        @endif
                        @if(Auth::user()->hasRole('seller'))

                            <div class="form-group{{ $errors->has('payment') ? ' has-error' : '' }}">
                                <label for="payment" class="col-sm-2 control-label">Zahlart</label>

                                <div class="col-sm-10">
                                    <input id="payment" type="text" class="form-control" name="payment"
                                           value="{{ trans('translations.' . Auth::user()->account->payment) }}"
                                           disabled>
                                    @if ($errors->has('payment'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('payment') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        @endif

                        <div class="form-group{{ $errors->has('iban') ? ' has-error' : '' }}">
                            <label for="iban" class="col-sm-2 control-label">IBAN</label>

                            <div class="col-sm-10">
                                <input id="iban" type="text" class="form-control" name="iban"
                                       value="{{ old('iban', Auth::user()->account->iban) }}">
                                @if ($errors->has('iban'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('iban') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group{{ $errors->has('iban_owner') ? ' has-error' : '' }}">
                            <label for="iban_owner" class="col-sm-2 control-label">Kontoinhaber</label>

                            <div class="col-sm-10">
                                <input id="iban_owner" type="text" class="form-control" name="iban_owner"
                                       value="{{ old('iban_owner', Auth::user()->account->iban_owner) }}">
                                @if ($errors->has('iban_owner'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('iban_owner') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        @if( Auth::user()->hasRole('seller'))
                            <div class="hr-line-dashed"></div>

                            <div class="form-group">
                                <div class="col-sm-10 col-sm-offset-2">
                                    <img data-lightbox="image-1" class="profile-image"
                                         src="@if(Auth::user()->account->upload_portrait != ''){{ route('user-portrait', Auth::user()->account->upload_portrait) }}@else{{ '/img/logo_company.png' }}@endif">
                                </div>

                                <div class="upload col-sm-10 col-sm-offset-2">
                                    <p>
                                        Wählen Sie eine Bilddatei mit Ihrem Logo bzw. Profilbild (*.jpeg, *.jpg, *.png *.gif) von Ihrem Rechner aus:<br>
                                        *Maximum 200x200 Pixel
                                        <input name="portrait" type="file" size="50" accept="text/*"
                                               class="btn btn-primary">
                                    </p>
                                </div>
                            </div>
                        @endif
                        <div class="form-group">
                            <div class="col-sm-10 col-sm-offset-2">
                                <button type="submit" class="btn btn-primary">
                                    Speichern
                                </button>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        @if( Auth::user()->hasRole('seller'))

            <div class="row">
                <div class="col-md-12">
                    <div class="ibox float-e-margins">
                        <div class="ibox-title">
                            <h5>Einstellungen</h5>
                        </div>
                        <div class="ibox-content">
                            <div class="form-group{{ $errors->has('all_connections') ? ' has-error' : '' }}">
                                <label for="password_old" class="col-sm-2 control-label">Empfehler</label>

                                <div class="col-sm-10">
                                    Wer darf Ihre eingestellten RECO.BON empfehlen?
                                    <select name="all_connections" size="1" id="all_connections" class="form-control">
                                        <option value="1"{{ (Auth::user()->account->all_connections == '1' ? " selected":"") }}>
                                            Alle Empfehler
                                        </option>
                                        <option value="0"{{ (Auth::user()->account->all_connections == '0' ? " selected":"") }}>
                                            Nur von mir eingeladene Empfehler
                                        </option>
                                    </select>
                                </div>
                            </div>

                            <div class="form-group clearfix">
                                <div class="col-sm-10 col-sm-offset-2">
                                    <button type="submit" class="btn btn-primary">
                                        Speichern
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif

    </form>
@endsection

@section('after-scripts')
    <script type="text/javascript" language="javascript">
        $("textarea").height($("textarea")[0].scrollHeight);
    </script>
@endsection