@extends('layouts.home')

@section('title', 'Profil')

@section('content')
    <div class="ibox float-e-margins">
        <div class="ibox-content">
            <div id="profile">
                <div class="row">
                    <div class="profile-image-wrapper">
                        <img data-lightbox="image-1" class="profile-image profile-image-in-account_view @if($role != App\User::SELLER) avatar @endif"
                             src="{{ $account->getPortraitUrl($role) }}">
                    </div>

                    <div>
                        <div class="contact">
                            <span class="address"><i
                                        class="fa fa-map-marker"></i>&nbsp;
                                @if($role == App\User::SELLER)
                                    {{ $account->getDisplayAddress(true) }}
                                @else
                                    {{ $account->getDisplayCity(true) }}
                                @endif
                            </span>
                            @if($role == App\User::SELLER)
                                <span class="phone"><i class="fa fa-phone"></i>&nbsp;{{ $user->phone }} </span>
                            @endif
                            @if($role != App\User::CONSUMER)
                                <span class="email"><i class="fa fa-envelope"></i>&nbsp;{{ $user->email }} </span>
                            @endif
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection

