var _processAPIError = function (data) {
    var text = [];
    if ('object' === typeof data.error) {
        for (i in data.error) {
            text.push(data.error[i]);
        }
    } else if ('undefined' !== typeof data.error) {
        text.push(data.error);
    } else {
        text.push(data);
    }
    return text;
};

$(document).ready(function () {
    // vars

    var needsNetto = false;
    var currentCode = null;
    var newCode = null;
    var requestInProcess = false;
    var scanner = null;
    var scannerCameras = null;
    var scannerCurrentCameraId = 0;

    // functions

    var hasGetUserMedia = function () { // check media support (for camera access)
        return !!(navigator.mediaDevices && navigator.mediaDevices.getUserMedia);
    };

    var scanBtnsInit = function () { // init scan buttons
        if ( hasGetUserMedia() ) {
            $('.rdScanBtn').removeClass('d-none');
        }
    };

    var scannerParse = function (code) { // parse scanned QR-code
        var m = code.match(/redeem\?code=(.*)$/);
        if (m && m.length && m[1] && m[1].length === 9) {
            $('#redeemingCode').val(m[1].slice(0, 3) + ' ' + m[1].slice(3, 6) + ' ' + m[1].slice(6, 9));
            scanCancel();
        }
    };

    var scannerInit = function () { // init scanner
        if (null === scanner) {
            scanner = new Instascan.Scanner({
                video: document.getElementById('scanner'),
                mirror: false,
            });

            scanner.addListener('scan', function (content) {
                scannerParse(content);
            });
        }
    };

    var scannerSaveCameras = function (cameras) { // save cameras list
        if (null === scannerCameras) {
            scannerCameras = cameras;

            if (cameras.length > 1) {
                $('#scannerChangeCameraBtn').removeClass('d-none');
            }
        }
    };

    var scannerStartCamera = function () { // start scanning
        if (scannerCameras.length) {
            $('#scannerHolder').removeClass('d-none');
            scanner.start(scannerCameras[scannerCurrentCameraId]);
        }
    };

    var scannerCnangeCamera = function () { // change camera (usually just front/back)
        scannerCurrentCameraId++;
        if (scannerCurrentCameraId === scannerCameras.length) {
            scannerCurrentCameraId = 0;
        }
        scannerStartCamera();
    };

    var scanStart = function () { // start scan functionality
        scannerInit();

        Instascan.Camera.getCameras().then(function (cameras) {
            scannerSaveCameras(cameras);
            scannerStartCamera();
        }).catch(function (e) {
            swal.fire('Es gibt ein Fehler', 'Bitte stellst Du sicher, dass Deine Kamera nicht von einer anderen Anwendung verwendet wird, und dass Du hast Kamerazugriff erlaubt', 'error');
            console.error(e);
        });
    };

    var scanCancel = function () { // cancel scanning
        $('#scannerHolder').addClass('d-none');
        scanner.stop();
    };

    var showStep = function (step) { // show step by id
        $('.rdStep').removeClass('active');
        $('.rdStep[data-step="' + step + '"]').addClass('active');
        if ( $('#rdNav').length ) {
            $('#rdNav .rdMenuItem').removeClass('active');
            $('#rdNav .rdMenuItem[data-step="' + step + '"]').addClass('active');
        }
    };

    var setError = function (field, message) { // set error on input field
        var el = $('.invalid-feedback[data-input="' + field + '"]');
        el.text(message);
        el.closest('.form-group').addClass('validated');
    };

    var unsetError = function (field) { // hide error from input field
        var el = $('.invalid-feedback[data-input="' + field + '"]');
        el.text('');
        el.closest('.form-group').removeClass('validated');
    };

    var getCouponCode = function () { // get coupon code w/o spaces
        return $('#rdCode').val().split(' ').join('');
    };

    var getCouponNetto = function () { // get netto as float number
        return parseFloat($('#rdNetto').val().trim().split('.').join('').replace(',', '.')) || 0;
    };

    var getPaymentType = function () { // get payment type
        return $('input[name="payment_type"]:checked').val();
    };

    var couponCodeValid = function () { // coupon code client validation
        var code = getCouponCode();

        if (9 !== code.length) {
            setError('code', 'RECO.CODE sollte 9 Symbole enthalten');
            return false;
        }

        return true;
    };

    var couponNettoValid = function () { // netto client validation
        if (!needsNetto) {
            return true;
        }

        var netto = getCouponNetto();

        if (netto <= 0) {
            setError('netto', 'Dieser RECO.BON benötigt eine Warenwert');
            return false;
        }

        return true;
    };

    var prepareDetails = function () { // prepare coupon details
        $('#rdCouponCode').html(couponData.code);
        $('#rdCouponTitle').html(couponData.title);
        $('#rdCouponAgentName').html(couponData.agent.name);
        $('#rdCouponAgentUserpic').attr('src', couponData.agent.userpic);
        $('#rdCouponConsumerName').html(couponData.consumer.name);
        $('#rdCouponConsumerUserpic').attr('src', couponData.consumer.userpic);
        $('#rdCouponCashback').html(couponData.cashback);
        $('#rdCouponProvision').html(couponData.provision);
        $('#rdCouponValidityDate').html(couponData.validity_date);
        $('#rdCouponActivatedDate').html(couponData.activated_date);

        if (couponData.agent.id === couponData.consumer.id) {
            $('#rdCouponAgentHolder').hide();
        } else {
            $('#rdCouponAgentHolder').show();
        }

        if (couponData.needs_netto) {
            needsNetto = true;
            $('#rdNettoHolder').show();
        } else {
            needsNetto = false;
            $('#rdNettoHolder').hide();
            $('#rdNextToPayment').removeClass('disabled');
        }
    };

    var prepareSummary = function () { // prepare summary step
        $('#rdSummaryCouponCode').html(getCouponCode());
        $('#rdSummaryCouponNetto').html($('#rdNetto').val() + ' &euro;');
        $('#rdSummaryCouponPayment').html($('input[name="payment_type"]:checked').data('title'));

        if (needsNetto) {
            $('#rdSummaryCouponNettoHolder').show();
        } else {
            $('#rdSummaryCouponNettoHolder').hide();
        }
    };

    var couponGetByCode = function () { // get coupon data by its code
        $('#overlay').show();
        requestInProcess = true;

        $.ajax({
            url: '/api/coupon/getbycode/',
            method: 'POST',
            dataType: 'json',
            data: {
                code: getCouponCode(),
            },
            success: function (response) {
                $('#overlay').hide();
                currentCode = getCouponCode();
                couponData = response.success;
                prepareDetails();
                showStep('details');
                requestInProcess = false;
            },
            error: function (response) {
                $('#overlay').hide();
                setError('code', _processAPIError(response.responseJSON).join('<br>'));
                requestInProcess = false;
            },
        });
    };

    var couponRedeem = function () { // redeem coupon
        $('#overlay').show();

        $.ajax({
            url: '/api/coupon/redeem/',
            method: 'POST',
            dataType: 'json',
            data: {
                code: getCouponCode(),
                netto: getCouponNetto(),
                payment: getPaymentType(),
            },
            success: function (response) {
                $('#overlay').hide();
                swal.fire({
                    title: 'Der RECO.BON wurde angenommen',
                    type: 'success',
                    heightAuto: false
                }).then((result) => {
                    if ( $('#rdRedirect').length ) {
                        window.location.href = $('#rdRedirect').val();
                    } else {
                        $('#rdCode').val('').change();
                        $('#rdNetto').val('');
                        showStep('code');
                    }
                });
            },
            error: function (response) {
                $('#overlay').hide();
                swal.fire({
                    title: _processAPIError(response.responseJSON).join('<br>'),
                    type: 'error',
                    heightAuto: false
                });
            },
        });
    };

    var couponCodeApply = function () { // apply coupon code
        if (null !== currentCode && currentCode === newCode) {
            prepareDetails();
            showStep('details');
        } else if ( !requestInProcess && couponCodeValid() ) {
            couponGetByCode();
        }
    };

    var couponNettoApply = function () { // apply netto
        if ( couponNettoValid() ) {
            showStep('payment');
        }
    };

    // DOM events

    $('#scannerCloseBtn').on('click', function () {
        scanCancel();
    });

    $('#scannerChangeCameraBtn').on('click', function () {
        scannerCnangeCamera();
    });

    $('.rdScanBtn').on('click', function () {
        scanStart();
    });

    $('#rdCode').on('change keyup blur', function () {
        var code = getCouponCode();
        newCode = code;
        if ( code.length === 9 ) {
            $('#rdNextToDetails').removeClass('disabled');
            unsetError('code');
        } else {
            $('#rdNextToDetails').addClass('disabled');
        }
    });

    $('#rdNetto').on('change keyup blur', function () {
        var netto = getCouponNetto();
        if ( netto > 0 ) {
            $('#rdNextToPayment').removeClass('disabled');
            unsetError('netto');
        } else {
            $('#rdNextToPayment').addClass('disabled');
        }
    });

    $('#rdCode').on('keydown', function (e) {
        if ( 13 === e.keyCode || 13 === e.which ) {
            couponCodeApply();
        }
    });

    $('#rdNetto').on('keydown', function (e) {
        if ( 13 === e.keyCode || 13 === e.which ) {
            couponNettoApply();
        }
    });

    $('#rdCode').on('paste', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var text = (e.originalEvent || e).clipboardData.getData('text/plain');
        text = text.replace(/[^A-Za-z0-9]/g, '');

        $(this).val(text);
        $(this).unmask().mask("AAA AAA AAA", {placeholder: "_ _ _ _ _ _ _ _ _"});
        var that = this;
        setTimeout(function() {
            that.selectionStart = that.selectionEnd = 10000;
        }, 0);
    });

    $('#rdForm').on('submit', function (e) {
        e.preventDefault();
        e.stopPropagation();
    });

    $('#rdNextToDetails').on('click', function () {
        couponCodeApply();
    });

    $('#rdNextToPayment').on('click', function () {
        couponNettoApply();
    });

    $('#rdNextToSummary').on('click', function () {
        prepareSummary();
        showStep('summary');
    });

    $('[data-show]').on('click', function () {
        showStep($(this).data('show'));
    });

    $('#rdRedeem').on('click', function () {
        couponRedeem();
    });

    // init

    scanBtnsInit();

    new Cleave('#rdNetto', {
        numeral: true,
        numeralDecimalMark: ',',
        delimiter: '.'
    });

    $('#rdCode').mask("AAA AAA AAA", {placeholder: "_ _ _ _ _ _ _ _ _"});

    $('#overlay').hide();
});