var _generatePassword = function (len, digitsCount, symbolsCount, upperCount) {
    var self = this;

    var upp = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    var dig = "0123456789";
    var spc = "`~!@#$%^&*()_+-=[]{}\|;:'\",./<>?";
    var str = upp.toLowerCase();

    var pass = "";

    for (var i = 0; i < upperCount; i++) {
        pass += upp.charAt(Math.random() * upp.length);
    }

    for (var i = 0; i < digitsCount; i++) {
        pass += dig.charAt(Math.random() * dig.length);
    }

    for (var i = 0; i < symbolsCount; i++) {
        pass += spc.charAt(Math.random() * spc.length);
    }

    var plen = pass.length;
    for (var i = plen; i < len; i++) {
        pass += str.charAt(Math.random() * str.length);
    }

    var p = pass.split("");
    var l = p.length;

    for (var i = l - 1; i > 0; i--) {
        var j = Math.floor(Math.random() * (i + 1));
        var tmp = p[i];
        p[i] = p[j];
        p[j] = tmp;
    }
    pass = p.join("");

    return pass.substr(0, len);
};

toastr.options = {
    "closeButton": true,
    "debug": false,
    "newestOnTop": false,
    "progressBar": true,
    "positionClass": "toast-bottom-right",
    "preventDuplicates": false,
    "onclick": null,
    "showDuration": "300",
    "hideDuration": "1000",
    "timeOut": "5000",
    "extendedTimeOut": "1000",
    "showEasing": "swing",
    "hideEasing": "linear",
    "showMethod": "fadeIn",
    "hideMethod": "fadeOut"
};

$(document).ready(function () {
    var lastClickedElement = null;

    // profile tabs

    var selectProfileTabActiveClass = 'kt-widget__item--active';

    var selectProfileTab = function (id) {
        var el = $('[data-profile-toggler="' + id + '"]').eq(0);
        var p = el.closest('[data-profile-togglers]');

        p.find('[data-profile-toggler]').removeClass(selectProfileTabActiveClass);
        el.addClass(selectProfileTabActiveClass);

        var tab = $('[data-profile-tab="' + id + '"]').eq(0);
        var pt = tab.closest('[data-profile-tabs]');

        pt.find('[data-profile-tab]').addClass('d-none');
        tab.removeClass('d-none');
    };

    $('[data-profile-toggler]').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        selectProfileTab($(this).attr('data-profile-toggler'));
    });

    var hash = window.location.hash.split('?')[0];

    if (hash.substr(1).length) {
        selectProfileTab(hash.substr(1));
    }

    // forms

    $('form').on('submit', function (e) {
        if ( !$(this).find('.pictureInput').length ) {
            e.preventDefault();
            e.stopPropagation();

            $('.userProfileSaveBtn[data-form="' + $(this).attr('id') + '"]').click();
        }
    });

    $('form input').on('keyup', function (e) {
        if (e.keyCode === 13) {
            e.preventDefault();
            e.stopPropagation();

            $(this).closest('form').submit();
        }
    });

    function userProfileSuccess() {
        toastr.success('Daten wurden erfolgreich geändert.');
    }

    function userProfileErrorsHide(form) {
        form.find('.is-invalid').removeClass('is-invalid');
        form.find('.invalid-feedback').hide();
    }

    function userProfileError(form, data) {
        var bag = data.error || data;
        for (key in bag) {
            var input = form.find('[name="' + key + '"]');
            if (input.length) {
                input.addClass('is-invalid');
            }
            var msg = form.find('[data-input="' + key + '"]');
            if (msg.length) {
                msg.show().text(bag[key][0]);
            }
        }
    }

    function userProfileClear(form) {
        form.find('input').val('');
    }

    function userProfileSend(form) {
        var form = $('#' + form);
        var inputs = form.find('.userProfileInput');
        var reload = form.data('reload') || false;
        var redirect = form.data('redirect') || false;
        var clear = form.data('clear') || false;
        var data = {};
        inputs.each(function () {
            data[$(this).attr('name')] =  $(this).val();
        });
        $('#overlay').show();
        userProfileErrorsHide(form);
        fetch(form.attr('action'), {
            body: JSON.stringify(data),
            headers: {
                'Accept': 'application/json',
            },
            method: 'POST',
        }).then(response => {
            if (response.ok) {
                $('#overlay').hide();
                if (clear) {
                    userProfileClear(form);
                }
                if (reload) {
                    if (redirect) {
                        location.href = redirect;
                    }
                    location.reload();
                } else {
                    userProfileSuccess();
                }
            }
            if (401 === response.status || 422 === response.status) {
                return response.json().then(err => {
                    throw err;
                });
            }
        }).catch(error => {
            $('#overlay').hide();
            userProfileError(form, error);
        });
    }

    $('.userProfileSaveBtn').on('click', function () {
        userProfileSend($(this).attr('data-form'));
    });

    // images

    $('.pictureSelectBtn').on('click', function () {
        var p = $(this).closest('.pictureUploadHolder');
        var form = $('#' + p.attr('data-form'));
        form.find('.pictureInput').click();
    });

    $('.pictureInput').on('change', function() {
        var input = this;
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                var form = $(input).closest('form');
                var h = $('.pictureUploadHolder[data-form="' + form.attr('id') + '"]');
                h.find('.pictureHolder').css('background-image', 'url(' + e.target.result + ')');
                h.find('.pictureCancelBtn').css('display', 'flex');
                h.find('.pictureUploadBtn').removeClass('disabled');
            };
            reader.readAsDataURL(input.files[0]);
        }
    });

    $('.pictureCancelBtn').on('click', function () {
        var p = $(this).closest('.pictureUploadHolder');
        var form = $('#' + p.attr('data-form'));
        form.find('.pictureInput').val(null);
        p.find('.pictureCancelBtn').css('display', 'none');
        p.find('.pictureHolder').css('background-image',  p.find('.pictureHolder').attr('data-bg'));
        p.find('.pictureUploadBtn').addClass('disabled');
    });

    $('.pictureUploadBtn').on('click', function () {
        if ( !$(this).hasClass('disabled') ) {
            $('#overlay').show();
            var p = $(this).closest('.pictureUploadHolder');
            var form = $('#' + p.attr('data-form'));
            form.submit();
        }
    });

    // passwords

    var showHint = function (el) {
        el.closest('.inputHolder').find('.passwordHint').show();
    };

    var hideHint = function (el) {
        el.closest('.inputHolder').find('.passwordHint').hide();
    };

    var visualizeStrength = function (el) {
        var marks = [
            'Sehr schwach',
            'Schwach',
            'Mittel',
            'Stark',
            'Sehr stark',
        ];

        var hint = el.closest('.inputHolder').find('.passwordHint');
        var pw = el.val().trim();
        var min = el.data('min');
        var meter = hint.find('.passwordStrengthMeter');
        var mark = hint.find('.passwordHintValue');
        var notice = hint.find('.passwordHintNotice');

        if ( !pw.length ) {
            meter.attr('data-strength', 0);
            mark.text('');
            notice.text('Das Passwort ist leer');
        } else if ( pw.length < min ) {
            meter.attr('data-strength', 0);
            mark.text(marks[0]);
            notice.text('Das Passwort ist zu kurz');
        } else {
            var z = zxcvbn(pw);
            var score = z.score;
            meter.attr('data-strength', score);
            mark.text(marks[score]);
            if ( z.feedback && z.feedback.warning ) {
                notice.text(z.feedback.warning);
            } else {
                notice.text('Das Passwort ist sehr gut');
            }
        }
    };

    var generatePassword = function (el) {
        var pw = _generatePassword(24, 24, 3, 3, 3);
        var holder = el.closest('.inputHolder');
        var form = el.closest('form');
        var pwInput = holder.find('.passwordInput');
        var pwConfirmInput = form.find('.passwordConfirmInput');
        var pwToggler = holder.find('.passwordVisibilityToggler');

        pwInput.val(pw);

        if (pwConfirmInput.length) {
            pwConfirmInput.val(pw);
        }

        if ( !pwToggler.hasClass('active') ) {
            pwToggler.click();
        }

        pwInput.select();
        document.execCommand("copy");
        window.getSelection().removeAllRanges();

        toastr.success('Das Passwort wurde erfolgreich generiert und in die Zwischenablage kopiert');

        visualizeStrength(pwInput);
    };

    $('.passwordVisibilityToggler').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        $(this).toggleClass('active');

        var input = $(this).closest('.input-group').find('input');
        if ( 'password' === input.attr('type') ) {
            input.attr('type', 'text');
        } else {
            input.attr('type', 'password');
        }

        input.focus();
    });

    $('.passwordInput').on('focus', function () {
        visualizeStrength($(this));
        showHint($(this));
    });

    $('.passwordInput').on('blur', function () {
        var hintClicked = lastClickedElement.hasClass('passwordGenerateBtn') || lastClickedElement.closest('.passwordHint').length;
        var togglerClicked = lastClickedElement.hasClass('passwordVisibilityToggler') || lastClickedElement.closest('.passwordVisibilityToggler').length;

        if ( null === lastClickedElement || !(hintClicked || togglerClicked) ) {
            hideHint($(this));
        }
    });

    $('.passwordInput').on('keyup', function () {
        visualizeStrength($(this));
    });

    $('.passwordGenerateBtn').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        generatePassword($(this));
    });

    $(document).on('mousedown', function (e) {
        lastClickedElement = $(e.target);
        if ( $('.passwordInput').length ) {
            $('.passwordInput').blur();
        }
    });

    function TFADisconnect() {
        $('#overlay').show();
        location.href = '/tfa/google/disconnect';
    }

    function TFADisconnectConfirm() {
        swal.fire({
            title: 'Bist Du sicher?',
            text: '',
            type: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Ja',
            cancelButtonText: 'Nein',
            focusConfirm: false,
            focusCancel: true,
        }).then((result) => {
            if (result.value) {
                TFADisconnect();
            }
        });
    }

    function getTFAConnectHTML(data) {
        var html = '';

        html += '<p>Scann den QR-Code mit <a href="https://support.google.com/accounts/answer/1066447?hl=en" target="_blank">Google Authenticator</a>. Es wird ein 6-stelliger Code angezeigt, den Du unten eingeben musst.</p>';
        html += '<p class="text-center"><img height="200" width="200" src="' + data.qrcode + '" /></p>';
        html += '<p>Oder wähl die manuelle Eingabe in der App und gib Deinen Benutzernamen (<strong>' + data.name + '</strong>) und den Code ein: <strong>' + data.secret + '</strong></p>';

        return html;
    }

    function TFAConnect() {
        $('#overlay').show();

        fetch('/api/tfa/connect/', {
            headers: {
                'Accept': 'application/json',
            },
            method: 'POST',
        }).then(response => {
            $('#overlay').hide();
            if (response.ok) {
                return response.json();
            }
        }).then(result => {
            swal.fire({
                title: 'Verbinde Deine App',
                html: getTFAConnectHTML(result.success),
                input: 'text',
                confirmButtonText: 'Verifizieren',
                showLoaderOnConfirm: true,
                preConfirm: (code) => {
                    if ( code.length !== 6 || !code.match(/^\d+$/) ) {
                        swal.showValidationMessage('Der Code muss aus sechs Ziffern bestehen');
                    } else {
                        return fetch('/api/tfa/finish', {
                            body: JSON.stringify({
                                code: code,
                            }),
                            headers: {
                                'Accept' : 'application/json',
                            },
                            method: 'POST',
                        }).then(response => {
                            if (response.ok) {
                                $('#overlay').show();
                                location.href = '/tfa/google/connect';
                            }
                            if (401 === response.status || 422 === response.status) {
                                return response.json().then(err => {throw err;});
                            }
                        }).catch(error => {
                            swal.showValidationMessage(_processAPIError(error).join('<br>'));
                        });
                    }
                },
                allowOutsideClick: () => !swal.isLoading()
            });
        });
    }

    $('#userTFADisconnectBtn').on('click', TFADisconnectConfirm);

    $('#userTFAConnectBtn').on('click', TFAConnect);
});