$(document).ready(function () {
    // vars

    var steps = [
        {
            'id': 'dcStepGeneral',
            'validate': function () {
                return isGeneralStepValid();
            },
        },
        {
            'id': 'dcStepCategory',
            'validate': function () {
                return isCategoryStepValid();
            },
        },
        {
            'id': 'dcStepCashback',
            'validate': function () {
                return isCashbackStepValid();
            },
        },
        {
            'id': 'dcStepPremium',
            'validate': function () {
                return isPremiumStepValid();
            },
        },
        {
            'id': 'dcStepPlace',
            'validate': function () {
                return isPlaceStepValid();
            },
        },
        {
            'id': 'dcStepGallery',
            'validate': function () {
                return isGalleryStepValid();
            },
        },
    ];

    var dcValiditySlider = document.getElementById('dcValidity');
    var dcGalleryLoading = 0;
    var dcGalleryMax = 10;

    // functions

    var isGeneralStepValid = function (suppressErrors) { // validate general step
        var suppressErrors = suppressErrors || false;

        var valid = true;

        var title = $('#dcTitleInput').val().trim();

        if ( !title.length ) {
            valid = false;
            dcProcessValidationError('title', 'Titel muss ausgefüllt sein.', suppressErrors);
        } else if ( title.length > 100 ) {
            valid = false;
            dcProcessValidationError('title', 'Titel darf maximal 100 Zeichen haben.', suppressErrors);
        }

        var description = $('#dcDescriptionInput').val().trim();

        if ( !description.length ) {
            valid = false;
            dcProcessValidationError('description', 'Beschreibung muss ausgefüllt sein.', suppressErrors);
        } else if ( description.match(/\S+/g).length < 10 ) {
            valid = false;
            dcProcessValidationError('description', 'Beschreibung muss mindestens 10 Wörter haben.', suppressErrors);
        }

        var quota = parseInt($('#dcQuota').val()) || 0;

        if (!quota) {
            valid = false;
            dcProcessValidationError('quota', 'Kontingent muss ausgefüllt sein.', suppressErrors);
        }

        var terms = $('#dcTermsInput').val().trim();

        if ( !terms.length ) {
            valid = false;
            dcProcessValidationError('terms', 'Bedingungen muss ausgefüllt sein.', suppressErrors);
        } else if ( terms.match(/\S+/g).length < 2 ) {
            valid = false;
            dcProcessValidationError('terms', 'Bedingungen muss mindestens 10 Wörter haben.', suppressErrors);
        }

        if ( valid ) {
            $('#dcStepGeneral .dcNextStepBtn').removeClass('disabled');
        } else {
            $('#dcStepGeneral .dcNextStepBtn').addClass('disabled');
        }

        return valid;
    };

    var isCategoryStepValid = function (suppressErrors) { // validate category step
        var suppressErrors = suppressErrors || false;

        var valid = true;

        if ( 1 !== $('.dcCatItem.selected').length ) {
            valid = false;
            dcProcessValidationError('category_id', 'Kategorie muss ausgefüllt sein.', suppressErrors);
        }

        return valid;
    };

    var isCashbackStepValid = function (suppressErrors) { // validate cashback step
        var suppressErrors = suppressErrors || false;

        var valid = true;

        var type = $('input[name="dcCashbackType"]:checked').val();

        if ('percent' === type) {
            var value = parseFloat($('#dcCashbackPercentInput').val().trim()) || 0;
            if (!value) {
                valid = false;
                dcProcessValidationError('discount_consumer', 'Cashback muss ausgefüllt sein.', suppressErrors);
            } else if (value < 1 || value > 100) {
                valid = false;
                dcProcessValidationError('discount_consumer', 'Cashback muss zwischen 1 & 100 liegen.', suppressErrors);
            }
        } else {
            var value = parseFloat($('#dcCashbackAmountInput').val().trim().replace('.', '').replace(',', '.')) || 0;
            if (!value) {
                valid = false;
                dcProcessValidationError('discount_consumer', 'Cashback muss ausgefüllt sein.', suppressErrors);
            } else if (value < 1) {
                valid = false;
                dcProcessValidationError('discount_consumer', 'Cashback muss mindestens 1 sein.', suppressErrors);
            }
        }

        if ( valid ) {
            $('#dcStepCashback .dcNextStepBtn').removeClass('disabled');
        } else {
            $('#dcStepCashback .dcNextStepBtn').addClass('disabled');
        }

        return valid;
    };

    var isPremiumStepValid = function (suppressErrors) { // validate premium step
        var suppressErrors = suppressErrors || false;

        var valid = true;

        var type = $('input[name="dcPremiumType"]:checked').val();

        if ('percent' === type) {
            var value = parseFloat($('#dcPremiumPercentInput').val().trim()) || 0;
            if (!value) {
                valid = false;
                dcProcessValidationError('provision_agent', 'RECO.CASH muss ausgefüllt sein.', suppressErrors);
            } else if (value < 1 || value > 100) {
                valid = false;
                dcProcessValidationError('provision_agent', 'RECO.CASH muss zwischen 1 & 100 liegen.', suppressErrors);
            }
        } else if ('amount' === type) {
            var value = parseFloat($('#dcPremiumAmountInput').val().trim().replace('.', '').replace(',', '.')) || 0;
            if (!value) {
                valid = false;
                dcProcessValidationError('provision_agent', 'RECO.CASH muss ausgefüllt sein.', suppressErrors);
            } else if (value < 1) {
                valid = false;
                dcProcessValidationError('provision_agent', 'RECO.CASH muss mindestens 1 sein.', suppressErrors);
            }
        }

        if ( valid ) {
            $('#dcStepPremium .dcNextStepBtn').removeClass('disabled');
        } else {
            $('#dcStepPremium .dcNextStepBtn').addClass('disabled');
        }

        return valid;
    };

    var isPlaceStepValid = function (suppressErrors) { // validate places step
        var suppressErrors = suppressErrors || false;

        var valid = true;

        if ( !$('.dcPlaceItemCheckbox:checked').length ) {
            valid = false;
            dcProcessValidationError('places', 'Man muss mindestens ein Standort auswählen.', suppressErrors);
        }

        return valid;
    };

    var isGalleryStepValid = function (suppressErrors) { // validate gallery step
        var suppressErrors = suppressErrors || false;

        var valid = true;

        if ( !$('#dcGalleryDropZone .dcGalleryItem.success').length ) {
            valid = false;
            dcProcessValidationError('gallery', 'Galerie muss mindestens ein Bild haben.', suppressErrors);
        }

        return valid;
    };

    var isFormValid = function (suppressErrors) { // validate all data on form
        var suppressErrors = suppressErrors || false;

        var valid = isGeneralStepValid(suppressErrors)
            && isCategoryStepValid(suppressErrors)
            && isCashbackStepValid(suppressErrors)
            && isPremiumStepValid(suppressErrors)
            && isPlaceStepValid(suppressErrors)
            && isGalleryStepValid(suppressErrors);

        if (valid) {
            $('.dcCreate, .dcSaveAndStay, .dcSaveAndExit').removeClass('disabled');
        } else {
            $('.dcCreate, .dcSaveAndStay, .dcSaveAndExit').addClass('disabled');
        }

        return valid;
    };

    var scrollTo = function (el) { // scroll to element
        $('html, body').animate({
            scrollTop: el.offset().top - $('#dashboardHeader').height()
        }, 300);
    };

    var dcShowStep = function (stepId) { // show step by its id
        var currStep, step;

        for (i in steps) { // prevalidate
            step = steps[i];
            currStep = step.id;
            if ( stepId === currStep || !step.validate() ) {
                break;
            }
        }

        var stepEl = $('#' + currStep);
        $('.dcStep').removeClass('active');
        stepEl.addClass('active');
        $('.dcMenuItem').removeClass('active');
        $('.dcMenuItem[data-step="' + currStep + '"]').addClass('active');

        if ( stepEl.find('.is-invalid').length ) {
            scrollTo(stepEl.find('.is-invalid').eq(0));
        } else {
            scrollTo(stepEl.find('.form-group').eq(0));
        }
    };

    var dcPrepareCashback = function () { // prepare cashback for preview
        var type = $('input[name="dcCashbackType"]:checked').val();
        if ('percent' === type) {
            $('#dcDealPreviewCashbackValue .value').html($('#dcCashbackPercentInput').val().trim() || '&nbsp;');
            $('#dcDealPreviewCashbackValue .unit').html('%');
        } else {
            $('#dcDealPreviewCashbackValue .value').html($('#dcCashbackAmountInput').val().trim() || '&nbsp;');
            $('#dcDealPreviewCashbackValue .unit').html('&euro;');
        }
    };

    var dcPreparePremium = function () { // prepare premium for preview
        var type = $('input[name="dcPremiumType"]:checked').val();
        if ('none' === type) {
            $('#dcDealPreviewPremiumValue').hide();
        } else {
            $('#dcDealPreviewPremiumValue').show();
            if ('percent' === type) {
                $('#dcDealPreviewPremiumValue .value').html($('#dcPremiumPercentInput').val().trim() || '&nbsp;');
                $('#dcDealPreviewPremiumValue .unit').html('%');
            } else {
                $('#dcDealPreviewPremiumValue .value').html($('#dcPremiumAmountInput').val().trim() || '&nbsp;');
                $('#dcDealPreviewPremiumValue .unit').html('&euro;');
            }
        }
    };

    var dcPrepareImage = function () { // prepare image for preview
        var img = $('#dcGalleryDropZone .dcGalleryItem.success').length
            ? $('#dcGalleryDropZone .dcGalleryItem.success').eq(0).data('img')
            : '';

        $('#dcDealPreviewImage').attr('src', img);
    };

    var dcPreparePreview = function () { // prepare preview
        $('#dcDealPreviewTitle').html($('#dcTitleInput').val().trim() || '&nbsp;');
        dcPrepareCashback();
        dcPreparePremium();
        dcPrepareImage();
    };

    var dcShowPreview = function () { // show preview
        dcPreparePreview();
        $('body').addClass('modal-open');
        $('#dcDealPreviewHolder').show();
    };

    var dcProcessValidationError = function (key, error, ignore) { // show valdation error
        var ignore = ignore ||false;
        var el = $('[data-name="' + key + '"]');
        if (!ignore && el.length) {
            el.addClass('is-invalid');
            var p = el.closest('.inputHolder');
            p.addClass('validated').removeClass('d-none');
            p.find('.invalid-feedback').text(error);
        }
    };

    var dcMarkMenuItemsWithErrors = function () { // merk menu items with errors
        $('.dcMenuItem').removeClass('hasErrors');
        $('.dcStep').each(function () {
            var id = $(this).attr('id');
            var errCount = $(this).find('.is-invalid').length;
            if (errCount) {
                $('.dcMenuItem[data-step="' + id + '"]').addClass('hasErrors');
            }
        });
    };

    var dcProcessValidationErrors = function (errors) { // process validation errors
        for (key in errors) {
            dcProcessValidationError(key, errors[key]);
        }
        dcMarkMenuItemsWithErrors();
        if ( $('.dcMenuItem.hasErrors').length ) {
            $('.dcMenuItem.hasErrors').eq(0).click();
            scrollTo($('.is-invalid').eq(0).closest('.dcStep'));
        }
    };

    var getCashbackValue = function () { // get cachback valude
        var type = $('input[name="dcCashbackType"]:checked').val();
        if ('percent' === type) {
            return $('#dcCashbackPercentInput').val().trim();
        }
        if ('amount' === type) {
            return $('#dcCashbackAmountInput').val().trim().replace('.', '').replace(',', '.');
        }
        return 0;
    };

    var getPremiumValue = function () { // get premium value
        var type = $('input[name="dcPremiumType"]:checked').val();
        if ('percent' === type) {
            return $('#dcPremiumPercentInput').val().trim();
        }
        if ('amount' === type) {
            return $('#dcPremiumAmountInput').val().trim().replace('.', '').replace(',', '.');
        }
        return 0;
    };

    var getGalleryItems = function () { // get gallery items
        var galleryItems = [];
        $('#dcGalleryDropZone .dcGalleryItem.success').each(function () {
            galleryItems.push($(this).data('id'));
        });
        return galleryItems;
    };

    var collectPlaces = function () { // get checked places
        var places = [];
        $('.dcPlaceItemCheckbox:checked').each(function () {
            places.push($(this).val());
        });
        return places;
    };

    var dcGetFormData = function () { // get all form data
        return {
            deal_id: dealId,
            title: $('#dcTitleInput').val().trim(),
            description: $('#dcDescriptionInput').val().trim(),
            quota: $('#dcQuota').val(),
            validity: parseInt(dcValiditySlider.noUiSlider.get()) || 0,
            terms: $('#dcTermsInput').val().trim(),
            category_id: $('.dcCatItem.selected').data('id'),
            type_discount: $('input[name="dcCashbackType"]:checked').val(),
            discount_consumer: getCashbackValue(),
            type_provision: $('input[name="dcPremiumType"]:checked').val(),
            provision_agent: getPremiumValue(),
            places: collectPlaces(),
            gallery: getGalleryItems(),
        };
    };

    var dcUpdate = function (redirect) { // update deal data
        var redirect = redirect || false;

        if (dcGalleryLoading) {
            swal.fire('Bitte warte, Upload läuft');
            return;
        }

        $('.is-invalid').removeClass('is-invalid');
        $('#overlay').show();

        $.ajax({
            url: '/api/deal/update/',
            method: 'POST',
            dataType: 'json',
            data: dcGetFormData(),
            success: function (response) {
                $('#overlay').hide();
                swal.fire({
                    title: 'Der RECO.BON wurde erfolgreich erstellt',
                    type: 'success',
                    heightAuto: false
                }).then((result) => {
                    if (redirect) {
                        window.location.href = $('#dcRedirect').val();
                    }
                });
            },
            error: function (response) {
                $('#overlay').hide();
                dcProcessValidationErrors(response.responseJSON);
            },
        });
    };

    var dcSelectCategory = function (el) { // select category
        $('.dcCatItem').removeClass('selected');
        el.addClass('selected');
        $('#dcSelectedCategoryHolder').show();
        $('#dcSelectedCategoryPath').text(el.data('chain') + ' / ');
        $('#dcSelectedCategoryName').text(el.data('name'));
        $('#dcStepCategory .is-invalid').removeClass('is-invalid');
        $('[data-name="category_id"]').closest('.inputHolder').addClass('d-none');
        dcMarkMenuItemsWithErrors();
        $('#dcStepCategory .dcNextStepBtn').removeClass('disabled');
    };

    var dcCatSearch = function (s) { // search category
        s = s.toLowerCase();
        s = s.replace(/\s/g, '');
        s = s.replace(/[,-]/g, '');
        s = s.replace(/\u00fc/g, 'ue');
        s = s.replace(/\u00e4/g, 'ae');
        s = s.replace(/\u00f6/g, 'oe');
        s = s.replace(/\u00df/g, 'ss');

        $('.dcCatItem, .dcCatWrapper').removeClass('d-none');
        $('#dcCatNothingFound').hide();

        $('.dcCatItem[data-leaf="1"]').each(function () {
            var searchString = $(this).data('search');
            if ( -1 === searchString.indexOf(s) ) {
                $(this).addClass('d-none');
            }
        });

        $('.dcCatItem[data-leaf="0"]').each(function () {
            var items = $(this).find('.dcCatItem[data-leaf="1"]').not('.d-none');
            if ( !items.length ) {
                $(this).addClass('d-none');
            }
        });

        $('.dcCatWrapper').each(function () {
            var items = $(this).find('.dcCatItem').not('.d-none');
            if ( !items.length ) {
                $(this).addClass('d-none');
            }
        });

        $('.dcCatItem[data-leaf="1"]').unmark({
            done: function() {
                $('.dcCatItem[data-leaf="1"]').mark(s);
            }
        });

        if ( !$('.dcCatWrapper').not('.d-none').length ) {
            $('#dcCatNothingFound').show();
        }
    };

    var dcCatSearchReset = function () { // reset category search
        $('#dcCatSearchInput').val('');
        $('.dcCatItem, .dcCatWrapper').removeClass('d-none');
    };

    var dcViewToggle = function (el) { // toggle view
        var name = el.attr('name');
        var list = $('input[name="' + name + '"]:checked').data('show').split(',');
        var parent = el.closest('.dcViewTogglerHolder');
        parent.find('.dcView').hide();
        var l = list.length;
        for (var i = 0; i < l; i++) {
            var el = $('#' + list[i]);
            parent.find('.is-invalid').removeClass('is-invalid');
            parent.find('.validated').removeClass('validated');
            el.show();
            dcMarkMenuItemsWithErrors();
        }
    };

    var dcGalleryRemove = function (el) { // remove gallery item
        el.closest('.dcGalleryItem').remove();
        if ( !$('#dcGalleryDropZone .dcGalleryItem').length ) {
            $('#dcGalleryDropZoneTitle').show();
            $('.dcCreate, .dcSaveAndStay, .dcSaveAndExit').addClass('disabled');
        }
    };

    var dcGalleryPreview = function (el) { // preview gallery item
        var img = el.closest('.dcGalleryItem').data('img');
        $('body').addClass('modal-open');
        $('#dcGalleryPreviewImage').attr('src', img);
        $('#dcGalleryPreviewHolder').show();
    };

    var dcGalleryPreviewClose = function () { // close gallery item preview
        $('body').removeClass('modal-open');
        $('#dcGalleryPreviewImage').attr('src', '');
        $('#dcGalleryPreviewHolder').hide();
    };

    var dcGalleryDealPreviewClose = function () { // close deal preview
        $('body').removeClass('modal-open');
        $('#dcDealPreviewHolder').hide();
    };

    var dcGalleryAdd = function (data) { // gallery add event
        //
    };

    var dcGalleryAlways = function (data) { // gallery always event
        var file = data.files[0];
        if (file.error) {
            toastr.error(file.name + ': ' + file.error);
        } else {
            dcGalleryLoading++;
            $('#dcStepGallery .is-invalid').removeClass('is-invalid');
            dcMarkMenuItemsWithErrors();
            $('#dcGalleryDropZoneTitle').hide();
            var item = $('#dcGalleryItemTemplate').clone(true).attr('id', '');
            $('#dcGalleryDropZone').append(item);
            $('#dcGalleryDropZone').sortable('refresh');
        }
    };

    var dcGalleryFail = function (data) { // gallery fail event
        var file = data.files[0];
        var response = data.jqXHR.responseJSON;
        var el = $('#dcGalleryDropZone .dcGalleryItem.loading').eq(0);
        el.remove();
        toastr.error(file.name + ': ' + response.image[0]);
        dcGalleryLoading--;
        if ( !$('#dcGalleryDropZone .dcGalleryItem').length ) {
            $('#dcGalleryDropZoneTitle').show();
        }
    };

    var dcGallerySuccess = function (data) { // gallery success event
        var response = data.jqXHR.responseJSON.success;
        var el = $('#dcGalleryDropZone .dcGalleryItem.loading').eq(0);
        el.removeClass('loading').addClass('success');
        el.attr('data-id', response.id);
        el.attr('data-img', response.url);
        el.find('.dcGalleryImage').css('background-image', 'url("' + response.url + '")');
        $('[data-name="gallery"]').closest('.inputHolder').addClass('d-none');
        dcGalleryLoading--;
        $('.dcCreate, .dcSaveAndStay, .dcSaveAndExit').removeClass('disabled');
    };

    var dcGalleryFileCountRestrict = function (e, data) { // restrict count of gallery items
        var existed = $('#dcGalleryDropZone .dcGalleryItem').length;
        if (existed >= dcGalleryMax) {
            e.preventDefault();
            toastr.warning('Nicht mehr 10 Bilder bitte!');
        } else {
            var dropped = data.files.length;
            if (existed + dropped >= dcGalleryMax) {
                data.files.length = dcGalleryMax - existed;
                toastr.warning('Nicht mehr 10 Bilder bitte!');
            }
        }
    };

    var dcPlacesCheckBoxesState = function () { // check place checkboxes state
        $('#dcStepPlace .is-invalid').removeClass('is-invalid');
        $('[data-name="places"]').closest('.inputHolder').addClass('d-none');
        dcMarkMenuItemsWithErrors();

        $('#dcPlaceItemAll').prop('checked', $('.dcPlaceItemCheckbox:checked').length === $('.dcPlaceItemCheckbox').length);

        if ( isPlaceStepValid(true) ) {
            $('#dcStepPlace .dcNextStepBtn').removeClass('disabled');
            $('.dcSaveAndStay, .dcSaveAndExit').removeClass('disabled');
        } else {
            $('#dcStepPlace .dcNextStepBtn').addClass('disabled');
            $('.dcSaveAndStay, .dcSaveAndExit').addClass('disabled');
        }
    };

    var dcPlacesCheckboxesSwitch = function (state) { // switch place checkboxes
        $('.dcPlaceItemCheckbox').prop('checked', state);
        dcPlacesCheckBoxesState();
    };

    var getTextBarMap = function (attrs) { // get textbar mapped data
        var map = {};

        for (var i = 0, l = attrs.length; i < l; i++) {
            var attr = attrs.item(i);
            var name = attr.name;
            if (-1 !== name.indexOf('data-stop-')) {
                map[name.split('data-stop-')[1]] = attr.value;
            }
        }

        return map;
    };

    var getTextBarPhrase = function (map, words) { // get phrase by words count
        var keys = Object.keys(map);

        for (var i = keys.length - 1; i > 0; i--) {
            if ( words >= parseInt(keys[i]) ) {
                return map[keys[i]];
            }
        }

        return map[keys[0]];
    };

    var getTextBarColor = function (start, end, coeff) { // get current color
        var final = "#";

        for (var i = 0; i < 3; i++) {
            var sub1 = start.substring(1 + 2 * i, 3 + 2 * i);
            var sub2 = end.substring(1 + 2 * i, 3 + 2 * i);
            var v1 = parseInt(sub1, 16);
            var v2 = parseInt(sub2, 16);
            var v = Math.floor(v1 + (v2 - v1) * coeff);
            var sub = v.toString(16).toUpperCase();
            var padsub = ('0' + sub).slice(-2);
            final += padsub;
        }

        return final;
    };

    // DOM events

    $('[data-step]').on('click', function () {
        dcShowStep($(this).data('step'));
    });

    $('.dcViewToggler').on('change', function () {
        dcViewToggle($(this));
    });

    $(document).on('focus click change', 'input.is-invalid, textarea.is-invalid', function () {
        $(this).removeClass('is-invalid');

        if ( $(this).closest('.inputHolder').length ) {
            $(this).closest('.inputHolder').removeClass('validated');
        }

        if ( $(this).closest('.dcViewTogglerHolder').length ) {
            $(this).closest('.dcViewTogglerHolder').find('.dcView.validated:not(visible)').removeClass('validated');
            $(this).closest('.dcViewTogglerHolder').find('.is-invalid:not(visible)').removeClass('is-invalid');
        }

        dcMarkMenuItemsWithErrors();
    });

    $('.dcPreview').on('click', dcShowPreview);

    $('.dcCreate, .dcSaveAndExit').on('click', function () {
        if ( isFormValid() ) {
            dcUpdate(true);
        }
    });

    $('.dcSaveAndStay').on('click', function () {
        if ( isFormValid() ) {
            dcUpdate();
        }
    });

    $('.dcCatItem[data-leaf="1"]').on('click', function () {
        if ( !$(this).hasClass('selected') ) {
            dcSelectCategory($(this));
        }
    });

    $('#dcCatSearchInput').on('change keyup', function () {
        dcCatSearch($(this).val().trim());
    });

    $('#dcCatSearchReset').on('click', dcCatSearchReset);

    $('#dcGalleryFileInput').fileupload({
        url: '/api/upload/',
        dataType: 'json',
        formData: {
            deal_id: dealId,
        },
        autoUpload: true,
        acceptFileTypes: /(\.|\/)(gif|jpe?g|png)$/i,
        maxFileSize: 500 * 1024,
        dropZone: $('#dcGalleryDropZone'),
        messages: {
            maxNumberOfFiles: 'Nicht mehr 10 Bilder bitte!',
            acceptFileTypes: 'Datei muss den Bild Dateityp haben',
            maxFileSize: 'Bild darf maximal 500 Kb groß sein',
        },
        change: function (e, data) {
            dcGalleryFileCountRestrict(e, data);
        }
    }).on('fileuploadadd', function (e, data) {
        dcGalleryAdd(data);
    }).on('fileuploadprocessalways', function (e, data) {
        dcGalleryAlways(data);
    }).on('fileuploaddone', function (e, data) {
        dcGallerySuccess(data);
    }).on('fileuploadfail', function (e, data) {
        dcGalleryFail(data);
    }).on('fileuploaddrop', function (e, data) {
        dcGalleryFileCountRestrict(e, data);
    }).prop('disabled', !$.support.fileInput)
        .parent().addClass($.support.fileInput ? undefined : 'disabled');

    $(document).on('dragover', function (e) {
        var dropZones = $('.dropzone'),
            timeout = window.dropZoneTimeout;
        if (timeout) {
            clearTimeout(timeout);
        } else {
            dropZones.addClass('in');
        }
        var hoveredDropZone = $(e.target).closest(dropZones);
        dropZones.not(hoveredDropZone).removeClass('hover');
        hoveredDropZone.addClass('hover');
        window.dropZoneTimeout = setTimeout(function () {
            window.dropZoneTimeout = null;
            dropZones.removeClass('in hover');
        }, 100);
    });

    $(document).on('drop dragover', function (e) {
        e.preventDefault();
    });

    $('#dcGalleryDropZone').on('click', function (e) {
        if ( !$(e.target).closest('.dcGalleryItem').length ) {
            $('#dcGalleryFileInput').click();
        }
    });

    $(document).on('click', '.dcGalleryRemove', function () {
        dcGalleryRemove($(this));
    });

    $(document).on('click', '.dcGalleryPreview', function () {
        dcGalleryPreview($(this));
    });

    $('#dcGalleryPreviewHolder').on('click', function () {
        dcGalleryPreviewClose();
    });

    $('#dcDealPreviewHolder').on('click', function (e) {
        if ( !$(e.target).closest('#dcGalleryPreviewDealInner').length ) {
            dcGalleryDealPreviewClose();
        }
    });

    $('#dcGalleryDealPreviewClose').on('click', function () {
        dcGalleryDealPreviewClose();
    });

    $('#dcPlaceItemAll').on('change', function () {
        dcPlacesCheckboxesSwitch($(this).prop('checked'));
    });

    $('.dcPlaceItemCheckbox').on('change', function () {
        dcPlacesCheckBoxesState();
    });

    $(document).on('change focus keyup', '.interactiveTextBar', function () {
        var textarea = $(this);
        var holder = textarea.closest('.interactiveTextBarHolder');
        var attrs = holder[0].attributes;
        var progress = holder.find('.interactiveTextBarProgress');
        var hint = holder.find('.interactiveTextBarHint');
        var text = textarea.val().trim();
        var words = text.length ? text.match(/\S+/g).length : 0;
        var map = getTextBarMap(attrs);
        var max = Math.max.apply(null, Object.keys(map));
        var percentage = words / max;
        if (percentage > 1) {
            percentage = 1;
        }
        var start = holder.attr('data-color-start');
        var end = holder.attr('data-color-end');
        var phrase = getTextBarPhrase(map, words);
        var color = getTextBarColor(start, end, percentage);

        progress.css('width', Math.round(100 * percentage) + '%');
        progress.css('background-color', color);
        hint.text(phrase);
    });

    $('#dcTitleInput, #dcDescriptionInput, #dcQuota, #dcTermsInput').on('change keyup blur focus', function () {
        isFormValid(true);
    });

    $('#dcCashbackPercentInput, #dcCashbackAmountInput, input[name="dcCashbackType"]').on('change keyup blur focus', function () {
        isFormValid(true);
    });

    $('#dcPremiumPercentInput, #dcPremiumAmountInput, input[name="dcPremiumType"]').on('change keyup blur focus', function () {
        isFormValid(true);
    });

    // init

    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    noUiSlider.create(dcValiditySlider, {
        range: {min: 1, max: 24},
        start: [dcValiditySlider.getAttribute('data-value')],
        step: 1,
        tooltips: true,
        margin: 300,
        format: {
            to: function (value) {
                var m = Math.round(parseFloat(value));
                return m + (1 === m ? ' Monat' : ' Monate');
            },
            from: function (value) {
                return value;
            }
        },
    });

    $('#dcQuota').TouchSpin({
        min: 1,
        max: 10000,
        step: 1,
        buttonup_class: 'btn btn-secondary',
        buttondown_class: 'btn btn-secondary',
        buttonup_txt: '<i class="fa fa-chevron-up"></i>',
        buttondown_txt: '<i class="fa fa-chevron-down"></i>',
    });

    $('#dcCashbackPercentInput').TouchSpin({
        min: 1,
        max: 100,
        step: 0.1,
        decimals: 1,
        buttonup_class: 'btn btn-secondary',
        buttondown_class: 'btn btn-secondary',
        buttonup_txt: '<i class="fa fa-chevron-up"></i>',
        buttondown_txt: '<i class="fa fa-chevron-down"></i>',
    });

    $('#dcPremiumPercentInput').TouchSpin({
        min: 1,
        max: 100,
        step: 0.1,
        decimals: 1,
        buttonup_class: 'btn btn-secondary',
        buttondown_class: 'btn btn-secondary',
        buttonup_txt: '<i class="fa fa-chevron-up"></i>',
        buttondown_txt: '<i class="fa fa-chevron-down"></i>',
    });

    new Cleave('#dcCashbackAmountInput', {
        numeral: true,
        numeralDecimalMark: ',',
        delimiter: '.'
    });

    new Cleave('#dcPremiumAmountInput', {
        numeral: true,
        numeralDecimalMark: ',',
        delimiter: '.'
    });

    $('#dcGalleryDropZone').sortable({
        containment: 'parent',
        handle: '.dcGalleryMove',
        items: '.dcGalleryItem',
        placeholder: 'dcGalleryItemPlaceholder',
    });

    $('.interactiveTextBar').change();

    if (draft) {
        $('.dcButtonBar').css('bottom', '0');
        $('.dcNextStepBtn, .dcCreate').addClass('disabled');
        $('#dcStepPlace .dcNextStepBtn').removeClass('disabled');
    }

    $('#overlay').hide();
});