var _validateEmail = function (email) {
    var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return re.test(String(email).toLowerCase());
};

var _processAPIError = function (data) {
    var text = [];
    var bag = data.error || data;
    if ('object' === typeof bag) {
        for (i in bag) {
            text.push(bag[i]);
        }
    } else if ('undefined' !== typeof bag) {
        text.push(bag);
    } else {
        text.push(data);
    }
    return text;
};

toastr.options = {
    "closeButton": true,
    "debug": false,
    "newestOnTop": false,
    "progressBar": true,
    "positionClass": "toast-bottom-right",
    "preventDuplicates": false,
    "onclick": null,
    "showDuration": "300",
    "hideDuration": "1000",
    "timeOut": "5000",
    "extendedTimeOut": "1000",
    "showEasing": "swing",
    "hideEasing": "linear",
    "showMethod": "fadeIn",
    "hideMethod": "fadeOut"
};

$(document).ready(function () {
    $(document).ajaxSend(function (e, r, s) {
        if (s.url != '/api/upload/') {
            $('#overlay').show();
        }
    }).ajaxComplete(function () {
        $('#overlay').hide();
    });

    var clipboard = new ClipboardJS('.clipboard');

    clipboard.on('success', function(e) {
        e.clearSelection();

        toastr.success('Erfolgreich kopiert.');
    });

    var APIcall = function (url, data, onSuccess, onError) {
        $.ajax(url, {
            type: 'post',
            data: data,
            dataType: 'json',
            success: function (response) {
                onSuccess(response);
            },
            error: function (error) {
                onError(error);
            },
        });
    };

    $('#emailVerificationSend').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        APIcall('/api/email/sendtoken', {}, function () {
            toastr.success('Wir haben eine Bestätigungsmail mit einem Link gesendet.');
        });
    });

    $('#profileNewsletterSave').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var url = $('#profileNewsletter').prop('checked')
            ? '/api/newsletter/subscribe'
            : '/api/newsletter/unsubscribe';

        APIcall(url, {}, function () {
            toastr.success('Erfolgreich gespeichert.');
        });
    });

    $('#profileSelfRegisterSave').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        APIcall('/api/option/open_register', {
            value: $('#profileSelfRegister').prop('checked') ? 1 : 0
        }, function () {
            toastr.success('Erfolgreich gespeichert.');
        });
    });

    var searchItems = function (el) {
        var s = el.val().trim();
        var scope = $(el.data('search-scope'));
        var holder = $(el.data('search-holder'));
        var nothing = $(el.data('search-nothing'));

        s = s.replace(/\s/g, '');

        nothing.hide();
        holder.show();
        scope.show();

        scope.each(function () {
            var searchString = $(this).data('search');
            if ( -1 === searchString.indexOf(s) ) {
                $(this).hide();
            }
        });

        scope.unmark({
            done: function() {
                scope.mark(s);
            }
        });

        if ( !scope.filter(':visible').length ) {
            nothing.show();
            holder.hide();
        }
    };

    $('input[data-search-scope]').on('change keyup', function () {
        searchItems($(this));
    });

    $('[data-search-reset]').on('click', function () {
        $($(this).data('search-reset')).val('').change();
    });

    $(document).on('click', '.showItemInfo', function () {
        var modal = $('#' + $(this).data('mid'));
        modal.modal('show');
    });

    var setCuponPaid = function (couponId) {
        $('#overlay').show();
        fetch('/api/coupon/' + couponId + '/paid/', {
            headers: {
                'Accept': 'application/json',
            },
            method: 'POST',
        }).then(response => {
            if (response.ok) {
                $('#overlay').hide();
                swal.fire('Der RECO.BON wurde als bezahlt bestätigt.', '', 'success')
                    .then(function () {
                        location.reload()
                    });
            }
            if (401 === response.status || 422 === response.status) {
                return response.json().then(err => {throw err;});
            }
        }).catch(error => {
            $('#overlay').hide();
            var e = _processAPIError(error).join('<br>');
            swal.fire(e, '', 'error');
        });
    };

    $(document).on('click', '.sellerSetCouponPaid', function (e) {
        e.preventDefault();

        var couponId = $(this).data('coupon-id');

        swal.fire({
            title: 'Bist du sicher?',
            heightAuto: false,
            text: 'Du kannst das nicht rückgängig machen!',
            type: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Ja',
            cancelButtonText: 'Nein',
        }).then((result) => {
            if (result.value) {
                setCuponPaid(couponId);
            }
        });
    });

    async function shareLinkViaEmail(link, type) {
        swal.fire({
            title: 'E-Mail Adresse eingeben',
            heightAuto: false,
            input: 'text',
            confirmButtonText: ('invite' === type) ? 'Jetzt einladen' : 'Jetzt empfehlen',
            showLoaderOnConfirm: true,
            preConfirm: (email) => {
                if (!email.length) {
                    swal.showValidationMessage('E-Mail Adresse muss ausgefüllt sein.');
                } else if (!_validateEmail(email)) {
                    swal.showValidationMessage('E-Mail Adresse muss eine gültige E-Mail-Adresse sein.');
                } else {
                    return fetch('/api/share_' + type + 'link/email', {
                        body: JSON.stringify({
                            link: link,
                            email: email,
                        }),
                        headers: {
                            'Accept' : 'application/json',
                        },
                        method: 'POST',
                    }).then(response => {
                        if (response.ok) {
                            return response.json();
                        }
                        if (401 === response.status || 422 === response.status) {
                            return response.json().then(err => {throw err;});
                        }
                    }).catch(error => {
                        swal.showValidationMessage(_processAPIError(error).join('<br>'));
                    });
                }
            },
            allowOutsideClick: () => !swal.isLoading()
        }).then(result => {
            if (result.value) {
                swal.fire({
                    type: 'success',
                    title: 'Vielen Dank für Deine ' + ('invite' === type ? 'Einladung' : 'Empfehlung') + '!',
                    heightAuto: false,
                });
            }
        });
    }

    $('[data-share="email"]').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var link = $(this).data('link');
        var type = $(this).data('type') || 'ref';

        shareLinkViaEmail(link, type);
    });

    $('#activeSessionsRemoveBtn').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        swal.fire({
            title: 'Bist du sicher?',
            heightAuto: false,
            text: 'Du kannst das nicht rückgängig machen!',
            type: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Ja',
            cancelButtonText: 'Nein',
        }).then((result) => {
            if (result.value) {
                location.href = '/user/flush_sessions/';
            }
        });
    });

    if ( $('#swalMsg').length ) {
        swal.fire($('#swalMsg').data('msg'), '', $('#swalMsg').data('type'));
    }

    var onBoardingClose = function () {
        $('body').removeClass('modal-open');
        $('#onBoardingHolder').hide();
        localStorage.setItem('user_onboarding', 'done');
    };

    var onBoardingOpen = function () {
        $('body').addClass('modal-open');
        $(window).resize();
        $('#kt_aside_close_btn').click();
        $('#onBoardingHolder').show();
    };

    var onBoardingNext = function () {
        $('#onBoardingSlider').slick('slickNext');
    };

    $('#onBoardingSkipBtn, .onBoardingSlideFinishBtn').on('click', function () {
        onBoardingClose();
    });

    $('.onBoardingSlideNextBtn').on('click', function () {
        onBoardingNext();
    });

    $('#headerOnBoardingBtn').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        onBoardingOpen();
    });

    if ( $('#onBoardingHolder').length && localStorage.getItem('user_onboarding') !== 'done' ) {
        onBoardingOpen();
    }

    $('#onBoardingSlider').slick({
        dots: true,
        infinite: false,
        arrows: false,
    });
});