var _generatePassword = function (len, digitsCount, symbolsCount, upperCount) {
    var self = this;

    var upp = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    var dig = "0123456789";
    var spc = "`~!@#$%^&*()_+-=[]{}\|;:'\",./<>?";
    var str = upp.toLowerCase();

    var pass = "";

    for (var i = 0; i < upperCount; i++) {
        pass += upp.charAt(Math.random() * upp.length);
    }

    for (var i = 0; i < digitsCount; i++) {
        pass += dig.charAt(Math.random() * dig.length);
    }

    for (var i = 0; i < symbolsCount; i++) {
        pass += spc.charAt(Math.random() * spc.length);
    }

    var plen = pass.length;
    for (var i = plen; i < len; i++) {
        pass += str.charAt(Math.random() * str.length);
    }

    var p = pass.split("");
    var l = p.length;

    for (var i = l - 1; i > 0; i--) {
        var j = Math.floor(Math.random() * (i + 1));
        var tmp = p[i];
        p[i] = p[j];
        p[j] = tmp;
    }
    pass = p.join("");

    return pass.substr(0, len);
};

$(document).ready(function () {
    var lastClickedElement = null;

    $("#userProfilePictureInput").on('change', function() {
        var input = this;
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                $('#userProfilePicture').css('background-image', 'url(' + e.target.result + ')');
                $('#userProfilePictureChangeBtnsHolder').hide();
                $('#userProfilePictureUploadBtnsHolder').show();
            };
            reader.readAsDataURL(input.files[0]);
        }
    });

    $('#userProfilePictureChangeBtn, #userProfilePicture').on('click', function () {
        $('#userProfilePictureInput').click();
    });

    $('#userProfilePictureCancelBtn').on('click', function () {
        $('#userProfilePictureInput').val(null);
        $('#userProfilePictureChangeBtnsHolder').show();
        $('#userProfilePictureUploadBtnsHolder').hide();
        $('#userProfilePicture').css('background-image',  $('#userProfilePicture').data('bg'));
    });

    $('#userProfilePictureUploadBtn').on('click', function () {
        $('#userProfilePictureForm').submit();
    });

    $('.userProfileEditable form').on('submit', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var p = $(this).closest('.userProfileSection');
        userProfileSend(p);
    });

    function userProfileOpen(p) {
        p.find('.userProfileStatic').hide();
        p.find('.userProfileEditable').show();
    }

    function userProfileClose(p) {
        p.find('.userProfileStatic').show();
        p.find('.userProfileEditable').hide();
        userProfileErrorsHide(p);
        userProfileLoadingHide(p);
    }

    function userProfileErrorsHide(p) {
        p.find('.userProfileError').hide();
        p.find('input').removeClass('border-danger');
    }

    function userProfileClear(p) {
        p.find('.userProfileInput[data-clearable]').val('');
    }

    function userProfileLoadingShow(p) {
        p.find('.userProfileOverlay').show();
    }

    function userProfileLoadingHide(p) {
        p.find('.userProfileOverlay').hide();
    }

    function userProfileSuccess() {
        swal({
            type: 'success',
            title: 'Daten wurden erfolgreich geändert',
            toast: true,
            position: 'bottom-end',
            showConfirmButton: false,
            timer: 5000,
        });
    }

    function userProfileError(p, data) {
        userProfileErrorsHide(p)
        userProfileLoadingHide(p);
        var bag = data.error || data;
        for (key in bag) {
            var input = p.find('[name="' + key + '"]');
            if (input.length) {
                input.addClass('border-danger');
            }
            var msg = p.find('[data-input="' + key + '"]');
            if (msg.length) {
                msg.show().text(bag[key][0]);
            }
        }
    }

    function userProfileAttachData(p) {
        var els = p.find('[data-binded]');
        els.each(function () {
            var binded = $(this).data('binded');
            var el = p.find('.userProfileInput[name="' + binded + '"]');
            if (el.length) {
                $(this).val(el.val());
            }
        });
        p.removeClass('profileSectionEmpty').addClass('profileSectionFilled');
    }

    function userProfileSend(p) {
        var form = p.find('form[action]').first();
        var inputs = form.find('.userProfileInput');
        var reload = form.data('reload') || false;
        var data = {};
        inputs.each(function () {
            data[$(this).attr('name')] =  $(this).val();
        });
        userProfileLoadingShow(p);
        fetch(form.attr('action'), {
            body: JSON.stringify(data),
            headers: {
                'Accept': 'application/json',
            },
            method: 'POST',
        }).then(response => {
            if (response.ok) {
                userProfileClose(p);
                userProfileAttachData(p);
                userProfileClear(p);
                if (reload) {
                    location.reload();
                } else {
                    userProfileSuccess();
                }
            }
            if (401 === response.status || 422 === response.status) {
                return response.json().then(err => {
                    throw err;
                });
            }
        }).catch(error => {
            userProfileError(p, error);
        });
    }

    $('.userProfileEditBtn').on('click', function () {
        var p = $(this).closest('.userProfileSection');
        userProfileOpen(p);
    });

    $('.userProfileCancelBtn').on('click', function () {
        var p = $(this).closest('.userProfileSection');
        userProfileClose(p);
    });

    $('.userProfileSaveBtn').on('click', function () {
        var p = $(this).closest('.userProfileSection');
        userProfileSend(p);
    });

    function removeProfile() {
        fetch('/api/user/remove/', {
            headers: {
                'Accept': 'application/json',
            },
            method: 'POST',
        }).then(response => {
            location.href = '/';
        });
    }

    function removeProfileConfirm() {
        swal({
            title: 'Bist du sicher?',
            text: 'Wir fragen dich das letzte Mal!',
            type: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Ja',
            cancelButtonText: 'Nein',
            focusConfirm: false,
            focusCancel: true,
        }).then((result) => {
            if (result.value) {
                removeProfile();
            } else {
                $('#userProfileRemoveAgreement').prop('checked', false);
                $('#userProfileRemoveToggler').click();
            }
        });
    };

    $('#userProfileRemoveAgreement').on('change', function () {
        if ( $(this).prop('checked') ) {
            $('#userProfileRemoveBtn').removeAttr('disabled');
        } else {
            $('#userProfileRemoveBtn').attr('disabled', 'disabled');
        }
    });

    $('#userProfileRemoveBtn').on('click', removeProfileConfirm);

    function payPalUnbind() {
        $('#overlay').show();
        location.href = '/paypal/disconnect';
    }

    function payPalUnbindConfirm() {
        swal({
            title: 'Bist Du sicher?',
            text: '',
            type: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Ja',
            cancelButtonText: 'Nein',
            focusConfirm: false,
            focusCancel: true,
        }).then((result) => {
            if (result.value) {
                payPalUnbind();
            }
        });
    }

    function TFADisconnect() {
        $('#overlay').show();
        location.href = '/tfa/google/disconnect';
    }

    function TFADisconnectConfirm() {
        swal({
            title: 'Bist Du sicher?',
            text: '',
            type: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Ja',
            cancelButtonText: 'Nein',
            focusConfirm: false,
            focusCancel: true,
        }).then((result) => {
            if (result.value) {
                TFADisconnect();
            }
        });
    }

    function getTFAConnectHTML(data) {
        var html = '';

        html += '<p>Scann den QR-Code mit <a href="https://support.google.com/accounts/answer/1066447?hl=en" target="_blank">Google Authenticator</a>. Es wird ein 6-stelliger Code angezeigt, den Du unten eingeben musst.</p>';
        html += '<p class="text-center"><img height="200" width="200" src="' + data.qrcode + '" /></p>';
        html += '<p>Oder wähl die manuelle Eingabe in der App und gib Deinen Benutzernamen (<strong>' + data.name + '</strong>) und den Code ein: <strong>' + data.secret + '</strong></p>';

        return html;
    }

    function TFAConnect() {
        $('#overlay').show();

        fetch('/api/tfa/connect/', {
            headers: {
                'Accept': 'application/json',
            },
            method: 'POST',
        }).then(response => {
            $('#overlay').hide();
            if (response.ok) {
                return response.json();
            }
        }).then(result => {
            swal({
                title: 'Verbinde Deine App',
                html: getTFAConnectHTML(result.success),
                input: 'text',
                confirmButtonText: 'Verifizieren',
                showLoaderOnConfirm: true,
                preConfirm: (code) => {
                    if ( code.length !== 6 || !code.match(/^\d+$/) ) {
                        swal.showValidationMessage('Der Code muss aus sechs Ziffern bestehen');
                    } else {
                        return fetch('/api/tfa/finish', {
                            body: JSON.stringify({
                                code: code,
                            }),
                            headers: {
                                'Accept' : 'application/json',
                            },
                            method: 'POST',
                        }).then(response => {
                            if (response.ok) {
                                $('#overlay').show();
                                location.href = '/tfa/google/connect';
                            }
                            if (401 === response.status || 422 === response.status) {
                                return response.json().then(err => {throw err;});
                            }
                        }).catch(error => {
                            swal.showValidationMessage(_processAPIError(error).join('<br>'));
                        });
                    }
                },
                allowOutsideClick: () => !swal.isLoading()
            });
        });
    }

    var showHint = function (el) {
        el.closest('.inputHolder').find('.passwordHint').show();
    };

    var hideHint = function (el) {
        el.closest('.inputHolder').find('.passwordHint').hide();
    };

    var visualizeStrength = function (el) {
        var marks = [
            'Sehr schwach',
            'Schwach',
            'Mittel',
            'Stark',
            'Sehr stark',
        ];

        var hint = el.closest('.inputHolder').find('.passwordHint');
        var pw = el.val().trim();
        var min = el.data('min');
        var meter = hint.find('.passwordStrengthMeter');
        var mark = hint.find('.passwordHintValue');
        var notice = hint.find('.passwordHintNotice');

        if ( !pw.length ) {
            meter.attr('data-strength', 0);
            mark.text('');
            notice.text('Das Passwort ist leer');
        } else if ( pw.length < min ) {
            meter.attr('data-strength', 0);
            mark.text(marks[0]);
            notice.text('Das Passwort ist zu kurz');
        } else {
            var z = zxcvbn(pw);
            var score = z.score;
            meter.attr('data-strength', score);
            mark.text(marks[score]);
            if ( z.feedback && z.feedback.warning ) {
                notice.text(z.feedback.warning);
            } else {
                notice.text('Das Passwort ist sehr gut');
            }
        }
    };

    var generatePassword = function (el) {
        var pw = _generatePassword(24, 24, 3, 3, 3);
        var holder = el.closest('.inputHolder');
        var form = el.closest('form');
        var pwInput = holder.find('.passwordInput');
        var pwConfirmInput = form.find('.passwordConfirmInput');
        var pwToggler = holder.find('.passwordVisibilityToggler');

        pwInput.val(pw);

        if (pwConfirmInput.length) {
            pwConfirmInput.val(pw);
        }

        if ( !pwToggler.hasClass('active') ) {
            pwToggler.click();
        }

        pwInput.select();
        document.execCommand("copy");
        window.getSelection().removeAllRanges();

        swal({
            type: 'success',
            title: 'Das Passwort wurde erfolgreich generiert und in die Zwischenablage kopiert',
            toast: true,
            position: 'bottom-end',
            showConfirmButton: false,
            timer: 5000,
        });

        visualizeStrength(pwInput);
    };

    $('.passwordVisibilityToggler').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        $(this).toggleClass('active');

        var input = $(this).parent().find('input');
        if ( 'password' === input.attr('type') ) {
            input.attr('type', 'text');
        } else {
            input.attr('type', 'password');
        }

        input.focus();
    });

    $('.passwordInput').on('focus', function () {
        visualizeStrength($(this));
        showHint($(this));
    });

    $('.passwordInput').on('blur', function () {
        var hintClicked = lastClickedElement.hasClass('passwordGenerateBtn') || lastClickedElement.closest('.passwordHint').length;
        var togglerClicked = lastClickedElement.hasClass('passwordVisibilityToggler') || lastClickedElement.closest('.passwordVisibilityToggler').length;

        if ( null === lastClickedElement || !(hintClicked || togglerClicked) ) {
            hideHint($(this));
        }
    });

    $('.passwordInput').on('keyup', function () {
        visualizeStrength($(this));
    });

    $('.passwordGenerateBtn').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        generatePassword($(this));
    });

    $(document).on('mousedown', function (e) {
        lastClickedElement = $(e.target);
        if ( $('.passwordInput').length ) {
            $('.passwordInput').blur();
        }
    });

    $('#userProfilePayPalUnbindBtn').on('click', payPalUnbindConfirm);

    $('#userTFADisconnectBtn').on('click', TFADisconnectConfirm);

    $('#userTFAConnectBtn').on('click', TFAConnect);
});