var isEmailValid = function (email) {
    var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return re.test(String(email).toLowerCase());
};

var _processAPIError = function (data) {
    var text = [];
    var bag = data.error || data;
    if ('object' === typeof bag) {
        for (i in bag) {
            text.push(bag[i]);
        }
    } else if ('undefined' !== typeof bag) {
        text.push(bag);
    } else {
        text.push(data);
    }
    return text;
};

$(document).ready(function () {
    var clipboard = new ClipboardJS('.clipboard');
    var oldCityFieldStr = '';
    var oldSearchStr = '';
    var searchRequest = null;
    var searchResultsCache = [];
    var searchResultCurrent = -1;
    var geoResultsCache = [];
    var geoResultCurrent = -1;
    var geoRequest = null;

    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    clipboard.on('success', function(e) {
        e.clearSelection();

        swal({
            type: 'success',
            title: 'Erfolgreich kopiert',
            toast: true,
            position: 'bottom-end',
            showConfirmButton: false,
            timer: 5000,
        });
    });

    var APIcall = function (url, data, onSuccess, onError) {
        $.ajax(url, {
            type: 'post',
            data: data,
            dataType: 'json',
            success: function (response) {
                onSuccess(response);
            },
            error: function (error) {
                onError(error);
            },
        });
    };

    var clearValidationErrors = function (form) {
        form.find('.error-holder').text('').hide();
        form.find('.validable-input').removeClass('has-error');
    };

    var setValidationError = function (selector, message) {
        var el = $(selector);
        el.addClass('has-error');
        var name = el.attr('name');
        el.closest('form').find('.error-holder[data-owner="' + name + '"]').text(message).show();
    };

    var tryToLogin = function () {
        $('#overlay').show();
        login({
            email: $('#loginEmail').val().trim(),
            password: $('#loginPassword').val().trim(),
        }, function (response) {
            location.reload();
        }, function (error) {
            clearValidationErrors($('#loginForm'));
            setValidationError('#loginEmail', 'Der Benutzername oder das Passwort ist falsch');
            $('#overlay').hide();
        });
    };

    var login = function (data, onSuccess, onError) {
        APIcall('/api/login', data, onSuccess, onError);
    };

    var isLoginFormValid = function () {
        clearValidationErrors($('#loginForm'));

        var valid = true;

        var email = $('#loginEmail').val().trim();
        if (!email.length) {
            setValidationError('#loginEmail', 'E-Mail Adresse muss ausgefüllt sein.');
            valid = false;
        } else if ( !isEmailValid(email) ) {
            setValidationError('#loginEmail', 'E-Mail Adresse muss eine gültige E-Mail-Adresse sein.');
            valid = false;
        }

        var password = $('#loginPassword').val().trim();
        if (!password.length) {
            setValidationError('#loginPassword', 'Passwort muss ausgefüllt sein.');
            valid = false;
        }

        return valid;
    };

    $('#loginForm').submit(function (e) {
        e.preventDefault();
        e.stopPropagation();

        if ( isLoginFormValid() ) {
            tryToLogin();
        }
    });

    $('.validable-input').on('change keyup', function () {
        var name = $(this).attr('name');
        $(this).closest('form').find('.error-holder[data-owner="' + name + '"]').text('').hide();
        $(this).removeClass('has-error');
    });

    var showLoginForm = function () {
        $('.sign-in.popup-with-zoom-anim').click();
    };

    var toggleFav = function (dealId) {
        $.post('/api/fav/' + dealId);
    };

    var tryToToggleFav = function (el) {
        el.toggleClass('liked');

        var favsCount = parseInt($('#favsCounter').text()) || 0;
        if ( el.hasClass('liked') ) {
            favsCount++;
        } else {
            favsCount--;
        }
        $('#favsCounter').text(favsCount > 0 ? favsCount : '');

        toggleFav(el.closest('.deal').data('deal-id'));
    };

    $('.deal-fav').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        if (!$(this).hasClass('disabled')) {
            tryToToggleFav($(this));
        }
    });

    function registerShare(entity, entityId, provider) {
        if (!entity || !entityId) {
            return;
        }

        fetch('/api/share/register', {
            body: JSON.stringify({
                entity: entity,
                id: entityId,
                provider: provider,
            }),
            headers: {
                'Accept' : 'application/json',
            },
            method: 'POST',
        });
    }

    async function shareLinkViaEmail(link, entity, entityId, type) {
        swal({
            title: 'E-Mail Adresse eingeben',
            input: 'text',
            confirmButtonText: ('invite' === type) ? 'Jetzt einladen' : 'Jetzt empfehlen',
            showLoaderOnConfirm: true,
            preConfirm: (email) => {
                if (!email.length) {
                    swal.showValidationMessage('E-Mail Adresse muss ausgefüllt sein.');
                } else if (!isEmailValid(email)) {
                    swal.showValidationMessage('E-Mail Adresse muss eine gültige E-Mail-Adresse sein.');
                } else {
                    return fetch('/api/share_' + type + 'link/email', {
                        body: JSON.stringify({
                            link: link,
                            email: email,
                            entity: entity,
                            entity_id: entityId,
                        }),
                        headers: {
                            'Accept' : 'application/json',
                        },
                        method: 'POST',
                    }).then(response => {
                        if (response.ok) {
                            return response.json();
                        }
                        if (401 === response.status || 422 === response.status) {
                            return response.json().then(err => {throw err;});
                        }
                    }).catch(error => {
                        swal.showValidationMessage(_processAPIError(error).join('<br>'));
                    });
                }
            },
            allowOutsideClick: () => !swal.isLoading()
        }).then(result => {
            if (result.value) {
                registerShare(entity, entityId, 'email');
                swal({
                    type: 'success',
                    title: 'Vielen Dank für Deine ' + ('invite' === type ? 'Einladung' : 'Empfehlung') + '!',
                });
            }
        });
    }

    $('[data-provider]').on('click', function () {
        var entity = $(this).data('entity');
        var entityId = $(this).data('entity-id');
        var provider = $(this).data('provider');

        registerShare(entity, entityId, provider);
    });

    $('[data-share="email"]').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var link = $(this).data('link');
        var entity = $(this).data('entity');
        var entityId = $(this).data('entity-id');
        var type = $(this).data('type') || 'ref';

        shareLinkViaEmail(link, entity, entityId, type);
    });

    function showCouponCode(data) {
        swal({
            'type': 'success',
            'title': 'Mit diesem Code erhälst Du beim Einkauf das Cashback!',
            'html':
                '<div class="coupon-barcode pt-5"><img src="' + data.qrcode + '"></div>' +
                '<div class="coupon-code pb-5" style="color:#000">' + data.code + '</div>' +
                '<div><a class="btn btn-secondary" href="/coupons">Zum RECO.BONs</a></div>',
        });
    }

    function dealGetCashback(dealId) {
        swal({
            title: 'Coupon jetzt aktivieren?',
            text: 'Du erhältst einen RECO.BON',
            type: 'question',
            showCancelButton: true,
            confirmButtonText: 'Ja',
            cancelButtonText: 'Nein',
            allowOutsideClick: () => !swal.isLoading(),
            showLoaderOnConfirm: true,
            preConfirm: () => {
                return fetch('/api/deal/' + dealId + '/getcashback/', {
                    headers: {
                        'Accept' : 'application/json',
                    },
                    method: 'POST',
                }).then(response => {
                    if (response.ok) {
                        return response.json();
                    }
                    if (401 === response.status || 422 === response.status) {
                        return response.json().then(err => {throw err;});
                    }
                }).catch(error => {
                    swal.showValidationMessage(_processAPIError(error).join('<br>'));
                })
            }
        }).then(result => {
            if (result.value) {
                showCouponCode(result.value.success);
            }
        });
    }

    function showCoupon(couponId) {
        fetch('/coupon/' + couponId + '/view')
            .then(response => {
                if (response.ok) {
                    return response.text();
                }
            })
            .then(result => {
                swal({
                    html: result,
                });
            });
    }

    $(document).on('click', '.dealGetCashbackBtn', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var attr = $(this).attr('data-deal-id');

        if (typeof attr !== typeof undefined && attr !== false) {
            var dealId = $(this).data('deal-id');
        } else {
            var dealId = $(this).closest('.deal').data('deal-id');
        }

        dealGetCashback(dealId);
    });

    $('.showCoupon').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var couponId = $(this).data('coupon-id');

        showCoupon(couponId);
    });

    $('#btnBarShowSharesBtn').on('click', function () {
        $('#btnBarOptionsHolder').hide();
        $('#btnBarShareOuter').show();
    });

    $('#btnBarHideSharesBtn').on('click', function () {
        $('#btnBarOptionsHolder').show();
        $('#btnBarShareOuter').hide();
    });

    $(document).on('click touchstart', function (e) {
        if ( !$(e.target).closest('#btnBar').length ) {
            $('#btnBarOptionsHolder').show();
            $('#btnBarShareOuter').hide();
        }
    });

    $('#payoutBtnMock').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        swal('Du kannst aktuell noch keine Auszahlung vornehmen');
    });

    $('#profileNewsletterSave').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var url = $('#profileNewsletter').prop('checked')
            ? '/api/newsletter/subscribe'
            : '/api/newsletter/unsubscribe';

        $('#userProfileSectionNewsletter .userProfileOverlay').show();

        APIcall(url, {}, function () {
            swal({
                type: 'success',
                title: 'Erfolgreich gespeichert',
                toast: true,
                position: 'bottom-end',
                showConfirmButton: false,
                timer: 5000,
            });
            $('#userProfileSectionNewsletter .userProfileOverlay').hide();
        });
    });

    $('#emailVerificationSend').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        $('#overlay').show();

        APIcall('/api/email/sendtoken', {}, function () {
            swal({
                type: 'success',
                title: 'Wir haben eine Bestätigungsmail mit einem Link gesendet.',
                toast: true,
                position: 'bottom-end',
                showConfirmButton: false,
                timer: 5000,
            });
            $('#overlay').hide();
        });
    });

    if ( $('#swalMsg').length ) {
        swal($('#swalMsg').data('msg'), '', $('#swalMsg').data('type'));
    }

    $('.dealShareToggleBtn').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        $('.dealShareToggleBtn').show();
        $('.dealShareBtnsHolder').hide();
        $(this).hide();
        $(this).closest('.deal').find('.dealShareBtnsHolder').show();
    });

    $(document).on('click', '.couponQRCodeBtn', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var p = $(this).closest('.couponItem');
        var q = p.find('.couponQRCodeHolder');
        $('.couponQRCodeHolder').hide();
        q.show();
    });

    $(document).on('click', '.couponQRCloseBtn', function () {
        $('.couponQRCodeHolder').hide();
    });

    $('.showlogin').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        showLoginForm();
    });

    $('#activeSessionsRemoveBtn').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        swal.fire({
            title: 'Bist du sicher?',
            heightAuto: false,
            text: 'Du kannst das nicht rückgängig machen!',
            type: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Ja',
            cancelButtonText: 'Nein',
        }).then((result) => {
            if (result.value) {
                location.href = '/user/flush_sessions/';
            }
        });
    });

    function addFiltersToLink(link) {
        var currentURL = new URL(location.href);
        var url = new URL(link);

        if ( null !== currentURL.searchParams.get('sort') ) {
            url.searchParams.set('sort', currentURL.searchParams.get('sort'));
        }

        return url.href;
    }

    function geoFindMe() {
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(function (position) {
                var lat = position.coords.latitude;
                var lon = position.coords.longitude;
                var protocol = window.location.protocol;
                var hostname = window.location.hostname;
                var link = protocol + '//' + hostname + '/deals/?lat=' + lat + '&lon=' + lon;
                location.href = addFiltersToLink(link);
            }, function () {
                swal("Geolocation wird abgelehnt.", '', 'error');
            });
        } else {
            swal("Geolocation wird von diesem Browser nicht unterstützt.", '', 'error');
        }
    }

    function geoRenderCitiesMarkup(cities) {
        var protocol = window.location.protocol;
        var hostname = window.location.hostname;
        var html = '';
        for (i in cities) {
            var link = addFiltersToLink(protocol + '//' + hostname + '/deals/?lat=' + cities[i].lat + '&lon=' + cities[i].lon + '&city=' + cities[i].name + '&plz=' + cities[i].zip + '&loc_id=' + cities[i].loc_id);
            html +=
                '<div class="geoResultItem geoResultCity">' +
                '<a href="' + link + '">' +
                '<div class="geoResultItemIcon"><i class="fas fa-map-pin"></i></div>' +
                '<div class="geoResultItemName"><span>' + cities[i].zip + '</span>' + cities[i].name + '</div>' +
                '</a>' +
                '</div>';
        }
        return html;
    }

    function geoRenderCities(results) {
        if ( !results.length ) {
            $('#geoTooltip').show().text('Wir konnten diesen Standort nicht gefunden.');
            $('#geoResultsHolder').hide();
            $('#geoLastSearches').show();
        } else {
            var cities = geoRenderCitiesMarkup(results);
            $('#geoTooltip').hide();
            $('#geoResultsHolder').show();
            $('#geoResults').html(cities);
            $('#geoLastSearches').hide();
        }
    }

    function geoFindCity(str) {
        geoResultCurrent = -1;
        $('.geoResultItem').removeClass('active');
        if ('undefined' !== typeof geoResultsCache['c_' + str]) {
            geoRenderCities(geoResultsCache['c_' + str]);
            oldCityFieldStr = str;
        } else {
            geoRequest = $.ajax('/api/cities/find', {
                type: 'post',
                data: {
                    str: str,
                },
                dataType: 'json',
                beforeSend: function () {
                    if (geoRequest != null) {
                        geoRequest.abort();
                    }
                },
                success: function (response) {
                    geoResultsCache['c_' + str] = response.success;
                    geoRenderCities(response.success);
                    oldCityFieldStr = str;
                },
            });
        }
    }

    function geoGoToSelected() {
        var item = $('.geoResultItem.active');
        if ( item.length ) {
            var a = item.find('a');
            if (a.length) {
                a.click();
            } else {
                $('.geoResultItem.active').click();
            }
        }
    }

    $(document).on('mousedown', '#geoFindMeBtn', function (e) {
        e.preventDefault();
        e.stopPropagation();

        geoResultsHide();
        geoFindMe();
    });

    $(document).on('mousedown click', '.geoResultItem > a', function (e) {
        e.preventDefault();
        e.stopPropagation();

        geoResultsHide();
        location.href = addFiltersToLink($(this).attr('href'));
    });

    $('#geoInput').on('keyup', function (e) {
        if (e.which == 27 || e.keyCode == 27) {
            $(this).blur();
            geoResultsHide();
        }

        if (e.which == 13 || e.keyCode == 13) {
            geoGoToSelected();
        }

        var str = $(this).val().trim();
        if (str.length >= 3) {
            if (oldCityFieldStr !== str) {
                $('#geoTooltip').show().text('Warte bitte...');
                $('#geoResultsHolder').hide();
                geoFindCity(str);
            }
        } else {
            $('#geoTooltip').show().text('Beginne zu tippen');
            $('#geoResultsHolder').hide();
            $('#geoLastSearches').show();
            oldCityFieldStr = '';
        }
    });

    function geoResultsShow() {
        $('#geoBody').show();
    }

    function geoResultsHide() {
        $('#geoBody').hide();
    }

    function geoResultSelectPrev() {
        var l = $('.geoResultItem:visible').length;
        if ( l ) {
            if (-1 === geoResultCurrent) {
                geoResultCurrent = l - 1;
            } else {
                geoResultCurrent -= 1;
                if (geoResultCurrent < 0) {
                    geoResultCurrent = l - 1;
                }
            }

            $('.geoResultItem').removeClass('active');
            $('.geoResultItem:visible').eq(geoResultCurrent).addClass('active');
        }
    }

    function geoResultSelectNext() {
        var l = $('.geoResultItem:visible').length;
        if ( l ) {
            if (-1 === geoResultCurrent) {
                geoResultCurrent = 0;
            } else {
                geoResultCurrent += 1;
                if (geoResultCurrent >= l) {
                    geoResultCurrent = 0;
                }
            }

            $('.geoResultItem').removeClass('active');
            $('.geoResultItem:visible').eq(geoResultCurrent).addClass('active');
        }
    }

    $('#geoInput').on('keydown', function (e) {
        if (e.which == 38 || e.keyCode == 38) {
            geoResultSelectPrev();
            return false;
        }

        if (e.which == 40 || e.keyCode == 40) {
            geoResultSelectNext();
            return false;
        }
    });

    $('#geoInput').on('focus', function () {
        geoResultsShow();
    });

    $('#geoInput').on('blur', function () {
        geoResultsHide();
    });

    function searchResultsRenderDeals(list) {
        var l = list.length;
        var html = '';
        for (i = 0; i < l; i++) {
            var item = list[i];
            html +=
                '<div class="searchResultItem searchResultDeal">' +
                '<a href="' + item.link + '">' +
                '<div class="searchResultItemImage searchResultDealImage" style="background-image:url(' + item.image + ')"></div>' +
                '<div class="searchResultItemName searchResultDealName">' + item.title + ' bei ' + item.seller + '</div>' +
                '</a>' +
                '</div>';
        }
        return html;
    }

    function searchResultsRenderSellers(list) {
        var l = list.length;
        var html = '';
        for (i = 0; i < l; i++) {
            var item = list[i];
            html +=
                '<div class="searchResultItem searchResultSeller">' +
                '<a href="' + item.link + '">' +
                '<div class="searchResultItemImage searchResultSellerLogo" style="background-image:url(' + item.logo + ')"></div>' +
                '<div class="searchResultItemName searchResultSellerName">' + item.company + '</div>' +
                '</a>' +
                '</div>';
        }
        return html;
    }

    function searchResultsRenderCategories(list) {
        var l = list.length;
        var html = '';
        for (i = 0; i < l; i++) {
            var item = list[i];
            html +=
                '<div class="searchResultItem searchResultCategory">' +
                '<a href="' + item.link + '">' +
                '<div class="searchResultItemIcon searchResultCategoryIcon"><i class="far fa-folder-open"></i></div>' +
                '<div class="searchResultItemName searchResultCategoryName">' + item.name + '</div>' +
                '</a>' +
                '</div>';
        }
        return html;
    }

    function searchResultsRender(results) {
        if ( !results.deals.length && !results.sellers.length && !results.categories.length ) {
            $('#searchTooltip').show().text('Tut uns leid. Nicths gefunden.');
            $('#searchResults').hide();
        } else {
            var deals = searchResultsRenderDeals(results.deals);
            var sellers = searchResultsRenderSellers(results.sellers);
            var categories = searchResultsRenderCategories(results.categories);
            $('#searchTooltip').hide();
            $('#searchResults').show().html(deals + sellers + categories);
        }
    }

    function searchApply(q) {
        searchResultCurrent = -1;
        $('.searchResultItem').removeClass('active');
        if ('undefined' !== typeof searchResultsCache['s_' + q]) {
            searchResultsRender(searchResultsCache['s_' + q]);
            oldSearchStr = q;
        } else {
            searchRequest = $.ajax('/api/search', {
                type: 'post',
                data: {
                    q: q,
                },
                dataType: 'json',
                beforeSend: function () {
                    if (searchRequest != null) {
                        searchRequest.abort();
                    }
                },
                success: function (response) {
                    searchResultsCache['s_' + q] = response.success;
                    searchResultsRender(response.success);
                    oldSearchStr = q;
                }
            });
        }
    }

    function searchOpenPage() {
        if ( $('.searchResultItem.active').length ) {
            location.href = $('.searchResultItem.active a').attr('href');
        } else {
            var q = $('#searchInput').val().trim();
            if (q.length >= 3) {
                location.href = '/search?q=' + q;
            }
        }
    }

    function searchResultsShow() {
        $('#searchBody').show();
    }

    function searchResultsHide() {
        $('#searchBody').hide();
        $('.searchResultItem').removeClass('active');
        searchResultCurrent = -1;
    }

    function searchResultSelectPrev() {
        var l = $('.searchResultItem').length;
        if ( l ) {
            if (-1 === searchResultCurrent) {
                searchResultCurrent = l - 1;
            } else {
                searchResultCurrent -= 1;
                if (searchResultCurrent < 0) {
                    searchResultCurrent = l - 1;
                }
            }

            $('.searchResultItem').removeClass('active');
            $('.searchResultItem').eq(searchResultCurrent).addClass('active');
        }
    }

    function searchResultSelectNext() {
        var l = $('.searchResultItem').length;
        if ( l ) {
            if (-1 === searchResultCurrent) {
                searchResultCurrent = 0;
            } else {
                searchResultCurrent += 1;
                if (searchResultCurrent >= l) {
                    searchResultCurrent = 0;
                }
            }

            $('.searchResultItem').removeClass('active');
            $('.searchResultItem').eq(searchResultCurrent).addClass('active');
        }
    }

    $('#searchInput').on('keydown', function (e) {
        if (e.which == 38 || e.keyCode == 38) {
            searchResultSelectPrev();
            return false;
        }

        if (e.which == 40 || e.keyCode == 40) {
            searchResultSelectNext();
            return false;
        }
    });

    $('#searchInput').on('keyup', function (e) {
        if (e.which == 13 || e.keyCode == 13) {
            searchOpenPage();
        }

        if (e.which == 27 || e.keyCode == 27) {
            $(this).blur();
            searchResultsHide();
        }

        var q = $(this).val().trim();
        if (q.length >= 3) {
            if (oldSearchStr !== q) {
                $('#searchTooltip').show().text('Warte bitte...');
                $('#searchResults').hide().text('');
                searchApply(q);
            }
        } else {
            $('#searchTooltip').show().text('Beginne zu tippen');
            $('#searchResults').hide().text('');
            oldSearchStr = '';
        }
    });

    $('#searchInput').on('focus', function () {
        searchResultsShow();
    });

    $('#searchInput').on('blur', function () {
        searchResultsHide();
    });

    $('#searchInputButton').on('click', function () {
        searchOpenPage();
    });

    $(document).on('mousedown', '.searchResultItem > a', function (e) {
        e.preventDefault();
        e.stopPropagation();

        searchResultsHide();
        location.href = $(this).attr('href');
    });

    $('#searchInputToggler').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        $('body').addClass('modal-open');
        $('#searchControlsHolder').show();
        $('#searchInput').focus();
    });

    $('#geoInputToggler').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        $('body').addClass('modal-open');
        $('#searchControlsHolder').show();
        $('#geoInput').focus();
    });

    $('#searchControlsClose').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        $('body').removeClass('modal-open');
        $('#searchControlsHolder').hide();
    });

    function searchResize() {
        var wh = $(window).height();
        var mh = $('#bar:visible').length ? 200 : 100;
        var nh = wh - mh;
        $('#geoBody, #searchBody').css('max-height', nh + 'px');
    };

    $(window).on('resize', searchResize);

    setTimeout(searchResize, 100);

    $('.dealsShowMore').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var p = $(this).closest('.dealsContainer');
        var h = $(this).closest('.dealsShowMoreHolder');

        p.find('.deal.hidden').slice(0, 1).removeClass('hidden');

        if ( !p.find('.deal.hidden').length ) {
            h.remove();
        }
    });

    $(document).on('click', '#sortingSelect_chosen li.active-result', function () {
        var idx = parseInt($(this).data('option-array-index'));
        var opt = $('#sortingSelect option').eq(idx);
        var link = opt.data('link');
        if ( link !== location.href ) {
            $('#overlay').show();
            location.href = link;
        }
    });

    /*
    var onBoardingClose = function () {
        $('body').removeClass('modal-open');
        $('#onBoardingHolder').hide();
        localStorage.setItem('user_onboarding', 'done');
    };

    var onBoardingOpen = function () {
        $('body').addClass('modal-open');
        $(window).resize();
        $('#onBoardingHolder').show();
    };

    var onBoardingNext = function () {
        $('#onBoardingSlider').slick('slickNext');
    };

    $('#onBoardingSkipBtn, .onBoardingSlideFinishBtn').on('click', function () {
        onBoardingClose();
    });

    $('.onBoardingSlideNextBtn').on('click', function () {
        onBoardingNext();
    });

    $('#headerOnBoardingBtn').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        onBoardingOpen();
    });

    if ( $('#onBoardingHolder').length && localStorage.getItem('user_onboarding') !== 'done' ) {
        onBoardingOpen();
    }

    $('#onBoardingSlider').slick({
        dots: true,
        infinite: false,
        arrows: false,
    });
    */
});