var _validateEmail = function (email) {
    var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return re.test(String(email).toLowerCase());
};

var _generatePassword = function (len, digitsCount, symbolsCount, upperCount) {
    var self = this;

    var upp = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    var dig = "0123456789";
    var spc = "`~!@#$%^&*()_+-=[]{}\|;:'\",./<>?";
    var str = upp.toLowerCase();

    var pass = "";

    for (var i = 0; i < upperCount; i++) {
        pass += upp.charAt(Math.random() * upp.length);
    }

    for (var i = 0; i < digitsCount; i++) {
        pass += dig.charAt(Math.random() * dig.length);
    }

    for (var i = 0; i < symbolsCount; i++) {
        pass += spc.charAt(Math.random() * spc.length);
    }

    var plen = pass.length;
    for (var i = plen; i < len; i++) {
        pass += str.charAt(Math.random() * str.length);
    }

    var p = pass.split("");
    var l = p.length;

    for (var i = l - 1; i > 0; i--) {
        var j = Math.floor(Math.random() * (i + 1));
        var tmp = p[i];
        p[i] = p[j];
        p[j] = tmp;
    }
    pass = p.join("");

    return pass.substr(0, len);
};

$(document).ready(function () {
    var lastClickedElement = null;

    $('.passwordVisibilityToggler').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        $(this).toggleClass('active');

        var input = $(this).parent().find('input');
        if ( 'password' === input.attr('type') ) {
            input.attr('type', 'text');
        } else {
            input.attr('type', 'password');
        }

        input.focus();
    });

    var raiseError = function (el, msg) {
        el.closest('.inputHolder').find('.error-message').hide();
        var err = $(el.data('err'));
        err.show().text(msg);
    };

    var hideError = function (el) {
        var err = $(el.data('err'));
        err.hide();
    };

    var showHint = function (el) {
        el.closest('.inputHolder').find('.passwordHint').show();
    };

    var hideHint = function (el) {
        el.closest('.inputHolder').find('.passwordHint').hide();
    };

    var visualizeStrength = function (el) {
        var marks = [
            'Sehr schwach',
            'Schwach',
            'Mittel',
            'Stark',
            'Sehr stark',
        ];

        var hint = el.closest('.inputHolder').find('.passwordHint');
        var pw = el.val().trim();
        var min = el.data('min');
        var meter = hint.find('.passwordStrengthMeter');
        var mark = hint.find('.passwordHintValue');
        var notice = hint.find('.passwordHintNotice');

        if ( !pw.length ) {
            meter.attr('data-strength', 0);
            mark.text('');
            notice.text('Das Passwort ist leer');
        } else if ( pw.length < min ) {
            meter.attr('data-strength', 0);
            mark.text(marks[0]);
            notice.text('Das Passwort ist zu kurz');
        } else {
            var z = zxcvbn(pw);
            var score = z.score;
            meter.attr('data-strength', score);
            mark.text(marks[score]);
            if ( z.feedback && z.feedback.warning ) {
                notice.text(z.feedback.warning);
            } else {
                notice.text('Das Passwort ist sehr gut');
            }
        }
    };

    var generatePassword = function (el) {
        var pw = _generatePassword(24, 24, 3, 3, 3);
        var holder = el.closest('.inputHolder');
        var form = el.closest('form');
        var pwInput = holder.find('.passwordInput');
        var pwConfirmInput = form.find('.passwordConfirmInput');
        var pwToggler = holder.find('.passwordVisibilityToggler');

        pwInput.val(pw);

        if (pwConfirmInput.length) {
            pwConfirmInput.val(pw);
        }

        if ( !pwToggler.hasClass('active') ) {
            pwToggler.click();
        }

        pwInput.select();
        document.execCommand("copy");
        window.getSelection().removeAllRanges();

        swal({
            type: 'success',
            title: 'Das Passwort wurde erfolgreich generiert und in die Zwischenablage kopiert',
            toast: true,
            position: 'bottom-end',
            showConfirmButton: false,
            timer: 5000,
        });

        visualizeStrength(pwInput);
    };

    var validateForm = function (form) {
        var valid = true;

        var emailInput = form.find('.emailInput');

        if (emailInput.length) {
            var email = emailInput.val().trim();
            if ( !email.length ) {
                valid = false;
                raiseError(emailInput, 'Bitte gib eine gültige E-Mail-Adresse ein.');
            } else if ( !_validateEmail(email) ) {
                valid = false;
                raiseError(emailInput, 'Bitte gib Sie eine gültige E-Mail-Adresse ein.');
            }
        }

        var passwordInput = form.find('.passwordInput');

        if (passwordInput.length) {
            var password = passwordInput.val().trim();
            var min = passwordInput.data('min');
            var strength = passwordInput.data('strength');
            if ( !password.length ) {
                valid = false;
                raiseError(passwordInput, 'Das Passwort muss ausgefüllt sein.');
            } else if ( password.length < min ) {
                valid = false;
                raiseError(passwordInput, 'Das Passwort muss mindestens ' + min + ' Zeichen lang sein.');
            } else if ( zxcvbn(password).score < strength ) {
                valid = false;
                raiseError(passwordInput, 'Das Passwort ist zu schwach.');
            }
        }

        var passwordConfirmInput = form.find('.passwordConfirmInput');

        if (passwordConfirmInput.length) {
            var confirm = passwordConfirmInput.val().trim();
            if (password !== confirm) {
                valid = false;
                raiseError(passwordConfirmInput, 'Passwort stimmt nicht mit der Bestätigung überein.');
            }
        }

        var agbInput = form.find('.agbInput');

        if (agbInput.length) {
            if ( !agbInput.prop('checked') ) {
                valid = false;
                raiseError(agbInput, 'AGB und Datenschutzerklärung muss akzeptiert werden.');
            }
        }

        return valid;
    };

    $('.formValidate').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var form = $(this).closest('form');

        if ( validateForm(form) ) {
            form.submit();
        }
    });

    $('.agbInput, .emailInput, .passwordInput').on('change keyup', function () {
        hideError($(this));
    });

    $('.passwordInput').on('focus', function () {
        visualizeStrength($(this));
        showHint($(this));
    });

    $('.passwordInput').on('blur', function () {
        if ( null === lastClickedElement ) {
            hideHint($(this));
            return;
        }

        var hintClicked = lastClickedElement.hasClass('passwordGenerateBtn') || lastClickedElement.closest('.passwordHint').length;
        var togglerClicked = lastClickedElement.hasClass('passwordVisibilityToggler') || lastClickedElement.closest('.passwordVisibilityToggler').length;

        if ( !(hintClicked || togglerClicked) ) {
            hideHint($(this));
        }
    });

    $('.passwordInput').on('keyup', function () {
        visualizeStrength($(this));
    });

    $('.passwordGenerateBtn').on('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        generatePassword($(this));
    });

    $(document).on('mousedown', function (e) {
        lastClickedElement = $(e.target);
        if ( $('.passwordInput').length ) {
            $('.passwordInput').blur();
        }
    });

    if ( $('#swalMsg').length ) {
        swal($('#swalMsg').data('msg'), '', $('#swalMsg').data('type'));
    }

    setTimeout(function () {
        $('input[name="sectoken"]').attr('value', '');
    }, 1000);
});