var _processAPIError = function (data) {
    var text = [];
    if ('object' === typeof data.error) {
        for (i in data.error) {
            text.push(data.error[i]);
        }
    } else if ('undefined' !== typeof data.error) {
        text.push(data.error);
    } else {
        text.push(data);
    }
    return text;
};

$(document).ready(function () {
    var needsNetto = false;
    var codeChanged = true;
    var requestInProcess = false;

    new Cleave('#redeemingNetto', {
        numeral: true,
        numeralDecimalMark: ',',
        delimiter: '.'
    });

    var showCodeStep = function () {
        $('.redeemingStep').hide();
        $('#redeemingStepCode').show();
        $('#redeemingCode').focus();
    };

    var showNettoStep = function () {
        $('.redeemingStep').hide();
        $('#redeemingStepNetto').show();
        $('#redeemingNetto').focus();
    };

    var showPaymentStep = function () {
        $('.redeemingStep').hide();
        $('#redeemingStepPayment').show();
    };

    var showNextByCodeStep = function () {
        if (needsNetto) {
            showNettoStep();
        } else {
            showPaymentStep();
        }
    };

    var showPrevByPaymentStep = function () {
        if (needsNetto) {
            showNettoStep();
        } else {
            showCodeStep();
        }
    };

    var couponCodeValid = function () {
        var code = getCouponCode();
        if (9 !== code.length) {
            setTimeout(function () {
                swal({
                    title: 'RECO.CODE sollte 9 Symbole enthalten',
                    type: 'error',
                    heightAuto: false
                });
            }, 100);
            return false;
        }

        return true;
    };

    var getCouponCode = function () {
        return $('#redeemingCode').val().split(' ').join('');
    };

    var getNetto = function () {
        return parseFloat($('#redeemingNetto').val().trim().split('.').join('').replace(',', '.')) || 0;
    };

    var couponNettoValid = function () {
        var netto = getNetto();
        if (netto <= 0) {
            swal({
                title: 'Dieser RECO.BON benötigt eine Warenwert',
                type: 'error',
                heightAuto: false
            });
            return false;
        }

        return true;
    };

    var couponRedeem = function () {
        $('#overlay').show();

        $.ajax({
            url: '/api/coupon/redeem/',
            method: 'POST',
            dataType: 'json',
            data: {
                code: getCouponCode(),
                netto: getNetto(),
                payment: $('input[name="payment_type"]:checked').val(),
            },
            success: function (response) {
                $('#overlay').hide();
                swal({
                    title: 'Der RECO.BON wurde angenommen',
                    type: 'success',
                    heightAuto: false
                }).then((result) => {
                    window.location.href = $('#redeemingCancelBtn').attr('href');
                });
            },
            error: function (response) {
                $('#overlay').hide();
                swal({
                    title: _processAPIError(response.responseJSON).join('<br>'),
                    type: 'error',
                    heightAuto: false
                });
            },
        });
    };

    var couponGetByCode = function () {
        $('#overlay').show();
        requestInProcess = true;

        $.ajax({
            url: '/api/coupon/getbycode/',
            method: 'POST',
            dataType: 'json',
            data: {
                code: getCouponCode(),
            },
            success: function (response) {
                $('#overlay').hide();
                codeChanged = false;
                needsNetto = response.success.needsNetto;
                showNextByCodeStep();
                requestInProcess = false;
            },
            error: function (response) {
                $('#overlay').hide();
                swal({
                    title: _processAPIError(response.responseJSON).join('<br>'),
                    type: 'error',
                    heightAuto: false
                });
                requestInProcess = false;
            },
        });
    };

    var couponCodeApply = function () {
        if (!codeChanged) {
            showNextByCodeStep();
        } else if ( !requestInProcess && couponCodeValid() ) {
            couponGetByCode();
        }
    };

    var couponNettoApply = function () {
        if ( couponNettoValid() ) {
            showPaymentStep();
        }
    };

    $('#redeemingCodeBtn, #redeemingCodeInputBtn').on('click', function () {
        couponCodeApply();
    });

    $('#redeemingCode').on('change', function () {
        codeChanged = true;
    });

    $('#redeemingCode').on('keydown', function (e) {
        if ( 13 === e.keyCode || 13 === e.which ) {
            couponCodeApply();
        }
    });

    $('#redeemingCode').on('paste', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var text = (e.originalEvent || e).clipboardData.getData('text/plain');
        text = text.replace(/[^A-Za-z0-9]/g, '');

        $(this).val(text);
        $(this).unmask().mask("AAA AAA AAA", {placeholder: "_ _ _ _ _ _ _ _ _"});
        var that = this;
        setTimeout(function() {
            that.selectionStart = that.selectionEnd = 10000;
        }, 0);
    });

    $('#redeemingNettoBtn, #redeemingNettoInputBtn').on('click', function () {
        couponNettoApply();
    });

    $('#redeemingNettoBackBtn').on('click', function () {
        showCodeStep();
    });

    $('#redeemingPaymentBackBtn').on('click', function () {
        showPrevByPaymentStep();
    });

    $('#redeemingFinishBtn').on('click', function () {
        couponRedeem();
    });

    $('#redeemingForm').on('submit', function (e) {
        e.preventDefault();
        e.stopPropagation();
    });

    $('#redeemingCode').mask("AAA AAA AAA", {placeholder: "_ _ _ _ _ _ _ _ _"});

    showCodeStep();
});