var _processAPIError = function (data) {
    var text = [];
    var bag = data.error || data;
    if ('object' === typeof bag) {
        for (i in bag) {
            text.push(bag[i]);
        }
    } else if ('undefined' !== typeof bag) {
        text.push(bag);
    } else {
        text.push(data);
    }
    return text;
};

$(document).ready(function () {
    var payoutItems = [];
    var paymentType = null;

    var showStepTransactions = function () {
        $('.payoutStep').hide();
        $('#payoutStepTransactions').show();
    };

    var showStepPayment = function () {
        sessionStorage.removeItem('payout_items');
        var payoutItemsCache = [];
        $('.payoutCheckbox:checked').each(function () {
            var id = $(this).data('id');
            payoutItemsCache.push(id);
        });
        sessionStorage.setItem('payout_items', JSON.stringify(payoutItemsCache));

        $('.payoutStep').hide();
        $('#payoutStepPayment').show();
    };

    var prepareSummary = function () {
        var total = 0;

        payoutItems = [];

        $('.payoutSummaryItem').hide();

        $('.payoutCheckbox:checked').each(function () {
            var id = $(this).data('id');
            total += parseFloat($('.payoutItem[data-id="' + id + '"]').data('amount'));
            $('.payoutSummaryItem[data-id="' + id + '"]').show();
            payoutItems.push(id);
        });

        $('#payoutSummaryTotal .value').text(Number(total).toLocaleString("es-ES", {minimumFractionDigits: 2}));

        /*
        if ('bank' === paymentType) {
            $('#summaryPaymentBank').show();
            $('#summaryPaymentPaypal').hide();
        } else {
            $('#summaryPaymentBank').hide();
            $('#summaryPaymentPaypal').show();
        }
        */

        sessionStorage.removeItem('payout_items');
    };

    var showStepSummary = function () {
        prepareSummary();
        $('.payoutStep').hide();
        $('#payoutStepSummary').show();
    };

    var payoutCheckBoxesState = function () {
        if ( $('.payoutCheckbox:checked').length ) {
            $('#payoutStepTransactionsNextBtn').removeClass('disabled');
            if ( $('.payoutCheckbox:checked').length === $('.payoutCheckbox').length ) {
                $('#payoutCheckboxAll').prop('checked', true);
            }
        } else {
            $('#payoutStepTransactionsNextBtn').addClass('disabled');
            $('#payoutCheckboxAll').prop('checked', false);
        }
    };

    var paymentRadiosState = function () {
        var input = $('input[name="paymentType"]:checked');
        if ( input.length && '1' == input.attr('data-applicable') ) {
            $('#payoutStepPaymentNextBtn').removeClass('disabled');
        } else {
            $('#payoutStepPaymentNextBtn').addClass('disabled');
        }
    };

    var checkBoxesSwitch = function (state) {
        $('.payoutCheckbox:not([disabled])').prop('checked', state);
        payoutCheckBoxesState();
    };

    var bankDataSaveSuccess = function () {
        var p = $('#payoutPaymentTypeBankDetailsHolder');

        p.find('.userProfileError').hide();
        p.find('input').removeClass('border-danger');

        $('#overlay').hide();
        $('#payoutPaymentTypeBankEditable').hide();
        $('#payoutPaymentTypeBankStatic').show();
        $('#payoutPaymentTypeBankAlert').hide();

        $('input[data-binded="iban"]').val($('#userProfileIBAN').val().trim().slice(0, -4) + '****');
        $('input[data-binded="iban_owner"]').val($('#userProfileIBANOwner').val().trim());

        $('#payoutPaymentTypeBank').attr('data-applicable', '1');
        $('#payoutStepPaymentNextBtn').removeClass('disabled');

        swal({
            type: 'success',
            title: 'Daten wurden erfolgreich geändert',
            toast: true,
            position: 'bottom-end',
            showConfirmButton: false,
            timer: 5000,
        });
    };

    var bankDataSaveError = function (data) {
        var p = $('#payoutPaymentTypeBankDetailsHolder');

        p.find('.userProfileError').hide();
        p.find('input').removeClass('border-danger');

        var bag = data.error || data;
        for (key in bag) {
            var input = p.find('[name="' + key + '"]');
            if (input.length) {
                input.addClass('border-danger');
            }
            var msg = p.find('[data-input="' + key + '"]');
            if (msg.length) {
                msg.show().text(bag[key][0]);
            }
        }
    };

    var bankDataSave = function () {
        $('#overlay').show();
        fetch('/api/change_banking', {
            body: JSON.stringify({
                iban: $('#userProfileIBAN').val().trim(),
                iban_owner: $('#userProfileIBANOwner').val().trim(),
            }),
            headers: {
                'Accept': 'application/json',
            },
            method: 'POST',
        }).then(response => {
            if (response.ok) {
                bankDataSaveSuccess();
            }
            if (401 === response.status || 422 === response.status) {
                return response.json().then(err => {
                    throw err;
                });
            }
        }).catch(error => {
            $('#overlay').hide();
            bankDataSaveError(error);
        });
    };

    var payPalUnbind = function () {
        swal({
            title: 'Bist du sicher?',
            text: '',
            type: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Ja',
            cancelButtonText: 'Nein',
            focusConfirm: false,
            focusCancel: true,
            heightAuto: false,
        }).then((result) => {
            if (result.value) {
                $('#payoutPaymentTypePaypalAlert').show();
                $('#payoutPaymentTypePaypalBinded').hide();
                $('#payoutPaymentTypePaypalUnbinded').show();
                $('#payoutPaymentTypePaypal').attr('data-applicable', '0');
                $('#payoutStepPaymentNextBtn').addClass('disabled');
            }
        });
    };

    var payOut = function () {
        $('#overlay').show();
        fetch('/api/payout', {
            body: JSON.stringify({
                items: payoutItems,
                type: 'bank',
            }),
            headers: {
                'Accept': 'application/json',
            },
            method: 'POST',
        }).then(response => {
            if (response.ok) {
                $('#overlay').hide();
                swal({
                    title: 'Die Auszahlung wurde erfolgreich abgeschlossen',
                    type: 'success',
                    heightAuto: false
                }).then((result) => {
                    window.location.href = '/account';
                });
            }
            if (401 === response.status || 422 === response.status) {
                return response.json().then(err => {
                    throw err;
                });
            }
        }).catch(error => {
            $('#overlay').hide();
            swal({
                title: 'Fehler',
                text: _processAPIError(error).join('<br>'),
                type: 'error',
                heightAuto: false,
            });
        });
    };

    var payOutItemsInit = function () {
        var payoutItemsCache = JSON.parse(sessionStorage.getItem('payout_items'));
        if (null !== payoutItemsCache) {
            for (i in payoutItemsCache) {
                var id = payoutItemsCache[i];
                $('.payoutCheckbox[data-id="' + id + '"]').prop('checked', true).change();
            }
        }
    };

    function getRatingInput() {
        var html =
            '<div id="rateCouponRatingInput" class="ratingInput">' +
                '<div class="ratingInputStars">' +
                    '<div class="rate" data-value="1" data-title="Ungenügend"><i class="fa fa-star"></i></div>' +
                    '<div class="rate" data-value="2" data-title="Mangelhaft"><i class="fa fa-star"></i></div>' +
                    '<div class="rate" data-value="3" data-title="Akzeptabel"><i class="fa fa-star"></i></div>' +
                    '<div class="rate" data-value="4" data-title="Gut"><i class="fa fa-star"></i></div>' +
                    '<div class="rate" data-value="5" data-title="Hervorragend"><i class="fa fa-star"></i></div>' +
                '</div>' +
                '<div class="ratingInputTitle">' +
                    '<span>Nicht Bewertet</span>' +
                '</div>' +
            '</div>';

        return html;
    }

    function getRateDealHTML() {
        var rating =
            '<div id="rateDealRatingInput" class="ratingInput">' +
                '<div class="ratingInputStars">' +
                    '<div class="rate" data-value="1" data-title="Ungenügend"><i class="fa fa-star"></i></div>' +
                    '<div class="rate" data-value="2" data-title="Mangelhaft"><i class="fa fa-star"></i></div>' +
                    '<div class="rate" data-value="3" data-title="Akzeptabel"><i class="fa fa-star"></i></div>' +
                    '<div class="rate" data-value="4" data-title="Gut"><i class="fa fa-star"></i></div>' +
                    '<div class="rate" data-value="5" data-title="Hervorragend"><i class="fa fa-star"></i></div>' +
                '</div>' +
                '<div id="rate" class="ratingInputTitle">' +
                    '<span>Nicht Bewertet</span>' +
                '</div>' +
            '</div>';

        var review =
            '<div class="interactiveTextBarHolder" data-color-start="#f18407" data-color-end="#63d645" data-stop-10="Klasse, Du bist eine große Hilfe." data-stop-5="Du bist auf einem guten Weg unseren Nutzern zu helfen." data-stop-2="Sei nicht schüchtern, erzähl uns etwas mehr.">' +
                '<textarea id="rateDealReviewInput" class="interactiveTextBar ratingTextarea" placeholder="Sag uns Deine ehrliche Meinung und helfe so anderen die richtige Entscheidung zu treffen."></textarea>' +
                '<div class="interactiveTextBarProgress"></div>' +
                '<div class="interactiveTextBarHint">&nbsp;</div>' +
            '</div>';

        return '<div>' + rating + review + '</div>';
    }

    var getTextBarMap = function (attrs) {
        var map = {};

        for (var i = 0, l = attrs.length; i < l; i++) {
            var attr = attrs.item(i);
            var name = attr.name;
            if (-1 !== name.indexOf('data-stop-')) {
                map[name.split('data-stop-')[1]] = attr.value;
            }
        }

        return map;
    };

    var getTextBarPhrase = function (map, words) {
        var keys = Object.keys(map);

        for (var i = keys.length - 1; i > 0; i--) {
            if ( words >= parseInt(keys[i]) ) {
                return map[keys[i]];
            }
        }

        return map[keys[0]];
    };

    var getTextBarColor = function (start, end, coeff) {
        var final = "#";

        for (var i = 0; i < 3; i++) {
            var sub1 = start.substring(1 + 2 * i, 3 + 2 * i);
            var sub2 = end.substring(1 + 2 * i, 3 + 2 * i);
            var v1 = parseInt(sub1, 16);
            var v2 = parseInt(sub2, 16);
            var v = Math.floor(v1 + (v2 - v1) * coeff);
            var sub = v.toString(16).toUpperCase();
            var padsub = ('0' + sub).slice(-2);
            final += padsub;
        }

        return final;
    };

    $(document).on('change focus keyup', '.interactiveTextBar', function () {
        var textarea = $(this);
        var holder = textarea.closest('.interactiveTextBarHolder');
        var attrs = holder[0].attributes;
        var progress = holder.find('.interactiveTextBarProgress');
        var hint = holder.find('.interactiveTextBarHint');
        var text = textarea.val().trim();
        var words = text.length ? text.match(/\S+/g).length : 0;
        var map = getTextBarMap(attrs);
        var max = Math.max.apply(null, Object.keys(map));
        var percentage = words / max;
        if (percentage > 1) {
            percentage = 1;
        }
        var start = holder.attr('data-color-start');
        var end = holder.attr('data-color-end');
        var phrase = getTextBarPhrase(map, words);
        var color = getTextBarColor(start, end, percentage);

        progress.css('width', Math.round(100 * percentage) + '%');
        progress.css('background-color', color);
        hint.text(phrase);
    });

    function rateCoupon(couponId) {
        swal({
            title: 'Bitte bewerten einen RECO.BON',
            heightAuto: false,
            html: getRatingInput(),
            input: 'textarea',
            showCancelButton: true,
            allowOutsideClick: () => !swal.isLoading(),
            showLoaderOnConfirm: true,
            preConfirm: (text) => {
                var ratingEl = $('#rateCouponRatingInput .rate.active').last();
                if ( !ratingEl.length ) {
                    swal.showValidationMessage('Wählen Sie die Bewertung.');
                } else if (!text.length) {
                    swal.showValidationMessage('Bewertung muss ausgefüllt sein.');
                } else {
                    return fetch('/api/coupon/' + couponId + '/rate/', {
                        body: JSON.stringify({
                            rating: parseInt(ratingEl.data('value')),
                            text: text,
                        }),
                        headers: {
                            'Accept': 'application/json',
                        },
                        method: 'POST',
                    }).then(response => {
                        if (response.ok) {
                            return response.json();
                        }
                        if (401 === response.status || 422 === response.status) {
                            return response.json().then(err => {
                                throw err;
                            });
                        }
                    }).catch(error => {
                        swal.showValidationMessage(_processAPIError(error).join('<br>'));
                    })
                }
            }
        }).then(result => {
            if (result.value) {
                location.reload();
            }
        });
    }

    function rateDeal(dealId, dealTitle) {
        swal({
            title: 'Deine Meinung ist uns wichtig - jetzt "' + dealTitle + '" bewerten',
            heightAuto: false,
            html: getRateDealHTML(),
            showCancelButton: true,
            cancelButtonText: 'Später',
            allowOutsideClick: () => !swal.isLoading(),
            showLoaderOnConfirm: true,
            preConfirm: () => {
                var ratingEl = $('#rateDealRatingInput .rate.active').last();
                var text = $('#rateDealReviewInput').val();
                if (!ratingEl.length) {
                    swal.showValidationMessage('Bitte gib deine Sternebewertung ab.');
                } else if (!text.length) {
                    swal.showValidationMessage('Erzähl uns noch Deine Meinung.');
                } else if (text.match(/\S+/g).length < 10) {
                    swal.showValidationMessage('Bewertung muss mindestens 10 Wörter haben.');
                } else {
                    return fetch('/api/deal/' + dealId + '/rate/', {
                        body: JSON.stringify({
                            rating: parseInt(ratingEl.data('value')),
                            text: text,
                        }),
                        headers: {
                            'Accept': 'application/json',
                        },
                        method: 'POST',
                    }).then(response => {
                        if (response.ok) {
                            return response.json();
                        }
                        if (401 === response.status || 422 === response.status) {
                            return response.json().then(err => {
                                throw err;
                            });
                        }
                    }).catch(error => {
                        swal.showValidationMessage(_processAPIError(error).join('<br>'));
                    })
                }
            }
        }).then(result => {
            if (result.value) {
                location.reload();
            }
        });
    }

    $(document).on('click', '.rateCoupon', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var couponId = $(this).data('coupon-id');

        rateCoupon(couponId);
    });

    $(document).on('click', '.rateDeal', function (e) {
        e.preventDefault();
        e.stopPropagation();

        var dealId = $(this).data('deal-id');
        var dealTitle = $(this).data('deal-title');

        rateDeal(dealId, dealTitle);
    });


    $(document).on('mouseenter', '.ratingInput .rate', function () {
        $(this).prevAll('.rate').addClass('hover');
        $(this).addClass('hover');
        $(this).closest('.ratingInput').find('.ratingInputTitle').text($(this).data('title'));
    });

    $(document).on('mouseleave', '.ratingInput .rate', function () {
        $(this).closest('.ratingInput').find('.rate').removeClass('hover');
        var el = $(this).closest('.ratingInput').find('.rate.active').last();
        var title = el.length ? el.data('title') : 'Nicht Bewertet';
        $(this).closest('.ratingInput').find('.ratingInputTitle').text(title);
    });

    $(document).on('click', '.ratingInput .rate', function () {
        $(this).closest('.ratingInput').find('.rate').removeClass('active');
        $(this).prevAll('.rate').addClass('active');
        $(this).addClass('active');
        $(this).closest('.ratingInput').find('.ratingInputTitle').text($(this).data('title'));
    });

    $('#payoutCheckboxAll').on('change', function () {
        checkBoxesSwitch($(this).prop('checked'));
    });

    $('#payoutStepTransactionsNextBtn').on('click', function () {
        if ( !$(this).hasClass('disabled') ) {
            showStepPayment();
        }
    });

    $('#payoutStepPaymentPrevBtn').on('click', function () {
        showStepTransactions();
    });

    $('.payoutCheckbox').on('change', function () {
        payoutCheckBoxesState();
    });

    $('#payoutPaymentTypeBank').on('click', function () {
        $('#payoutPaymentTypePaypalDetailsHolder').hide();
        $('#payoutPaymentTypeBankDetailsHolder').show();
    });

    $('#payoutPaymentTypePaypal').on('click', function () {
        $('#payoutPaymentTypeBankDetailsHolder').hide();
        $('#payoutPaymentTypePaypalDetailsHolder').show();
    });

    $('#payoutPaymentTypeBankEditBtn').on('click', function () {
        $('#payoutPaymentTypeBankStatic').hide();
        $('#payoutPaymentTypeBankEditable').show();
    });

    $('#payoutPaymentTypeBankCancelBtn').on('click', function () {
        $('#payoutPaymentTypeBankEditable').hide();
        $('#payoutPaymentTypeBankStatic').show();
    });

    $('#payoutPaymentTypeBankSaveBtn').on('click', function () {
        bankDataSave();
    });

    $('input[name="paymentType"]').on('change', function () {
        paymentType = $(this).val();
        paymentRadiosState();
    });

    $('#payoutStepPaymentNextBtn').on('click', function () {
        if ( !$(this).hasClass('disabled') ) {
            showStepSummary();
        }
    });

    $('#payoutStepSummaryPrevBtn').on('click', function () {
        showStepPayment();
    });

    $('#payPalUnbindBtn').on('click', function () {
        payPalUnbind();
    });

    $('#payoutStepSummaryNextBtn').on('click', function () {
        payOut();
    });

    $('#overlay').hide();

    if (/[?&]p/.test(location.search)) {
        payOutItemsInit();
        showStepPayment();
        $('#payoutPaymentTypePaypal').click();
    } else {
        showStepTransactions();
    }
});